// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyDBInstance.
 */
class ModifyDbInstanceRequest private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether the modifications in this request and any pending modifications are
     * asynchronously applied as soon as possible, regardless of the
     * PreferredMaintenanceWindow setting for the instance.
     * If this parameter is set to false, changes to the instance are
     * applied during the next maintenance window. Some parameter changes can cause an outage
     * and are applied on the next reboot.
     * Default: false
     */
    val applyImmediately: Boolean = builder.applyImmediately
    /**
     * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     */
    val autoMinorVersionUpgrade: Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Indicates the certificate that needs to be associated with the instance.
     */
    val caCertificateIdentifier: String? = builder.caCertificateIdentifier
    /**
     * The new compute and memory capacity of the instance; for example, db.r5.large. Not all instance classes are available in all Regions.
     * If you modify the instance class, an outage occurs during the change. The change is
     * applied during the next maintenance window, unless ApplyImmediately is
     * specified as true for this request.
     * Default: Uses existing setting.
     */
    val dbInstanceClass: String? = builder.dbInstanceClass
    /**
     * The instance identifier. This value is stored as a lowercase string.
     * Constraints:
     * Must match the identifier of an existing DBInstance.
     */
    val dbInstanceIdentifier: String? = builder.dbInstanceIdentifier
    /**
     * The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set Apply Immediately to true. It occurs during the next maintenance window if you set Apply Immediately to false. This value is stored as a lowercase string.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: mydbinstance
     */
    val newDbInstanceIdentifier: String? = builder.newDbInstanceIdentifier
    /**
     * The weekly time range (in UTC) during which system maintenance can occur, which might
     * result in an outage. Changing this parameter doesn't result in an outage except in the
     * following situation, and the change is asynchronously applied as soon as possible. If
     * there are pending actions that cause a reboot, and the maintenance window is changed to
     * include the current time, changing this parameter causes a reboot of the instance. If
     * you are moving this window to the current time, there must be at least 30 minutes
     * between the current time and end of the window to ensure that pending changes are
     * applied.
     * Default: Uses existing setting.
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * Constraints: Must be at least 30 minutes.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
     * Default: 1
     * Valid values: 0-15
     */
    val promotionTier: Int? = builder.promotionTier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyDbInstanceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbInstanceRequest(")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("newDbInstanceIdentifier=$newDbInstanceIdentifier,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (newDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyDbInstanceRequest

        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (newDbInstanceIdentifier != other.newDbInstanceIdentifier) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyDbInstanceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyDbInstanceRequest
        /**
         * Specifies whether the modifications in this request and any pending modifications are
         * asynchronously applied as soon as possible, regardless of the
         * PreferredMaintenanceWindow setting for the instance.
         * If this parameter is set to false, changes to the instance are
         * applied during the next maintenance window. Some parameter changes can cause an outage
         * and are applied on the next reboot.
         * Default: false
         */
        fun applyImmediately(applyImmediately: Boolean): FluentBuilder
        /**
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         */
        fun autoMinorVersionUpgrade(autoMinorVersionUpgrade: Boolean): FluentBuilder
        /**
         * Indicates the certificate that needs to be associated with the instance.
         */
        fun caCertificateIdentifier(caCertificateIdentifier: String): FluentBuilder
        /**
         * The new compute and memory capacity of the instance; for example, db.r5.large. Not all instance classes are available in all Regions.
         * If you modify the instance class, an outage occurs during the change. The change is
         * applied during the next maintenance window, unless ApplyImmediately is
         * specified as true for this request.
         * Default: Uses existing setting.
         */
        fun dbInstanceClass(dbInstanceClass: String): FluentBuilder
        /**
         * The instance identifier. This value is stored as a lowercase string.
         * Constraints:
         * Must match the identifier of an existing DBInstance.
         */
        fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder
        /**
         * The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set Apply Immediately to true. It occurs during the next maintenance window if you set Apply Immediately to false. This value is stored as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: mydbinstance
         */
        fun newDbInstanceIdentifier(newDbInstanceIdentifier: String): FluentBuilder
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, which might
         * result in an outage. Changing this parameter doesn't result in an outage except in the
         * following situation, and the change is asynchronously applied as soon as possible. If
         * there are pending actions that cause a reboot, and the maintenance window is changed to
         * include the current time, changing this parameter causes a reboot of the instance. If
         * you are moving this window to the current time, there must be at least 30 minutes
         * between the current time and end of the window to ensure that pending changes are
         * applied.
         * Default: Uses existing setting.
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Must be at least 30 minutes.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
         * Default: 1
         * Valid values: 0-15
         */
        fun promotionTier(promotionTier: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether the modifications in this request and any pending modifications are
         * asynchronously applied as soon as possible, regardless of the
         * PreferredMaintenanceWindow setting for the instance.
         * If this parameter is set to false, changes to the instance are
         * applied during the next maintenance window. Some parameter changes can cause an outage
         * and are applied on the next reboot.
         * Default: false
         */
        var applyImmediately: Boolean
        /**
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         */
        var autoMinorVersionUpgrade: Boolean?
        /**
         * Indicates the certificate that needs to be associated with the instance.
         */
        var caCertificateIdentifier: String?
        /**
         * The new compute and memory capacity of the instance; for example, db.r5.large. Not all instance classes are available in all Regions.
         * If you modify the instance class, an outage occurs during the change. The change is
         * applied during the next maintenance window, unless ApplyImmediately is
         * specified as true for this request.
         * Default: Uses existing setting.
         */
        var dbInstanceClass: String?
        /**
         * The instance identifier. This value is stored as a lowercase string.
         * Constraints:
         * Must match the identifier of an existing DBInstance.
         */
        var dbInstanceIdentifier: String?
        /**
         * The new instance identifier for the instance when renaming an instance. When you change the instance identifier, an instance reboot occurs immediately if you set Apply Immediately to true. It occurs during the next maintenance window if you set Apply Immediately to false. This value is stored as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: mydbinstance
         */
        var newDbInstanceIdentifier: String?
        /**
         * The weekly time range (in UTC) during which system maintenance can occur, which might
         * result in an outage. Changing this parameter doesn't result in an outage except in the
         * following situation, and the change is asynchronously applied as soon as possible. If
         * there are pending actions that cause a reboot, and the maintenance window is changed to
         * include the current time, changing this parameter causes a reboot of the instance. If
         * you are moving this window to the current time, there must be at least 30 minutes
         * between the current time and end of the window to ensure that pending changes are
         * applied.
         * Default: Uses existing setting.
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Must be at least 30 minutes.
         */
        var preferredMaintenanceWindow: String?
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the primary instance after a failure of the existing primary instance.
         * Default: 1
         * Valid values: 0-15
         */
        var promotionTier: Int?

        fun build(): ModifyDbInstanceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applyImmediately: Boolean = false
        override var autoMinorVersionUpgrade: Boolean? = null
        override var caCertificateIdentifier: String? = null
        override var dbInstanceClass: String? = null
        override var dbInstanceIdentifier: String? = null
        override var newDbInstanceIdentifier: String? = null
        override var preferredMaintenanceWindow: String? = null
        override var promotionTier: Int? = null

        constructor(x: ModifyDbInstanceRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.newDbInstanceIdentifier = x.newDbInstanceIdentifier
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
        }

        override fun build(): ModifyDbInstanceRequest = ModifyDbInstanceRequest(this)
        override fun applyImmediately(applyImmediately: Boolean): FluentBuilder = apply { this.applyImmediately = applyImmediately }
        override fun autoMinorVersionUpgrade(autoMinorVersionUpgrade: Boolean): FluentBuilder = apply { this.autoMinorVersionUpgrade = autoMinorVersionUpgrade }
        override fun caCertificateIdentifier(caCertificateIdentifier: String): FluentBuilder = apply { this.caCertificateIdentifier = caCertificateIdentifier }
        override fun dbInstanceClass(dbInstanceClass: String): FluentBuilder = apply { this.dbInstanceClass = dbInstanceClass }
        override fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder = apply { this.dbInstanceIdentifier = dbInstanceIdentifier }
        override fun newDbInstanceIdentifier(newDbInstanceIdentifier: String): FluentBuilder = apply { this.newDbInstanceIdentifier = newDbInstanceIdentifier }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun promotionTier(promotionTier: Int): FluentBuilder = apply { this.promotionTier = promotionTier }
    }
}
