// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyDBClusterSnapshotAttribute.
 */
class ModifyDbClusterSnapshotAttributeRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the cluster snapshot attribute to modify.
     * To manage authorization for other accounts to copy or restore a manual cluster
     * snapshot, set this value to restore.
     */
    val attributeName: String? = builder.attributeName
    /**
     * The identifier for the cluster snapshot to modify the attributes for.
     */
    val dbClusterSnapshotIdentifier: String? = builder.dbClusterSnapshotIdentifier
    /**
     * A list of cluster snapshot attributes to add to the attribute specified by AttributeName.
     * To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to all. Do not add the all value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.
     */
    val valuesToAdd: List<String>? = builder.valuesToAdd
    /**
     * A list of cluster snapshot attributes to remove from the attribute specified by AttributeName.
     * To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to all . If you specify all, an account whose account ID is explicitly added to the restore attribute can still copy or restore a manual cluster snapshot.
     */
    val valuesToRemove: List<String>? = builder.valuesToRemove

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyDbClusterSnapshotAttributeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterSnapshotAttributeRequest(")
        append("attributeName=$attributeName,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("valuesToAdd=$valuesToAdd,")
        append("valuesToRemove=$valuesToRemove)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (valuesToAdd?.hashCode() ?: 0)
        result = 31 * result + (valuesToRemove?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyDbClusterSnapshotAttributeRequest

        if (attributeName != other.attributeName) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (valuesToAdd != other.valuesToAdd) return false
        if (valuesToRemove != other.valuesToRemove) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyDbClusterSnapshotAttributeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyDbClusterSnapshotAttributeRequest
        /**
         * The name of the cluster snapshot attribute to modify.
         * To manage authorization for other accounts to copy or restore a manual cluster
         * snapshot, set this value to restore.
         */
        fun attributeName(attributeName: String): FluentBuilder
        /**
         * The identifier for the cluster snapshot to modify the attributes for.
         */
        fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder
        /**
         * A list of cluster snapshot attributes to add to the attribute specified by AttributeName.
         * To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to all. Do not add the all value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.
         */
        fun valuesToAdd(valuesToAdd: List<String>): FluentBuilder
        /**
         * A list of cluster snapshot attributes to remove from the attribute specified by AttributeName.
         * To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to all . If you specify all, an account whose account ID is explicitly added to the restore attribute can still copy or restore a manual cluster snapshot.
         */
        fun valuesToRemove(valuesToRemove: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the cluster snapshot attribute to modify.
         * To manage authorization for other accounts to copy or restore a manual cluster
         * snapshot, set this value to restore.
         */
        var attributeName: String?
        /**
         * The identifier for the cluster snapshot to modify the attributes for.
         */
        var dbClusterSnapshotIdentifier: String?
        /**
         * A list of cluster snapshot attributes to add to the attribute specified by AttributeName.
         * To authorize other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account IDs. To make the manual cluster snapshot restorable by any account, set it to all. Do not add the all value for any manual cluster snapshots that contain private information that you don't want to be available to all accounts.
         */
        var valuesToAdd: List<String>?
        /**
         * A list of cluster snapshot attributes to remove from the attribute specified by AttributeName.
         * To remove authorization for other accounts to copy or restore a manual cluster snapshot, set this list to include one or more account identifiers. To remove authorization for any account to copy or restore the cluster snapshot, set it to all . If you specify all, an account whose account ID is explicitly added to the restore attribute can still copy or restore a manual cluster snapshot.
         */
        var valuesToRemove: List<String>?

        fun build(): ModifyDbClusterSnapshotAttributeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attributeName: String? = null
        override var dbClusterSnapshotIdentifier: String? = null
        override var valuesToAdd: List<String>? = null
        override var valuesToRemove: List<String>? = null

        constructor(x: ModifyDbClusterSnapshotAttributeRequest) : this() {
            this.attributeName = x.attributeName
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.valuesToAdd = x.valuesToAdd
            this.valuesToRemove = x.valuesToRemove
        }

        override fun build(): ModifyDbClusterSnapshotAttributeRequest = ModifyDbClusterSnapshotAttributeRequest(this)
        override fun attributeName(attributeName: String): FluentBuilder = apply { this.attributeName = attributeName }
        override fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder = apply { this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier }
        override fun valuesToAdd(valuesToAdd: List<String>): FluentBuilder = apply { this.valuesToAdd = valuesToAdd }
        override fun valuesToRemove(valuesToRemove: List<String>): FluentBuilder = apply { this.valuesToRemove = valuesToRemove }
    }
}
