// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ModifyDBCluster.
 */
class ModifyDbClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * A value that specifies whether the changes in this request and any pending changes are
     * asynchronously applied as soon as possible, regardless of the
     * PreferredMaintenanceWindow setting for the cluster. If this
     * parameter is set to false, changes to the cluster are applied during the
     * next maintenance window.
     * The ApplyImmediately parameter affects only the
     * NewDBClusterIdentifier and MasterUserPassword values. If
     * you set this parameter value to false, the changes to the
     * NewDBClusterIdentifier and MasterUserPassword values are
     * applied during the next maintenance window. All other changes are applied immediately,
     * regardless of the value of the ApplyImmediately parameter.
     * Default: false
     */
    val applyImmediately: Boolean = builder.applyImmediately
    /**
     * The number of days for which automated backups are retained. You must specify a
     * minimum value of 1.
     * Default: 1
     * Constraints:
     * Must be a value from 1 to 35.
     */
    val backupRetentionPeriod: Int? = builder.backupRetentionPeriod
    /**
     * The configuration setting for the log types to be enabled for export to Amazon
     * CloudWatch Logs for a specific instance or cluster. The
     * EnableLogTypes and DisableLogTypes arrays determine which
     * logs are exported (or not exported) to CloudWatch Logs.
     */
    val cloudwatchLogsExportConfiguration: CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * The cluster identifier for the cluster that is being modified. This parameter is
     * not case sensitive.
     * Constraints:
     * Must match the identifier of an existing DBCluster.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The name of the cluster parameter group to use for the cluster.
     */
    val dbClusterParameterGroupName: String? = builder.dbClusterParameterGroupName
    /**
     * Specifies whether this cluster can be deleted. If DeletionProtection is
     * enabled, the cluster cannot be deleted unless it is modified and
     * DeletionProtection is disabled. DeletionProtection
     * protects clusters from being accidentally deleted.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * The password for the master database user. This password can contain any printable
     * ASCII character except forward slash (/), double quote ("), or the "at" symbol
     * (@).
     * Constraints: Must contain from 8 to 100 characters.
     */
    val masterUserPassword: String? = builder.masterUserPassword
    /**
     * The new cluster identifier for the cluster when renaming a cluster. This
     * value is stored as a lowercase string.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: my-cluster2
     */
    val newDbClusterIdentifier: String? = builder.newDbClusterIdentifier
    /**
     * The port number on which the cluster accepts connections.
     * Constraints: Must be a value from 1150 to 65535.
     * Default: The same port as the original cluster.
     */
    val port: Int? = builder.port
    /**
     * The daily time range during which automated backups are created if automated backups
     * are enabled, using the BackupRetentionPeriod parameter.
     * The default is a 30-minute window selected at random from an 8-hour block of time for
     * each Region.
     * Constraints:
     * Must be in the format hh24:mi-hh24:mi.
     * Must be in Universal Coordinated Time (UTC).
     * Must not conflict with the preferred maintenance window.
     * Must be at least 30 minutes.
     */
    val preferredBackupWindow: String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal
     * Coordinated Time (UTC).
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * The default is a 30-minute window selected at random from an 8-hour block of time for
     * each Region, occurring on a random day of the week.
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * A list of virtual private cloud (VPC) security groups that the cluster will belong
     * to.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ModifyDbClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbClusterRequest(")
        append("applyImmediately=$applyImmediately,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("engineVersion=$engineVersion,")
        append("masterUserPassword=$masterUserPassword,")
        append("newDbClusterIdentifier=$newDbClusterIdentifier,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately.hashCode()
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (newDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ModifyDbClusterRequest

        if (applyImmediately != other.applyImmediately) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engineVersion != other.engineVersion) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (newDbClusterIdentifier != other.newDbClusterIdentifier) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ModifyDbClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ModifyDbClusterRequest
        /**
         * A value that specifies whether the changes in this request and any pending changes are
         * asynchronously applied as soon as possible, regardless of the
         * PreferredMaintenanceWindow setting for the cluster. If this
         * parameter is set to false, changes to the cluster are applied during the
         * next maintenance window.
         * The ApplyImmediately parameter affects only the
         * NewDBClusterIdentifier and MasterUserPassword values. If
         * you set this parameter value to false, the changes to the
         * NewDBClusterIdentifier and MasterUserPassword values are
         * applied during the next maintenance window. All other changes are applied immediately,
         * regardless of the value of the ApplyImmediately parameter.
         * Default: false
         */
        fun applyImmediately(applyImmediately: Boolean): FluentBuilder
        /**
         * The number of days for which automated backups are retained. You must specify a
         * minimum value of 1.
         * Default: 1
         * Constraints:
         * Must be a value from 1 to 35.
         */
        fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder
        /**
         * The configuration setting for the log types to be enabled for export to Amazon
         * CloudWatch Logs for a specific instance or cluster. The
         * EnableLogTypes and DisableLogTypes arrays determine which
         * logs are exported (or not exported) to CloudWatch Logs.
         */
        fun cloudwatchLogsExportConfiguration(cloudwatchLogsExportConfiguration: CloudwatchLogsExportConfiguration): FluentBuilder
        /**
         * The cluster identifier for the cluster that is being modified. This parameter is
         * not case sensitive.
         * Constraints:
         * Must match the identifier of an existing DBCluster.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The name of the cluster parameter group to use for the cluster.
         */
        fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * DeletionProtection is disabled. DeletionProtection
         * protects clusters from being accidentally deleted.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * The password for the master database user. This password can contain any printable
         * ASCII character except forward slash (/), double quote ("), or the "at" symbol
         * (@).
         * Constraints: Must contain from 8 to 100 characters.
         */
        fun masterUserPassword(masterUserPassword: String): FluentBuilder
        /**
         * The new cluster identifier for the cluster when renaming a cluster. This
         * value is stored as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster2
         */
        fun newDbClusterIdentifier(newDbClusterIdentifier: String): FluentBuilder
        /**
         * The port number on which the cluster accepts connections.
         * Constraints: Must be a value from 1150 to 65535.
         * Default: The same port as the original cluster.
         */
        fun port(port: Int): FluentBuilder
        /**
         * The daily time range during which automated backups are created if automated backups
         * are enabled, using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region.
         * Constraints:
         * Must be in the format hh24:mi-hh24:mi.
         * Must be in Universal Coordinated Time (UTC).
         * Must not conflict with the preferred maintenance window.
         * Must be at least 30 minutes.
         */
        fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder
        /**
         * The weekly time range during which system maintenance can occur, in Universal
         * Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * A list of virtual private cloud (VPC) security groups that the cluster will belong
         * to.
         */
        fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A value that specifies whether the changes in this request and any pending changes are
         * asynchronously applied as soon as possible, regardless of the
         * PreferredMaintenanceWindow setting for the cluster. If this
         * parameter is set to false, changes to the cluster are applied during the
         * next maintenance window.
         * The ApplyImmediately parameter affects only the
         * NewDBClusterIdentifier and MasterUserPassword values. If
         * you set this parameter value to false, the changes to the
         * NewDBClusterIdentifier and MasterUserPassword values are
         * applied during the next maintenance window. All other changes are applied immediately,
         * regardless of the value of the ApplyImmediately parameter.
         * Default: false
         */
        var applyImmediately: Boolean
        /**
         * The number of days for which automated backups are retained. You must specify a
         * minimum value of 1.
         * Default: 1
         * Constraints:
         * Must be a value from 1 to 35.
         */
        var backupRetentionPeriod: Int?
        /**
         * The configuration setting for the log types to be enabled for export to Amazon
         * CloudWatch Logs for a specific instance or cluster. The
         * EnableLogTypes and DisableLogTypes arrays determine which
         * logs are exported (or not exported) to CloudWatch Logs.
         */
        var cloudwatchLogsExportConfiguration: CloudwatchLogsExportConfiguration?
        /**
         * The cluster identifier for the cluster that is being modified. This parameter is
         * not case sensitive.
         * Constraints:
         * Must match the identifier of an existing DBCluster.
         */
        var dbClusterIdentifier: String?
        /**
         * The name of the cluster parameter group to use for the cluster.
         */
        var dbClusterParameterGroupName: String?
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * DeletionProtection is disabled. DeletionProtection
         * protects clusters from being accidentally deleted.
         */
        var deletionProtection: Boolean?
        /**
         * The version number of the database engine to which you want to upgrade. Modifying engine version is not supported on Amazon DocumentDB.
         */
        var engineVersion: String?
        /**
         * The password for the master database user. This password can contain any printable
         * ASCII character except forward slash (/), double quote ("), or the "at" symbol
         * (@).
         * Constraints: Must contain from 8 to 100 characters.
         */
        var masterUserPassword: String?
        /**
         * The new cluster identifier for the cluster when renaming a cluster. This
         * value is stored as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster2
         */
        var newDbClusterIdentifier: String?
        /**
         * The port number on which the cluster accepts connections.
         * Constraints: Must be a value from 1150 to 65535.
         * Default: The same port as the original cluster.
         */
        var port: Int?
        /**
         * The daily time range during which automated backups are created if automated backups
         * are enabled, using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region.
         * Constraints:
         * Must be in the format hh24:mi-hh24:mi.
         * Must be in Universal Coordinated Time (UTC).
         * Must not conflict with the preferred maintenance window.
         * Must be at least 30 minutes.
         */
        var preferredBackupWindow: String?
        /**
         * The weekly time range during which system maintenance can occur, in Universal
         * Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: String?
        /**
         * A list of virtual private cloud (VPC) security groups that the cluster will belong
         * to.
         */
        var vpcSecurityGroupIds: List<String>?

        fun build(): ModifyDbClusterRequest
        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        fun cloudwatchLogsExportConfiguration(block: CloudwatchLogsExportConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applyImmediately: Boolean = false
        override var backupRetentionPeriod: Int? = null
        override var cloudwatchLogsExportConfiguration: CloudwatchLogsExportConfiguration? = null
        override var dbClusterIdentifier: String? = null
        override var dbClusterParameterGroupName: String? = null
        override var deletionProtection: Boolean? = null
        override var engineVersion: String? = null
        override var masterUserPassword: String? = null
        override var newDbClusterIdentifier: String? = null
        override var port: Int? = null
        override var preferredBackupWindow: String? = null
        override var preferredMaintenanceWindow: String? = null
        override var vpcSecurityGroupIds: List<String>? = null

        constructor(x: ModifyDbClusterRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.deletionProtection = x.deletionProtection
            this.engineVersion = x.engineVersion
            this.masterUserPassword = x.masterUserPassword
            this.newDbClusterIdentifier = x.newDbClusterIdentifier
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        override fun build(): ModifyDbClusterRequest = ModifyDbClusterRequest(this)
        override fun applyImmediately(applyImmediately: Boolean): FluentBuilder = apply { this.applyImmediately = applyImmediately }
        override fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder = apply { this.backupRetentionPeriod = backupRetentionPeriod }
        override fun cloudwatchLogsExportConfiguration(cloudwatchLogsExportConfiguration: CloudwatchLogsExportConfiguration): FluentBuilder = apply { this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder = apply { this.dbClusterParameterGroupName = dbClusterParameterGroupName }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun masterUserPassword(masterUserPassword: String): FluentBuilder = apply { this.masterUserPassword = masterUserPassword }
        override fun newDbClusterIdentifier(newDbClusterIdentifier: String): FluentBuilder = apply { this.newDbClusterIdentifier = newDbClusterIdentifier }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder = apply { this.preferredBackupWindow = preferredBackupWindow }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder = apply { this.vpcSecurityGroupIds = vpcSecurityGroupIds }
    }
}
