// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * A data structure with information about any primary and secondary clusters associated with an Amazon DocumentDB global clusters.
 */
class GlobalClusterMember private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.
     */
    val dbClusterArn: String? = builder.dbClusterArn
    /**
     * Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated.
     */
    val isWriter: Boolean = builder.isWriter
    /**
     * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.
     */
    val readers: List<String>? = builder.readers

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GlobalClusterMember = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalClusterMember(")
        append("dbClusterArn=$dbClusterArn,")
        append("isWriter=$isWriter,")
        append("readers=$readers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterArn?.hashCode() ?: 0
        result = 31 * result + (isWriter.hashCode())
        result = 31 * result + (readers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GlobalClusterMember

        if (dbClusterArn != other.dbClusterArn) return false
        if (isWriter != other.isWriter) return false
        if (readers != other.readers) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GlobalClusterMember = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GlobalClusterMember
        /**
         * The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.
         */
        fun dbClusterArn(dbClusterArn: String): FluentBuilder
        /**
         * Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated.
         */
        fun isWriter(isWriter: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.
         */
        fun readers(readers: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) for each Amazon DocumentDB cluster.
         */
        var dbClusterArn: String?
        /**
         * Specifies whether the Amazon DocumentDB cluster is the primary cluster (that is, has read-write capability) for the Amazon DocumentDB global cluster with which it is associated.
         */
        var isWriter: Boolean
        /**
         * The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global cluster.
         */
        var readers: List<String>?

        fun build(): GlobalClusterMember
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterArn: String? = null
        override var isWriter: Boolean = false
        override var readers: List<String>? = null

        constructor(x: GlobalClusterMember) : this() {
            this.dbClusterArn = x.dbClusterArn
            this.isWriter = x.isWriter
            this.readers = x.readers
        }

        override fun build(): GlobalClusterMember = GlobalClusterMember(this)
        override fun dbClusterArn(dbClusterArn: String): FluentBuilder = apply { this.dbClusterArn = dbClusterArn }
        override fun isWriter(isWriter: Boolean): FluentBuilder = apply { this.isWriter = isWriter }
        override fun readers(readers: List<String>): FluentBuilder = apply { this.readers = readers }
    }
}
