// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * A data type representing an Amazon DocumentDB global cluster.
 */
class GlobalCluster private constructor(builder: BuilderImpl) {
    /**
     * The default database name within the new global cluster.
     */
    val databaseName: String? = builder.databaseName
    /**
     * The deletion protection setting for the new global cluster.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * The Amazon DocumentDB database engine used by the global cluster.
     */
    val engine: String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * The Amazon Resource Name (ARN) for the global cluster.
     */
    val globalClusterArn: String? = builder.globalClusterArn
    /**
     * Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster.
     */
    val globalClusterIdentifier: String? = builder.globalClusterIdentifier
    /**
     * The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item.
     */
    val globalClusterMembers: List<GlobalClusterMember>? = builder.globalClusterMembers
    /**
     * The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed.
     */
    val globalClusterResourceId: String? = builder.globalClusterResourceId
    /**
     * Specifies the current state of this global cluster.
     */
    val status: String? = builder.status
    /**
     * The storage encryption setting for the global cluster.
     */
    val storageEncrypted: Boolean? = builder.storageEncrypted

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GlobalCluster = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalCluster(")
        append("databaseName=$databaseName,")
        append("deletionProtection=$deletionProtection,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterArn=$globalClusterArn,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("globalClusterMembers=$globalClusterMembers,")
        append("globalClusterResourceId=$globalClusterResourceId,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterArn?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (globalClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (globalClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GlobalCluster

        if (databaseName != other.databaseName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterArn != other.globalClusterArn) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (globalClusterMembers != other.globalClusterMembers) return false
        if (globalClusterResourceId != other.globalClusterResourceId) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GlobalCluster = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GlobalCluster
        /**
         * The default database name within the new global cluster.
         */
        fun databaseName(databaseName: String): FluentBuilder
        /**
         * The deletion protection setting for the new global cluster.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The Amazon DocumentDB database engine used by the global cluster.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * Indicates the database engine version.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the global cluster.
         */
        fun globalClusterArn(globalClusterArn: String): FluentBuilder
        /**
         * Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster.
         */
        fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder
        /**
         * The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item.
         */
        fun globalClusterMembers(globalClusterMembers: List<GlobalClusterMember>): FluentBuilder
        /**
         * The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed.
         */
        fun globalClusterResourceId(globalClusterResourceId: String): FluentBuilder
        /**
         * Specifies the current state of this global cluster.
         */
        fun status(status: String): FluentBuilder
        /**
         * The storage encryption setting for the global cluster.
         */
        fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The default database name within the new global cluster.
         */
        var databaseName: String?
        /**
         * The deletion protection setting for the new global cluster.
         */
        var deletionProtection: Boolean?
        /**
         * The Amazon DocumentDB database engine used by the global cluster.
         */
        var engine: String?
        /**
         * Indicates the database engine version.
         */
        var engineVersion: String?
        /**
         * The Amazon Resource Name (ARN) for the global cluster.
         */
        var globalClusterArn: String?
        /**
         * Contains a user-supplied global  cluster identifier. This identifier is the unique key that identifies a global cluster.
         */
        var globalClusterIdentifier: String?
        /**
         * The list of cluster IDs for secondary clusters within the global cluster. Currently limited to one item.
         */
        var globalClusterMembers: List<GlobalClusterMember>?
        /**
         * The Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS customer master key (CMK) for the cluster is accessed.
         */
        var globalClusterResourceId: String?
        /**
         * Specifies the current state of this global cluster.
         */
        var status: String?
        /**
         * The storage encryption setting for the global cluster.
         */
        var storageEncrypted: Boolean?

        fun build(): GlobalCluster
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var databaseName: String? = null
        override var deletionProtection: Boolean? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var globalClusterArn: String? = null
        override var globalClusterIdentifier: String? = null
        override var globalClusterMembers: List<GlobalClusterMember>? = null
        override var globalClusterResourceId: String? = null
        override var status: String? = null
        override var storageEncrypted: Boolean? = null

        constructor(x: GlobalCluster) : this() {
            this.databaseName = x.databaseName
            this.deletionProtection = x.deletionProtection
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterArn = x.globalClusterArn
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.globalClusterMembers = x.globalClusterMembers
            this.globalClusterResourceId = x.globalClusterResourceId
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
        }

        override fun build(): GlobalCluster = GlobalCluster(this)
        override fun databaseName(databaseName: String): FluentBuilder = apply { this.databaseName = databaseName }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun globalClusterArn(globalClusterArn: String): FluentBuilder = apply { this.globalClusterArn = globalClusterArn }
        override fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder = apply { this.globalClusterIdentifier = globalClusterIdentifier }
        override fun globalClusterMembers(globalClusterMembers: List<GlobalClusterMember>): FluentBuilder = apply { this.globalClusterMembers = globalClusterMembers }
        override fun globalClusterResourceId(globalClusterResourceId: String): FluentBuilder = apply { this.globalClusterResourceId = globalClusterResourceId }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder = apply { this.storageEncrypted = storageEncrypted }
    }
}
