// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to FailoverDBCluster.
 */
class FailoverDbClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * A cluster identifier to force a failover for. This parameter is not case sensitive.
     * Constraints:
     * Must match the identifier of an existing DBCluster.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The name of the instance to promote to the primary instance.
     * You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
     * example, mydbcluster-replica1.
     */
    val targetDbInstanceIdentifier: String? = builder.targetDbInstanceIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FailoverDbClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FailoverDbClusterRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("targetDbInstanceIdentifier=$targetDbInstanceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (targetDbInstanceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FailoverDbClusterRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (targetDbInstanceIdentifier != other.targetDbInstanceIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FailoverDbClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FailoverDbClusterRequest
        /**
         * A cluster identifier to force a failover for. This parameter is not case sensitive.
         * Constraints:
         * Must match the identifier of an existing DBCluster.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The name of the instance to promote to the primary instance.
         * You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
         * example, mydbcluster-replica1.
         */
        fun targetDbInstanceIdentifier(targetDbInstanceIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A cluster identifier to force a failover for. This parameter is not case sensitive.
         * Constraints:
         * Must match the identifier of an existing DBCluster.
         */
        var dbClusterIdentifier: String?
        /**
         * The name of the instance to promote to the primary instance.
         * You must specify the instance identifier for an Amazon DocumentDB replica in the cluster. For
         * example, mydbcluster-replica1.
         */
        var targetDbInstanceIdentifier: String?

        fun build(): FailoverDbClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterIdentifier: String? = null
        override var targetDbInstanceIdentifier: String? = null

        constructor(x: FailoverDbClusterRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.targetDbInstanceIdentifier = x.targetDbInstanceIdentifier
        }

        override fun build(): FailoverDbClusterRequest = FailoverDbClusterRequest(this)
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun targetDbInstanceIdentifier(targetDbInstanceIdentifier: String): FluentBuilder = apply { this.targetDbInstanceIdentifier = targetDbInstanceIdentifier }
    }
}
