// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about an event to which you have subscribed.
 */
class EventSubscription private constructor(builder: BuilderImpl) {
    /**
     * The Amazon DocumentDB event notification subscription ID.
     */
    val custSubscriptionId: String? = builder.custSubscriptionId
    /**
     * The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
     * subscription.
     */
    val customerAwsId: String? = builder.customerAwsId
    /**
     * A Boolean value indicating whether the subscription is enabled. A value of
     * true indicates that the subscription is enabled.
     */
    val enabled: Boolean = builder.enabled
    /**
     * A list of event categories for the Amazon DocumentDB event notification subscription.
     */
    val eventCategoriesList: List<String>? = builder.eventCategoriesList
    /**
     * The Amazon Resource Name (ARN) for the event subscription.
     */
    val eventSubscriptionArn: String? = builder.eventSubscriptionArn
    /**
     * The topic ARN of the Amazon DocumentDB event notification subscription.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * A list of source IDs for the Amazon DocumentDB event notification subscription.
     */
    val sourceIdsList: List<String>? = builder.sourceIdsList
    /**
     * The source type for the Amazon DocumentDB event notification subscription.
     */
    val sourceType: String? = builder.sourceType
    /**
     * The status of the Amazon DocumentDB event notification subscription.
     * Constraints:
     * Can be one of the following: creating, modifying,
     * deleting, active, no-permission,
     * topic-not-exist
     * The no-permission status indicates that Amazon DocumentDB no longer has permission
     * to post to the SNS topic. The topic-not-exist status indicates that the
     * topic was deleted after the subscription was created.
     */
    val status: String? = builder.status
    /**
     * The time at which the Amazon DocumentDB event notification subscription was created.
     */
    val subscriptionCreationTime: String? = builder.subscriptionCreationTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EventSubscription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EventSubscription(")
        append("custSubscriptionId=$custSubscriptionId,")
        append("customerAwsId=$customerAwsId,")
        append("enabled=$enabled,")
        append("eventCategoriesList=$eventCategoriesList,")
        append("eventSubscriptionArn=$eventSubscriptionArn,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIdsList=$sourceIdsList,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("subscriptionCreationTime=$subscriptionCreationTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = custSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (customerAwsId?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (eventCategoriesList?.hashCode() ?: 0)
        result = 31 * result + (eventSubscriptionArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdsList?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionCreationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EventSubscription

        if (custSubscriptionId != other.custSubscriptionId) return false
        if (customerAwsId != other.customerAwsId) return false
        if (enabled != other.enabled) return false
        if (eventCategoriesList != other.eventCategoriesList) return false
        if (eventSubscriptionArn != other.eventSubscriptionArn) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIdsList != other.sourceIdsList) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (subscriptionCreationTime != other.subscriptionCreationTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EventSubscription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EventSubscription
        /**
         * The Amazon DocumentDB event notification subscription ID.
         */
        fun custSubscriptionId(custSubscriptionId: String): FluentBuilder
        /**
         * The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
         * subscription.
         */
        fun customerAwsId(customerAwsId: String): FluentBuilder
        /**
         * A Boolean value indicating whether the subscription is enabled. A value of
         * true indicates that the subscription is enabled.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * A list of event categories for the Amazon DocumentDB event notification subscription.
         */
        fun eventCategoriesList(eventCategoriesList: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the event subscription.
         */
        fun eventSubscriptionArn(eventSubscriptionArn: String): FluentBuilder
        /**
         * The topic ARN of the Amazon DocumentDB event notification subscription.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * A list of source IDs for the Amazon DocumentDB event notification subscription.
         */
        fun sourceIdsList(sourceIdsList: List<String>): FluentBuilder
        /**
         * The source type for the Amazon DocumentDB event notification subscription.
         */
        fun sourceType(sourceType: String): FluentBuilder
        /**
         * The status of the Amazon DocumentDB event notification subscription.
         * Constraints:
         * Can be one of the following: creating, modifying,
         * deleting, active, no-permission,
         * topic-not-exist
         * The no-permission status indicates that Amazon DocumentDB no longer has permission
         * to post to the SNS topic. The topic-not-exist status indicates that the
         * topic was deleted after the subscription was created.
         */
        fun status(status: String): FluentBuilder
        /**
         * The time at which the Amazon DocumentDB event notification subscription was created.
         */
        fun subscriptionCreationTime(subscriptionCreationTime: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon DocumentDB event notification subscription ID.
         */
        var custSubscriptionId: String?
        /**
         * The Amazon Web Services customer account that is associated with the Amazon DocumentDB event notification
         * subscription.
         */
        var customerAwsId: String?
        /**
         * A Boolean value indicating whether the subscription is enabled. A value of
         * true indicates that the subscription is enabled.
         */
        var enabled: Boolean
        /**
         * A list of event categories for the Amazon DocumentDB event notification subscription.
         */
        var eventCategoriesList: List<String>?
        /**
         * The Amazon Resource Name (ARN) for the event subscription.
         */
        var eventSubscriptionArn: String?
        /**
         * The topic ARN of the Amazon DocumentDB event notification subscription.
         */
        var snsTopicArn: String?
        /**
         * A list of source IDs for the Amazon DocumentDB event notification subscription.
         */
        var sourceIdsList: List<String>?
        /**
         * The source type for the Amazon DocumentDB event notification subscription.
         */
        var sourceType: String?
        /**
         * The status of the Amazon DocumentDB event notification subscription.
         * Constraints:
         * Can be one of the following: creating, modifying,
         * deleting, active, no-permission,
         * topic-not-exist
         * The no-permission status indicates that Amazon DocumentDB no longer has permission
         * to post to the SNS topic. The topic-not-exist status indicates that the
         * topic was deleted after the subscription was created.
         */
        var status: String?
        /**
         * The time at which the Amazon DocumentDB event notification subscription was created.
         */
        var subscriptionCreationTime: String?

        fun build(): EventSubscription
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var custSubscriptionId: String? = null
        override var customerAwsId: String? = null
        override var enabled: Boolean = false
        override var eventCategoriesList: List<String>? = null
        override var eventSubscriptionArn: String? = null
        override var snsTopicArn: String? = null
        override var sourceIdsList: List<String>? = null
        override var sourceType: String? = null
        override var status: String? = null
        override var subscriptionCreationTime: String? = null

        constructor(x: EventSubscription) : this() {
            this.custSubscriptionId = x.custSubscriptionId
            this.customerAwsId = x.customerAwsId
            this.enabled = x.enabled
            this.eventCategoriesList = x.eventCategoriesList
            this.eventSubscriptionArn = x.eventSubscriptionArn
            this.snsTopicArn = x.snsTopicArn
            this.sourceIdsList = x.sourceIdsList
            this.sourceType = x.sourceType
            this.status = x.status
            this.subscriptionCreationTime = x.subscriptionCreationTime
        }

        override fun build(): EventSubscription = EventSubscription(this)
        override fun custSubscriptionId(custSubscriptionId: String): FluentBuilder = apply { this.custSubscriptionId = custSubscriptionId }
        override fun customerAwsId(customerAwsId: String): FluentBuilder = apply { this.customerAwsId = customerAwsId }
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun eventCategoriesList(eventCategoriesList: List<String>): FluentBuilder = apply { this.eventCategoriesList = eventCategoriesList }
        override fun eventSubscriptionArn(eventSubscriptionArn: String): FluentBuilder = apply { this.eventSubscriptionArn = eventSubscriptionArn }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun sourceIdsList(sourceIdsList: List<String>): FluentBuilder = apply { this.sourceIdsList = sourceIdsList }
        override fun sourceType(sourceType: String): FluentBuilder = apply { this.sourceType = sourceType }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun subscriptionCreationTime(subscriptionCreationTime: String): FluentBuilder = apply { this.subscriptionCreationTime = subscriptionCreationTime }
    }
}
