// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an event.
 */
class Event private constructor(builder: BuilderImpl) {
    /**
     * Specifies the date and time of the event.
     */
    val date: Instant? = builder.date
    /**
     * Specifies the category for the event.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * Provides the text of this event.
     */
    val message: String? = builder.message
    /**
     * The Amazon Resource Name (ARN) for the event.
     */
    val sourceArn: String? = builder.sourceArn
    /**
     * Provides the identifier for the source of the event.
     */
    val sourceIdentifier: String? = builder.sourceIdentifier
    /**
     * Specifies the source type for this event.
     */
    val sourceType: SourceType? = builder.sourceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Event = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("date=$date,")
        append("eventCategories=$eventCategories,")
        append("message=$message,")
        append("sourceArn=$sourceArn,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = date?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Event

        if (date != other.date) return false
        if (eventCategories != other.eventCategories) return false
        if (message != other.message) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Event = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Event
        /**
         * Specifies the date and time of the event.
         */
        fun date(date: Instant): FluentBuilder
        /**
         * Specifies the category for the event.
         */
        fun eventCategories(eventCategories: List<String>): FluentBuilder
        /**
         * Provides the text of this event.
         */
        fun message(message: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the event.
         */
        fun sourceArn(sourceArn: String): FluentBuilder
        /**
         * Provides the identifier for the source of the event.
         */
        fun sourceIdentifier(sourceIdentifier: String): FluentBuilder
        /**
         * Specifies the source type for this event.
         */
        fun sourceType(sourceType: SourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the date and time of the event.
         */
        var date: Instant?
        /**
         * Specifies the category for the event.
         */
        var eventCategories: List<String>?
        /**
         * Provides the text of this event.
         */
        var message: String?
        /**
         * The Amazon Resource Name (ARN) for the event.
         */
        var sourceArn: String?
        /**
         * Provides the identifier for the source of the event.
         */
        var sourceIdentifier: String?
        /**
         * Specifies the source type for this event.
         */
        var sourceType: SourceType?

        fun build(): Event
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var date: Instant? = null
        override var eventCategories: List<String>? = null
        override var message: String? = null
        override var sourceArn: String? = null
        override var sourceIdentifier: String? = null
        override var sourceType: SourceType? = null

        constructor(x: Event) : this() {
            this.date = x.date
            this.eventCategories = x.eventCategories
            this.message = x.message
            this.sourceArn = x.sourceArn
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
        }

        override fun build(): Event = Event(this)
        override fun date(date: Instant): FluentBuilder = apply { this.date = date }
        override fun eventCategories(eventCategories: List<String>): FluentBuilder = apply { this.eventCategories = eventCategories }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun sourceArn(sourceArn: String): FluentBuilder = apply { this.sourceArn = sourceArn }
        override fun sourceIdentifier(sourceIdentifier: String): FluentBuilder = apply { this.sourceIdentifier = sourceIdentifier }
        override fun sourceType(sourceType: SourceType): FluentBuilder = apply { this.sourceType = sourceType }
    }
}
