// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Network information for accessing a cluster or instance. Client programs must
 * specify a valid endpoint to access these Amazon DocumentDB resources.
 */
class Endpoint private constructor(builder: BuilderImpl) {
    /**
     * Specifies the DNS address of the instance.
     */
    val address: String? = builder.address
    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    val hostedZoneId: String? = builder.hostedZoneId
    /**
     * Specifies the port that the database engine is listening on.
     */
    val port: Int = builder.port

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Endpoint = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("address=$address,")
        append("hostedZoneId=$hostedZoneId,")
        append("port=$port)")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (port)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Endpoint

        if (address != other.address) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (port != other.port) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Endpoint = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Endpoint
        /**
         * Specifies the DNS address of the instance.
         */
        fun address(address: String): FluentBuilder
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        fun hostedZoneId(hostedZoneId: String): FluentBuilder
        /**
         * Specifies the port that the database engine is listening on.
         */
        fun port(port: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the DNS address of the instance.
         */
        var address: String?
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        var hostedZoneId: String?
        /**
         * Specifies the port that the database engine is listening on.
         */
        var port: Int

        fun build(): Endpoint
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var address: String? = null
        override var hostedZoneId: String? = null
        override var port: Int = 0

        constructor(x: Endpoint) : this() {
            this.address = x.address
            this.hostedZoneId = x.hostedZoneId
            this.port = x.port
        }

        override fun build(): Endpoint = Endpoint(this)
        override fun address(address: String): FluentBuilder = apply { this.address = address }
        override fun hostedZoneId(hostedZoneId: String): FluentBuilder = apply { this.hostedZoneId = hostedZoneId }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
    }
}
