// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribePendingMaintenanceActions.
 */
class DescribePendingMaintenanceActionsRequest private constructor(builder: BuilderImpl) {
    /**
     * A filter that specifies one or more resources to return pending maintenance actions
     * for.
     * Supported filters:
     * db-cluster-id - Accepts cluster identifiers and cluster
     * Amazon Resource Names (ARNs). The results list includes only pending maintenance
     * actions for the clusters identified by these ARNs.
     * db-instance-id - Accepts instance identifiers and instance
     * ARNs. The results list includes only pending maintenance actions for the DB
     * instances identified by these ARNs.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The ARN of a resource to return pending maintenance actions for.
     */
    val resourceIdentifier: String? = builder.resourceIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribePendingMaintenanceActionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePendingMaintenanceActionsRequest(")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("resourceIdentifier=$resourceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribePendingMaintenanceActionsRequest

        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribePendingMaintenanceActionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribePendingMaintenanceActionsRequest
        /**
         * A filter that specifies one or more resources to return pending maintenance actions
         * for.
         * Supported filters:
         * db-cluster-id - Accepts cluster identifiers and cluster
         * Amazon Resource Names (ARNs). The results list includes only pending maintenance
         * actions for the clusters identified by these ARNs.
         * db-instance-id - Accepts instance identifiers and instance
         * ARNs. The results list includes only pending maintenance actions for the DB
         * instances identified by these ARNs.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The ARN of a resource to return pending maintenance actions for.
         */
        fun resourceIdentifier(resourceIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A filter that specifies one or more resources to return pending maintenance actions
         * for.
         * Supported filters:
         * db-cluster-id - Accepts cluster identifiers and cluster
         * Amazon Resource Names (ARNs). The results list includes only pending maintenance
         * actions for the clusters identified by these ARNs.
         * db-instance-id - Accepts instance identifiers and instance
         * ARNs. The results list includes only pending maintenance actions for the DB
         * instances identified by these ARNs.
         */
        var filters: List<Filter>?
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The ARN of a resource to return pending maintenance actions for.
         */
        var resourceIdentifier: String?

        fun build(): DescribePendingMaintenanceActionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var filters: List<Filter>? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var resourceIdentifier: String? = null

        constructor(x: DescribePendingMaintenanceActionsRequest) : this() {
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.resourceIdentifier = x.resourceIdentifier
        }

        override fun build(): DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest(this)
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun resourceIdentifier(resourceIdentifier: String): FluentBuilder = apply { this.resourceIdentifier = resourceIdentifier }
    }
}
