// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeOrderableDBInstanceOptions.
 */
class DescribeOrderableDbInstanceOptionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The instance class filter value. Specify this parameter to show only the available
     * offerings that match the specified instance class.
     */
    val dbInstanceClass: String? = builder.dbInstanceClass
    /**
     * The name of the engine to retrieve instance options for.
     */
    val engine: String? = builder.engine
    /**
     * The engine version filter value. Specify this parameter to show only the available
     * offerings that match the specified engine version.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The license model filter value. Specify this parameter to show only the available
     * offerings that match the specified license model.
     */
    val licenseModel: String? = builder.licenseModel
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The virtual private cloud (VPC) filter value. Specify this parameter to show only the
     * available VPC or non-VPC offerings.
     */
    val vpc: Boolean? = builder.vpc

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeOrderableDbInstanceOptionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeOrderableDbInstanceOptionsRequest(")
        append("dbInstanceClass=$dbInstanceClass,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("filters=$filters,")
        append("licenseModel=$licenseModel,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("vpc=$vpc)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceClass?.hashCode() ?: 0
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (vpc?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeOrderableDbInstanceOptionsRequest

        if (dbInstanceClass != other.dbInstanceClass) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (filters != other.filters) return false
        if (licenseModel != other.licenseModel) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (vpc != other.vpc) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeOrderableDbInstanceOptionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeOrderableDbInstanceOptionsRequest
        /**
         * The instance class filter value. Specify this parameter to show only the available
         * offerings that match the specified instance class.
         */
        fun dbInstanceClass(dbInstanceClass: String): FluentBuilder
        /**
         * The name of the engine to retrieve instance options for.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The engine version filter value. Specify this parameter to show only the available
         * offerings that match the specified engine version.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * This parameter is not currently supported.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The license model filter value. Specify this parameter to show only the available
         * offerings that match the specified license model.
         */
        fun licenseModel(licenseModel: String): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The virtual private cloud (VPC) filter value. Specify this parameter to show only the
         * available VPC or non-VPC offerings.
         */
        fun vpc(vpc: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The instance class filter value. Specify this parameter to show only the available
         * offerings that match the specified instance class.
         */
        var dbInstanceClass: String?
        /**
         * The name of the engine to retrieve instance options for.
         */
        var engine: String?
        /**
         * The engine version filter value. Specify this parameter to show only the available
         * offerings that match the specified engine version.
         */
        var engineVersion: String?
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>?
        /**
         * The license model filter value. Specify this parameter to show only the available
         * offerings that match the specified license model.
         */
        var licenseModel: String?
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The virtual private cloud (VPC) filter value. Specify this parameter to show only the
         * available VPC or non-VPC offerings.
         */
        var vpc: Boolean?

        fun build(): DescribeOrderableDbInstanceOptionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbInstanceClass: String? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var filters: List<Filter>? = null
        override var licenseModel: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var vpc: Boolean? = null

        constructor(x: DescribeOrderableDbInstanceOptionsRequest) : this() {
            this.dbInstanceClass = x.dbInstanceClass
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.filters = x.filters
            this.licenseModel = x.licenseModel
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.vpc = x.vpc
        }

        override fun build(): DescribeOrderableDbInstanceOptionsRequest = DescribeOrderableDbInstanceOptionsRequest(this)
        override fun dbInstanceClass(dbInstanceClass: String): FluentBuilder = apply { this.dbInstanceClass = dbInstanceClass }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun licenseModel(licenseModel: String): FluentBuilder = apply { this.licenseModel = licenseModel }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun vpc(vpc: Boolean): FluentBuilder = apply { this.vpc = vpc }
    }
}
