// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



class DescribeGlobalClustersRequest private constructor(builder: BuilderImpl) {
    /**
     * A filter that specifies one or more global DB clusters to describe.
     * Supported filters: db-cluster-id accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.
     */
    val globalClusterIdentifier: String? = builder.globalClusterIdentifier
    /**
     * An optional pagination token provided by a previous DescribeGlobalClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     */
    val maxRecords: Int? = builder.maxRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeGlobalClustersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGlobalClustersRequest(")
        append("filters=$filters,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeGlobalClustersRequest

        if (filters != other.filters) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeGlobalClustersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeGlobalClustersRequest
        /**
         * A filter that specifies one or more global DB clusters to describe.
         * Supported filters: db-cluster-id accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.
         */
        fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder
        /**
         * An optional pagination token provided by a previous DescribeGlobalClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A filter that specifies one or more global DB clusters to describe.
         * Supported filters: db-cluster-id accepts  cluster identifiers and  cluster Amazon Resource Names (ARNs). The results list will only include information about the clusters identified by these ARNs.
         */
        var filters: List<Filter>?
        /**
         * The user-supplied  cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case-sensitive.
         */
        var globalClusterIdentifier: String?
        /**
         * An optional pagination token provided by a previous DescribeGlobalClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         */
        var maxRecords: Int?

        fun build(): DescribeGlobalClustersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var filters: List<Filter>? = null
        override var globalClusterIdentifier: String? = null
        override var marker: String? = null
        override var maxRecords: Int? = null

        constructor(x: DescribeGlobalClustersRequest) : this() {
            this.filters = x.filters
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        override fun build(): DescribeGlobalClustersRequest = DescribeGlobalClustersRequest(this)
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder = apply { this.globalClusterIdentifier = globalClusterIdentifier }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
    }
}
