// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the input to DescribeEvents.
 */
class DescribeEventsRequest private constructor(builder: BuilderImpl) {
    /**
     * The number of minutes to retrieve events for.
     * Default: 60
     */
    val duration: Int? = builder.duration
    /**
     * The end of the time interval for which to retrieve events, specified in ISO 8601
     * format.
     * Example: 2009-07-08T18:00Z
     */
    val endTime: Instant? = builder.endTime
    /**
     * A list of event categories that trigger notifications for an event notification
     * subscription.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.
     * Constraints:
     * If SourceIdentifier is provided, SourceType must also be provided.
     * If the source type is DBInstance, a
     * DBInstanceIdentifier must be provided.
     * If the source type is DBSecurityGroup, a
     * DBSecurityGroupName must be provided.
     * If the source type is DBParameterGroup, a
     * DBParameterGroupName must be provided.
     * If the source type is DBSnapshot, a
     * DBSnapshotIdentifier must be provided.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val sourceIdentifier: String? = builder.sourceIdentifier
    /**
     * The event source to retrieve events for. If no value is specified, all events are returned.
     */
    val sourceType: SourceType? = builder.sourceType
    /**
     * The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
     * Example: 2009-07-08T18:00Z
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeEventsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("duration=$duration,")
        append("endTime=$endTime,")
        append("eventCategories=$eventCategories,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("sourceIdentifier=$sourceIdentifier,")
        append("sourceType=$sourceType,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (sourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeEventsRequest

        if (duration != other.duration) return false
        if (endTime != other.endTime) return false
        if (eventCategories != other.eventCategories) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (sourceIdentifier != other.sourceIdentifier) return false
        if (sourceType != other.sourceType) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeEventsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeEventsRequest
        /**
         * The number of minutes to retrieve events for.
         * Default: 60
         */
        fun duration(duration: Int): FluentBuilder
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601
         * format.
         * Example: 2009-07-08T18:00Z
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * A list of event categories that trigger notifications for an event notification
         * subscription.
         */
        fun eventCategories(eventCategories: List<String>): FluentBuilder
        /**
         * This parameter is not currently supported.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.
         * Constraints:
         * If SourceIdentifier is provided, SourceType must also be provided.
         * If the source type is DBInstance, a
         * DBInstanceIdentifier must be provided.
         * If the source type is DBSecurityGroup, a
         * DBSecurityGroupName must be provided.
         * If the source type is DBParameterGroup, a
         * DBParameterGroupName must be provided.
         * If the source type is DBSnapshot, a
         * DBSnapshotIdentifier must be provided.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun sourceIdentifier(sourceIdentifier: String): FluentBuilder
        /**
         * The event source to retrieve events for. If no value is specified, all events are returned.
         */
        fun sourceType(sourceType: SourceType): FluentBuilder
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
         * Example: 2009-07-08T18:00Z
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of minutes to retrieve events for.
         * Default: 60
         */
        var duration: Int?
        /**
         * The end of the time interval for which to retrieve events, specified in ISO 8601
         * format.
         * Example: 2009-07-08T18:00Z
         */
        var endTime: Instant?
        /**
         * A list of event categories that trigger notifications for an event notification
         * subscription.
         */
        var eventCategories: List<String>?
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>?
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.
         * Constraints:
         * If SourceIdentifier is provided, SourceType must also be provided.
         * If the source type is DBInstance, a
         * DBInstanceIdentifier must be provided.
         * If the source type is DBSecurityGroup, a
         * DBSecurityGroupName must be provided.
         * If the source type is DBParameterGroup, a
         * DBParameterGroupName must be provided.
         * If the source type is DBSnapshot, a
         * DBSnapshotIdentifier must be provided.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var sourceIdentifier: String?
        /**
         * The event source to retrieve events for. If no value is specified, all events are returned.
         */
        var sourceType: SourceType?
        /**
         * The beginning of the time interval to retrieve events for, specified in ISO 8601 format.
         * Example: 2009-07-08T18:00Z
         */
        var startTime: Instant?

        fun build(): DescribeEventsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var duration: Int? = null
        override var endTime: Instant? = null
        override var eventCategories: List<String>? = null
        override var filters: List<Filter>? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var sourceIdentifier: String? = null
        override var sourceType: SourceType? = null
        override var startTime: Instant? = null

        constructor(x: DescribeEventsRequest) : this() {
            this.duration = x.duration
            this.endTime = x.endTime
            this.eventCategories = x.eventCategories
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.sourceIdentifier = x.sourceIdentifier
            this.sourceType = x.sourceType
            this.startTime = x.startTime
        }

        override fun build(): DescribeEventsRequest = DescribeEventsRequest(this)
        override fun duration(duration: Int): FluentBuilder = apply { this.duration = duration }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun eventCategories(eventCategories: List<String>): FluentBuilder = apply { this.eventCategories = eventCategories }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun sourceIdentifier(sourceIdentifier: String): FluentBuilder = apply { this.sourceIdentifier = sourceIdentifier }
        override fun sourceType(sourceType: SourceType): FluentBuilder = apply { this.sourceType = sourceType }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
