// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeDBEngineVersions.
 */
class DescribeDbEngineVersionsRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of a specific parameter group family to return details for.
     * Constraints:
     * If provided, must match an existing
     * DBParameterGroupFamily.
     */
    val dbParameterGroupFamily: String? = builder.dbParameterGroupFamily
    /**
     * Indicates that only the default version of the specified engine or engine and major
     * version combination is returned.
     */
    val defaultOnly: Boolean = builder.defaultOnly
    /**
     * The database engine to return.
     */
    val engine: String? = builder.engine
    /**
     * The database engine version to return.
     * Example: 3.6.0
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * If this parameter is specified and the requested engine supports the CharacterSetName parameter for CreateDBInstance, the response includes a list of supported character sets for each engine version.
     */
    val listSupportedCharacterSets: Boolean? = builder.listSupportedCharacterSets
    /**
     * If this parameter is specified and the requested engine supports the TimeZone parameter for CreateDBInstance, the response includes a list of supported time zones for each engine version.
     */
    val listSupportedTimezones: Boolean? = builder.listSupportedTimezones
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDbEngineVersionsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbEngineVersionsRequest(")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("defaultOnly=$defaultOnly,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("filters=$filters,")
        append("listSupportedCharacterSets=$listSupportedCharacterSets,")
        append("listSupportedTimezones=$listSupportedTimezones,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupFamily?.hashCode() ?: 0
        result = 31 * result + (defaultOnly.hashCode())
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (listSupportedCharacterSets?.hashCode() ?: 0)
        result = 31 * result + (listSupportedTimezones?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDbEngineVersionsRequest

        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (defaultOnly != other.defaultOnly) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (filters != other.filters) return false
        if (listSupportedCharacterSets != other.listSupportedCharacterSets) return false
        if (listSupportedTimezones != other.listSupportedTimezones) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDbEngineVersionsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDbEngineVersionsRequest
        /**
         * The name of a specific parameter group family to return details for.
         * Constraints:
         * If provided, must match an existing
         * DBParameterGroupFamily.
         */
        fun dbParameterGroupFamily(dbParameterGroupFamily: String): FluentBuilder
        /**
         * Indicates that only the default version of the specified engine or engine and major
         * version combination is returned.
         */
        fun defaultOnly(defaultOnly: Boolean): FluentBuilder
        /**
         * The database engine to return.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The database engine version to return.
         * Example: 3.6.0
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * This parameter is not currently supported.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * If this parameter is specified and the requested engine supports the CharacterSetName parameter for CreateDBInstance, the response includes a list of supported character sets for each engine version.
         */
        fun listSupportedCharacterSets(listSupportedCharacterSets: Boolean): FluentBuilder
        /**
         * If this parameter is specified and the requested engine supports the TimeZone parameter for CreateDBInstance, the response includes a list of supported time zones for each engine version.
         */
        fun listSupportedTimezones(listSupportedTimezones: Boolean): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of a specific parameter group family to return details for.
         * Constraints:
         * If provided, must match an existing
         * DBParameterGroupFamily.
         */
        var dbParameterGroupFamily: String?
        /**
         * Indicates that only the default version of the specified engine or engine and major
         * version combination is returned.
         */
        var defaultOnly: Boolean
        /**
         * The database engine to return.
         */
        var engine: String?
        /**
         * The database engine version to return.
         * Example: 3.6.0
         */
        var engineVersion: String?
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>?
        /**
         * If this parameter is specified and the requested engine supports the CharacterSetName parameter for CreateDBInstance, the response includes a list of supported character sets for each engine version.
         */
        var listSupportedCharacterSets: Boolean?
        /**
         * If this parameter is specified and the requested engine supports the TimeZone parameter for CreateDBInstance, the response includes a list of supported time zones for each engine version.
         */
        var listSupportedTimezones: Boolean?
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?

        fun build(): DescribeDbEngineVersionsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbParameterGroupFamily: String? = null
        override var defaultOnly: Boolean = false
        override var engine: String? = null
        override var engineVersion: String? = null
        override var filters: List<Filter>? = null
        override var listSupportedCharacterSets: Boolean? = null
        override var listSupportedTimezones: Boolean? = null
        override var marker: String? = null
        override var maxRecords: Int? = null

        constructor(x: DescribeDbEngineVersionsRequest) : this() {
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.defaultOnly = x.defaultOnly
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.filters = x.filters
            this.listSupportedCharacterSets = x.listSupportedCharacterSets
            this.listSupportedTimezones = x.listSupportedTimezones
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        override fun build(): DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest(this)
        override fun dbParameterGroupFamily(dbParameterGroupFamily: String): FluentBuilder = apply { this.dbParameterGroupFamily = dbParameterGroupFamily }
        override fun defaultOnly(defaultOnly: Boolean): FluentBuilder = apply { this.defaultOnly = defaultOnly }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun listSupportedCharacterSets(listSupportedCharacterSets: Boolean): FluentBuilder = apply { this.listSupportedCharacterSets = listSupportedCharacterSets }
        override fun listSupportedTimezones(listSupportedTimezones: Boolean): FluentBuilder = apply { this.listSupportedTimezones = listSupportedTimezones }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
    }
}
