// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeDBClusters.
 */
class DescribeDbClustersRequest private constructor(builder: BuilderImpl) {
    /**
     * The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.
     * Constraints:
     * If provided, must match an existing DBClusterIdentifier.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * A filter that specifies one or more clusters to describe.
     * Supported filters:
     * db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDbClustersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClustersRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDbClustersRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDbClustersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDbClustersRequest
        /**
         * The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.
         * Constraints:
         * If provided, must match an existing DBClusterIdentifier.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * A filter that specifies one or more clusters to describe.
         * Supported filters:
         * db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The user-provided cluster identifier. If this parameter is specified, information from only the specific cluster is returned. This parameter isn't case sensitive.
         * Constraints:
         * If provided, must match an existing DBClusterIdentifier.
         */
        var dbClusterIdentifier: String?
        /**
         * A filter that specifies one or more clusters to describe.
         * Supported filters:
         * db-cluster-id - Accepts cluster identifiers and cluster Amazon Resource Names (ARNs). The results list only includes information about the clusters identified by these ARNs.
         */
        var filters: List<Filter>?
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?

        fun build(): DescribeDbClustersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterIdentifier: String? = null
        override var filters: List<Filter>? = null
        override var marker: String? = null
        override var maxRecords: Int? = null

        constructor(x: DescribeDbClustersRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        override fun build(): DescribeDbClustersRequest = DescribeDbClustersRequest(this)
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
    }
}
