// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeDBClusterSnapshots.
 */
class DescribeDbClusterSnapshotsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the DBClusterSnapshotIdentifier parameter. This parameter is not case sensitive.
     * Constraints:
     * If provided, must match the identifier of an existing
     * DBCluster.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * A specific cluster snapshot identifier to describe. This parameter can't be used with the DBClusterIdentifier parameter. This value is stored as a lowercase string.
     * Constraints:
     * If provided, must match the identifier of an existing
     * DBClusterSnapshot.
     * If this identifier is for an automated snapshot, the SnapshotType
     * parameter must also be specified.
     */
    val dbClusterSnapshotIdentifier: String? = builder.dbClusterSnapshotIdentifier
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * Set to true to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise false. The default is false.
     */
    val includePublic: Boolean = builder.includePublic
    /**
     * Set to true to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise false. The default is false.
     */
    val includeShared: Boolean = builder.includeShared
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * The type of cluster snapshots to be returned. You can specify one of the following values:
     * automated - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.
     * manual - Return all cluster snapshots that you have manually created for your account.
     * shared - Return all manual cluster snapshots that have been shared to your account.
     * public - Return all cluster snapshots that have been marked as public.
     * If you don't specify a SnapshotType value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the IncludeShared parameter to true. You can include public cluster snapshots with these results by setting theIncludePublic parameter to true.
     * The IncludeShared and IncludePublic parameters don't apply for SnapshotType values of manual or automated. The IncludePublic parameter doesn't apply when SnapshotType is set to shared. The IncludeShared parameter doesn't apply when SnapshotType is set to public.
     */
    val snapshotType: String? = builder.snapshotType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDbClusterSnapshotsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterSnapshotsRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("filters=$filters,")
        append("includePublic=$includePublic,")
        append("includeShared=$includeShared,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotType=$snapshotType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includePublic.hashCode())
        result = 31 * result + (includeShared.hashCode())
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDbClusterSnapshotsRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (filters != other.filters) return false
        if (includePublic != other.includePublic) return false
        if (includeShared != other.includeShared) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotType != other.snapshotType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDbClusterSnapshotsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDbClusterSnapshotsRequest
        /**
         * The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the DBClusterSnapshotIdentifier parameter. This parameter is not case sensitive.
         * Constraints:
         * If provided, must match the identifier of an existing
         * DBCluster.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * A specific cluster snapshot identifier to describe. This parameter can't be used with the DBClusterIdentifier parameter. This value is stored as a lowercase string.
         * Constraints:
         * If provided, must match the identifier of an existing
         * DBClusterSnapshot.
         * If this identifier is for an automated snapshot, the SnapshotType
         * parameter must also be specified.
         */
        fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder
        /**
         * This parameter is not currently supported.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * Set to true to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise false. The default is false.
         */
        fun includePublic(includePublic: Boolean): FluentBuilder
        /**
         * Set to true to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise false. The default is false.
         */
        fun includeShared(includeShared: Boolean): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * automated - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.
         * manual - Return all cluster snapshots that you have manually created for your account.
         * shared - Return all manual cluster snapshots that have been shared to your account.
         * public - Return all cluster snapshots that have been marked as public.
         * If you don't specify a SnapshotType value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the IncludeShared parameter to true. You can include public cluster snapshots with these results by setting theIncludePublic parameter to true.
         * The IncludeShared and IncludePublic parameters don't apply for SnapshotType values of manual or automated. The IncludePublic parameter doesn't apply when SnapshotType is set to shared. The IncludeShared parameter doesn't apply when SnapshotType is set to public.
         */
        fun snapshotType(snapshotType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the cluster to retrieve the list of cluster snapshots for. This parameter can't be used with the DBClusterSnapshotIdentifier parameter. This parameter is not case sensitive.
         * Constraints:
         * If provided, must match the identifier of an existing
         * DBCluster.
         */
        var dbClusterIdentifier: String?
        /**
         * A specific cluster snapshot identifier to describe. This parameter can't be used with the DBClusterIdentifier parameter. This value is stored as a lowercase string.
         * Constraints:
         * If provided, must match the identifier of an existing
         * DBClusterSnapshot.
         * If this identifier is for an automated snapshot, the SnapshotType
         * parameter must also be specified.
         */
        var dbClusterSnapshotIdentifier: String?
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>?
        /**
         * Set to true to include manual cluster snapshots that are public and can be copied or restored by any account, and otherwise false. The default is false.
         */
        var includePublic: Boolean
        /**
         * Set to true to include shared manual cluster snapshots from other accounts that this account has been given permission to copy or restore, and otherwise false. The default is false.
         */
        var includeShared: Boolean
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * The type of cluster snapshots to be returned. You can specify one of the following values:
         * automated - Return all cluster snapshots that Amazon DocumentDB has automatically created for your account.
         * manual - Return all cluster snapshots that you have manually created for your account.
         * shared - Return all manual cluster snapshots that have been shared to your account.
         * public - Return all cluster snapshots that have been marked as public.
         * If you don't specify a SnapshotType value, then both automated and manual cluster snapshots are returned. You can include shared cluster snapshots with these results by setting the IncludeShared parameter to true. You can include public cluster snapshots with these results by setting theIncludePublic parameter to true.
         * The IncludeShared and IncludePublic parameters don't apply for SnapshotType values of manual or automated. The IncludePublic parameter doesn't apply when SnapshotType is set to shared. The IncludeShared parameter doesn't apply when SnapshotType is set to public.
         */
        var snapshotType: String?

        fun build(): DescribeDbClusterSnapshotsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterIdentifier: String? = null
        override var dbClusterSnapshotIdentifier: String? = null
        override var filters: List<Filter>? = null
        override var includePublic: Boolean = false
        override var includeShared: Boolean = false
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var snapshotType: String? = null

        constructor(x: DescribeDbClusterSnapshotsRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.filters = x.filters
            this.includePublic = x.includePublic
            this.includeShared = x.includeShared
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotType = x.snapshotType
        }

        override fun build(): DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest(this)
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder = apply { this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun includePublic(includePublic: Boolean): FluentBuilder = apply { this.includePublic = includePublic }
        override fun includeShared(includeShared: Boolean): FluentBuilder = apply { this.includeShared = includeShared }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun snapshotType(snapshotType: String): FluentBuilder = apply { this.snapshotType = snapshotType }
    }
}
