// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DescribeDBClusterParameters.
 */
class DescribeDbClusterParametersRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of a specific cluster parameter group to return parameter details for.
     * Constraints:
     * If provided, must match the name of an existing DBClusterParameterGroup.
     */
    val dbClusterParameterGroupName: String? = builder.dbClusterParameterGroupName
    /**
     * This parameter is not currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by
     * MaxRecords.
     */
    val marker: String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than
     * the specified MaxRecords value, a pagination token (marker) is included
     * in the response so that the remaining results can be retrieved.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: Int? = builder.maxRecords
    /**
     * A value that indicates to return only parameters for a specific source. Parameter sources can be engine, service, or customer.
     */
    val source: String? = builder.source

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDbClusterParametersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClusterParametersRequest(")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupName?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDbClusterParametersRequest

        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (source != other.source) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDbClusterParametersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDbClusterParametersRequest
        /**
         * The name of a specific cluster parameter group to return parameter details for.
         * Constraints:
         * If provided, must match the name of an existing DBClusterParameterGroup.
         */
        fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder
        /**
         * This parameter is not currently supported.
         */
        fun filters(filters: List<Filter>): FluentBuilder
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        fun marker(marker: String): FluentBuilder
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        fun maxRecords(maxRecords: Int): FluentBuilder
        /**
         * A value that indicates to return only parameters for a specific source. Parameter sources can be engine, service, or customer.
         */
        fun source(source: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of a specific cluster parameter group to return parameter details for.
         * Constraints:
         * If provided, must match the name of an existing DBClusterParameterGroup.
         */
        var dbClusterParameterGroupName: String?
        /**
         * This parameter is not currently supported.
         */
        var filters: List<Filter>?
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by
         * MaxRecords.
         */
        var marker: String?
        /**
         * The maximum number of records to include in the response. If more records exist than
         * the specified MaxRecords value, a pagination token (marker) is included
         * in the response so that the remaining results can be retrieved.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: Int?
        /**
         * A value that indicates to return only parameters for a specific source. Parameter sources can be engine, service, or customer.
         */
        var source: String?

        fun build(): DescribeDbClusterParametersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterParameterGroupName: String? = null
        override var filters: List<Filter>? = null
        override var marker: String? = null
        override var maxRecords: Int? = null
        override var source: String? = null

        constructor(x: DescribeDbClusterParametersRequest) : this() {
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.source = x.source
        }

        override fun build(): DescribeDbClusterParametersRequest = DescribeDbClusterParametersRequest(this)
        override fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder = apply { this.dbClusterParameterGroupName = dbClusterParameterGroupName }
        override fun filters(filters: List<Filter>): FluentBuilder = apply { this.filters = filters }
        override fun marker(marker: String): FluentBuilder = apply { this.marker = marker }
        override fun maxRecords(maxRecords: Int): FluentBuilder = apply { this.maxRecords = maxRecords }
        override fun source(source: String): FluentBuilder = apply { this.source = source }
    }
}
