// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to DeleteDBCluster.
 */
class DeleteDbClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.
     * Constraints:
     * Must match an existing DBClusterIdentifier.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The cluster snapshot identifier of the new cluster snapshot created when SkipFinalSnapshot is set to false.
     * Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.
     * Constraints:
     * Must be from 1 to 255 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     */
    val finalDbSnapshotIdentifier: String? = builder.finalDbSnapshotIdentifier
    /**
     * Determines whether a final cluster snapshot is created before the cluster is deleted. If true is specified, no cluster snapshot is created. If false is specified, a cluster snapshot is created before the DB cluster is deleted.
     * If SkipFinalSnapshot is false, you must specify a FinalDBSnapshotIdentifier parameter.
     * Default: false
     */
    val skipFinalSnapshot: Boolean = builder.skipFinalSnapshot

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeleteDbClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDbClusterRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeleteDbClusterRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeleteDbClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeleteDbClusterRequest
        /**
         * The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.
         * Constraints:
         * Must match an existing DBClusterIdentifier.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The cluster snapshot identifier of the new cluster snapshot created when SkipFinalSnapshot is set to false.
         * Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.
         * Constraints:
         * Must be from 1 to 255 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        fun finalDbSnapshotIdentifier(finalDbSnapshotIdentifier: String): FluentBuilder
        /**
         * Determines whether a final cluster snapshot is created before the cluster is deleted. If true is specified, no cluster snapshot is created. If false is specified, a cluster snapshot is created before the DB cluster is deleted.
         * If SkipFinalSnapshot is false, you must specify a FinalDBSnapshotIdentifier parameter.
         * Default: false
         */
        fun skipFinalSnapshot(skipFinalSnapshot: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The cluster identifier for the cluster to be deleted. This parameter isn't case sensitive.
         * Constraints:
         * Must match an existing DBClusterIdentifier.
         */
        var dbClusterIdentifier: String?
        /**
         * The cluster snapshot identifier of the new cluster snapshot created when SkipFinalSnapshot is set to false.
         * Specifying this parameter and also setting the SkipFinalShapshot parameter to true results in an error.
         * Constraints:
         * Must be from 1 to 255 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         */
        var finalDbSnapshotIdentifier: String?
        /**
         * Determines whether a final cluster snapshot is created before the cluster is deleted. If true is specified, no cluster snapshot is created. If false is specified, a cluster snapshot is created before the DB cluster is deleted.
         * If SkipFinalSnapshot is false, you must specify a FinalDBSnapshotIdentifier parameter.
         * Default: false
         */
        var skipFinalSnapshot: Boolean

        fun build(): DeleteDbClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterIdentifier: String? = null
        override var finalDbSnapshotIdentifier: String? = null
        override var skipFinalSnapshot: Boolean = false

        constructor(x: DeleteDbClusterRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        override fun build(): DeleteDbClusterRequest = DeleteDbClusterRequest(this)
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun finalDbSnapshotIdentifier(finalDbSnapshotIdentifier: String): FluentBuilder = apply { this.finalDbSnapshotIdentifier = finalDbSnapshotIdentifier }
        override fun skipFinalSnapshot(skipFinalSnapshot: Boolean): FluentBuilder = apply { this.skipFinalSnapshot = skipFinalSnapshot }
    }
}
