// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about a subnet group.
 */
class DbSubnetGroup private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) for the DB subnet group.
     */
    val dbSubnetGroupArn: String? = builder.dbSubnetGroupArn
    /**
     * Provides the description of the subnet group.
     */
    val dbSubnetGroupDescription: String? = builder.dbSubnetGroupDescription
    /**
     * The name of the subnet group.
     */
    val dbSubnetGroupName: String? = builder.dbSubnetGroupName
    /**
     * Provides the status of the subnet group.
     */
    val subnetGroupStatus: String? = builder.subnetGroupStatus
    /**
     * Detailed information about one or more subnets within a subnet group.
     */
    val subnets: List<Subnet>? = builder.subnets
    /**
     * Provides the virtual private cloud (VPC) ID of the subnet group.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbSubnetGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbSubnetGroup(")
        append("dbSubnetGroupArn=$dbSubnetGroupArn,")
        append("dbSubnetGroupDescription=$dbSubnetGroupDescription,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("subnetGroupStatus=$subnetGroupStatus,")
        append("subnets=$subnets,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbSubnetGroupArn?.hashCode() ?: 0
        result = 31 * result + (dbSubnetGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbSubnetGroup

        if (dbSubnetGroupArn != other.dbSubnetGroupArn) return false
        if (dbSubnetGroupDescription != other.dbSubnetGroupDescription) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (subnetGroupStatus != other.subnetGroupStatus) return false
        if (subnets != other.subnets) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbSubnetGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbSubnetGroup
        /**
         * The Amazon Resource Name (ARN) for the DB subnet group.
         */
        fun dbSubnetGroupArn(dbSubnetGroupArn: String): FluentBuilder
        /**
         * Provides the description of the subnet group.
         */
        fun dbSubnetGroupDescription(dbSubnetGroupDescription: String): FluentBuilder
        /**
         * The name of the subnet group.
         */
        fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder
        /**
         * Provides the status of the subnet group.
         */
        fun subnetGroupStatus(subnetGroupStatus: String): FluentBuilder
        /**
         * Detailed information about one or more subnets within a subnet group.
         */
        fun subnets(subnets: List<Subnet>): FluentBuilder
        /**
         * Provides the virtual private cloud (VPC) ID of the subnet group.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) for the DB subnet group.
         */
        var dbSubnetGroupArn: String?
        /**
         * Provides the description of the subnet group.
         */
        var dbSubnetGroupDescription: String?
        /**
         * The name of the subnet group.
         */
        var dbSubnetGroupName: String?
        /**
         * Provides the status of the subnet group.
         */
        var subnetGroupStatus: String?
        /**
         * Detailed information about one or more subnets within a subnet group.
         */
        var subnets: List<Subnet>?
        /**
         * Provides the virtual private cloud (VPC) ID of the subnet group.
         */
        var vpcId: String?

        fun build(): DbSubnetGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbSubnetGroupArn: String? = null
        override var dbSubnetGroupDescription: String? = null
        override var dbSubnetGroupName: String? = null
        override var subnetGroupStatus: String? = null
        override var subnets: List<Subnet>? = null
        override var vpcId: String? = null

        constructor(x: DbSubnetGroup) : this() {
            this.dbSubnetGroupArn = x.dbSubnetGroupArn
            this.dbSubnetGroupDescription = x.dbSubnetGroupDescription
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.subnetGroupStatus = x.subnetGroupStatus
            this.subnets = x.subnets
            this.vpcId = x.vpcId
        }

        override fun build(): DbSubnetGroup = DbSubnetGroup(this)
        override fun dbSubnetGroupArn(dbSubnetGroupArn: String): FluentBuilder = apply { this.dbSubnetGroupArn = dbSubnetGroupArn }
        override fun dbSubnetGroupDescription(dbSubnetGroupDescription: String): FluentBuilder = apply { this.dbSubnetGroupDescription = dbSubnetGroupDescription }
        override fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder = apply { this.dbSubnetGroupName = dbSubnetGroupName }
        override fun subnetGroupStatus(subnetGroupStatus: String): FluentBuilder = apply { this.subnetGroupStatus = subnetGroupStatus }
        override fun subnets(subnets: List<Subnet>): FluentBuilder = apply { this.subnets = subnets }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
