// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Provides a list of status information for an instance.
 */
class DbInstanceStatusInfo private constructor(builder: BuilderImpl) {
    /**
     * Details of the error if there is an error for the instance. If the instance is not in
     * an error state, this value is blank.
     */
    val message: String? = builder.message
    /**
     * A Boolean value that is true if the instance is operating normally, or
     * false if the instance is in an error state.
     */
    val normal: Boolean = builder.normal
    /**
     * Status of the instance. For a StatusType of read replica, the values
     * can be replicating, error, stopped, or
     * terminated.
     */
    val status: String? = builder.status
    /**
     * This value is currently "read replication."
     */
    val statusType: String? = builder.statusType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbInstanceStatusInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstanceStatusInfo(")
        append("message=$message,")
        append("normal=$normal,")
        append("status=$status,")
        append("statusType=$statusType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (normal.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbInstanceStatusInfo

        if (message != other.message) return false
        if (normal != other.normal) return false
        if (status != other.status) return false
        if (statusType != other.statusType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbInstanceStatusInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbInstanceStatusInfo
        /**
         * Details of the error if there is an error for the instance. If the instance is not in
         * an error state, this value is blank.
         */
        fun message(message: String): FluentBuilder
        /**
         * A Boolean value that is true if the instance is operating normally, or
         * false if the instance is in an error state.
         */
        fun normal(normal: Boolean): FluentBuilder
        /**
         * Status of the instance. For a StatusType of read replica, the values
         * can be replicating, error, stopped, or
         * terminated.
         */
        fun status(status: String): FluentBuilder
        /**
         * This value is currently "read replication."
         */
        fun statusType(statusType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Details of the error if there is an error for the instance. If the instance is not in
         * an error state, this value is blank.
         */
        var message: String?
        /**
         * A Boolean value that is true if the instance is operating normally, or
         * false if the instance is in an error state.
         */
        var normal: Boolean
        /**
         * Status of the instance. For a StatusType of read replica, the values
         * can be replicating, error, stopped, or
         * terminated.
         */
        var status: String?
        /**
         * This value is currently "read replication."
         */
        var statusType: String?

        fun build(): DbInstanceStatusInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var message: String? = null
        override var normal: Boolean = false
        override var status: String? = null
        override var statusType: String? = null

        constructor(x: DbInstanceStatusInfo) : this() {
            this.message = x.message
            this.normal = x.normal
            this.status = x.status
            this.statusType = x.statusType
        }

        override fun build(): DbInstanceStatusInfo = DbInstanceStatusInfo(this)
        override fun message(message: String): FluentBuilder = apply { this.message = message }
        override fun normal(normal: Boolean): FluentBuilder = apply { this.normal = normal }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun statusType(statusType: String): FluentBuilder = apply { this.statusType = statusType }
    }
}
