// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an instance.
 */
class DbInstance private constructor(builder: BuilderImpl) {
    /**
     * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     */
    val autoMinorVersionUpgrade: Boolean = builder.autoMinorVersionUpgrade
    /**
     * Specifies the name of the Availability Zone that the instance is located in.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * Specifies the number of days for which automatic snapshots are retained.
     */
    val backupRetentionPeriod: Int = builder.backupRetentionPeriod
    /**
     * The identifier of the CA certificate for this DB instance.
     */
    val caCertificateIdentifier: String? = builder.caCertificateIdentifier
    /**
     * Contains the name of the cluster that the instance is a member of if the
     * instance is a member of a cluster.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the instance.
     */
    val dbInstanceArn: String? = builder.dbInstanceArn
    /**
     * Contains the name of the compute and memory capacity class of the instance.
     */
    val dbInstanceClass: String? = builder.dbInstanceClass
    /**
     * Contains a user-provided database identifier. This identifier is the unique key that
     * identifies an instance.
     */
    val dbInstanceIdentifier: String? = builder.dbInstanceIdentifier
    /**
     * Specifies the current state of this database.
     */
    val dbInstanceStatus: String? = builder.dbInstanceStatus
    /**
     * Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.
     */
    val dbSubnetGroup: DbSubnetGroup? = builder.dbSubnetGroup
    /**
     * The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
     * accessed.
     */
    val dbiResourceId: String? = builder.dbiResourceId
    /**
     * A list of log types that this instance is configured to export to CloudWatch Logs.
     */
    val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint.
     */
    val endpoint: Endpoint? = builder.endpoint
    /**
     * Provides the name of the database engine to be used for this instance.
     */
    val engine: String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * Provides the date and time that the instance was created.
     */
    val instanceCreateTime: Instant? = builder.instanceCreateTime
    /**
     * If StorageEncrypted is true, the KMS key identifier for
     * the encrypted instance.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time
     * restore.
     */
    val latestRestorableTime: Instant? = builder.latestRestorableTime
    /**
     * Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.
     */
    val pendingModifiedValues: PendingModifiedValues? = builder.pendingModifiedValues
    /**
     * Specifies the daily time range during which automated backups are created if
     * automated backups are enabled, as determined by the BackupRetentionPeriod.
     */
    val preferredBackupWindow: String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in
     * Universal Coordinated Time (UTC).
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
     * primary instance after a failure of the existing primary instance.
     */
    val promotionTier: Int? = builder.promotionTier
    /**
     * Not supported. Amazon DocumentDB does not currently support public endpoints. The value
     * of PubliclyAccessible is always false.
     */
    val publiclyAccessible: Boolean = builder.publiclyAccessible
    /**
     * The status of a read replica. If the instance is not a read replica, this is
     * blank.
     */
    val statusInfos: List<DbInstanceStatusInfo>? = builder.statusInfos
    /**
     * Specifies whether or not the instance is encrypted.
     */
    val storageEncrypted: Boolean = builder.storageEncrypted
    /**
     * Provides a list of VPC security group elements that the instance belongs to.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbInstance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstance(")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceArn=$dbInstanceArn,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbInstanceStatus=$dbInstanceStatus,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("dbiResourceId=$dbiResourceId,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("statusInfos=$statusInfos,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMinorVersionUpgrade.hashCode()
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible.hashCode())
        result = 31 * result + (statusInfos?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbInstance

        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceArn != other.dbInstanceArn) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbInstanceStatus != other.dbInstanceStatus) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (statusInfos != other.statusInfos) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbInstance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbInstance
        /**
         * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         */
        fun autoMinorVersionUpgrade(autoMinorVersionUpgrade: Boolean): FluentBuilder
        /**
         * Specifies the name of the Availability Zone that the instance is located in.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * Specifies the number of days for which automatic snapshots are retained.
         */
        fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder
        /**
         * The identifier of the CA certificate for this DB instance.
         */
        fun caCertificateIdentifier(caCertificateIdentifier: String): FluentBuilder
        /**
         * Contains the name of the cluster that the instance is a member of if the
         * instance is a member of a cluster.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the instance.
         */
        fun dbInstanceArn(dbInstanceArn: String): FluentBuilder
        /**
         * Contains the name of the compute and memory capacity class of the instance.
         */
        fun dbInstanceClass(dbInstanceClass: String): FluentBuilder
        /**
         * Contains a user-provided database identifier. This identifier is the unique key that
         * identifies an instance.
         */
        fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder
        /**
         * Specifies the current state of this database.
         */
        fun dbInstanceStatus(dbInstanceStatus: String): FluentBuilder
        /**
         * Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.
         */
        fun dbSubnetGroup(dbSubnetGroup: DbSubnetGroup): FluentBuilder
        /**
         * The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
         * accessed.
         */
        fun dbiResourceId(dbiResourceId: String): FluentBuilder
        /**
         * A list of log types that this instance is configured to export to CloudWatch Logs.
         */
        fun enabledCloudwatchLogsExports(enabledCloudwatchLogsExports: List<String>): FluentBuilder
        /**
         * Specifies the connection endpoint.
         */
        fun endpoint(endpoint: Endpoint): FluentBuilder
        /**
         * Provides the name of the database engine to be used for this instance.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * Indicates the database engine version.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * Provides the date and time that the instance was created.
         */
        fun instanceCreateTime(instanceCreateTime: Instant): FluentBuilder
        /**
         * If StorageEncrypted is true, the KMS key identifier for
         * the encrypted instance.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * Specifies the latest time to which a database can be restored with point-in-time
         * restore.
         */
        fun latestRestorableTime(latestRestorableTime: Instant): FluentBuilder
        /**
         * Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.
         */
        fun pendingModifiedValues(pendingModifiedValues: PendingModifiedValues): FluentBuilder
        /**
         * Specifies the daily time range during which automated backups are created if
         * automated backups are enabled, as determined by the BackupRetentionPeriod.
         */
        fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder
        /**
         * Specifies the weekly time range during which system maintenance can occur, in
         * Universal Coordinated Time (UTC).
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
         * primary instance after a failure of the existing primary instance.
         */
        fun promotionTier(promotionTier: Int): FluentBuilder
        /**
         * Not supported. Amazon DocumentDB does not currently support public endpoints. The value
         * of PubliclyAccessible is always false.
         */
        fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder
        /**
         * The status of a read replica. If the instance is not a read replica, this is
         * blank.
         */
        fun statusInfos(statusInfos: List<DbInstanceStatusInfo>): FluentBuilder
        /**
         * Specifies whether or not the instance is encrypted.
         */
        fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder
        /**
         * Provides a list of VPC security group elements that the instance belongs to.
         */
        fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Does not apply. This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         */
        var autoMinorVersionUpgrade: Boolean
        /**
         * Specifies the name of the Availability Zone that the instance is located in.
         */
        var availabilityZone: String?
        /**
         * Specifies the number of days for which automatic snapshots are retained.
         */
        var backupRetentionPeriod: Int
        /**
         * The identifier of the CA certificate for this DB instance.
         */
        var caCertificateIdentifier: String?
        /**
         * Contains the name of the cluster that the instance is a member of if the
         * instance is a member of a cluster.
         */
        var dbClusterIdentifier: String?
        /**
         * The Amazon Resource Name (ARN) for the instance.
         */
        var dbInstanceArn: String?
        /**
         * Contains the name of the compute and memory capacity class of the instance.
         */
        var dbInstanceClass: String?
        /**
         * Contains a user-provided database identifier. This identifier is the unique key that
         * identifies an instance.
         */
        var dbInstanceIdentifier: String?
        /**
         * Specifies the current state of this database.
         */
        var dbInstanceStatus: String?
        /**
         * Specifies information on the subnet group that is associated with the instance, including the name, description, and subnets in the subnet group.
         */
        var dbSubnetGroup: DbSubnetGroup?
        /**
         * The Region-unique, immutable identifier for the instance. This identifier is found in CloudTrail log entries whenever the KMS key for the instance is
         * accessed.
         */
        var dbiResourceId: String?
        /**
         * A list of log types that this instance is configured to export to CloudWatch Logs.
         */
        var enabledCloudwatchLogsExports: List<String>?
        /**
         * Specifies the connection endpoint.
         */
        var endpoint: Endpoint?
        /**
         * Provides the name of the database engine to be used for this instance.
         */
        var engine: String?
        /**
         * Indicates the database engine version.
         */
        var engineVersion: String?
        /**
         * Provides the date and time that the instance was created.
         */
        var instanceCreateTime: Instant?
        /**
         * If StorageEncrypted is true, the KMS key identifier for
         * the encrypted instance.
         */
        var kmsKeyId: String?
        /**
         * Specifies the latest time to which a database can be restored with point-in-time
         * restore.
         */
        var latestRestorableTime: Instant?
        /**
         * Specifies that changes to the instance are pending. This element is included only when changes are pending. Specific changes are identified by subelements.
         */
        var pendingModifiedValues: PendingModifiedValues?
        /**
         * Specifies the daily time range during which automated backups are created if
         * automated backups are enabled, as determined by the BackupRetentionPeriod.
         */
        var preferredBackupWindow: String?
        /**
         * Specifies the weekly time range during which system maintenance can occur, in
         * Universal Coordinated Time (UTC).
         */
        var preferredMaintenanceWindow: String?
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
         * primary instance after a failure of the existing primary instance.
         */
        var promotionTier: Int?
        /**
         * Not supported. Amazon DocumentDB does not currently support public endpoints. The value
         * of PubliclyAccessible is always false.
         */
        var publiclyAccessible: Boolean
        /**
         * The status of a read replica. If the instance is not a read replica, this is
         * blank.
         */
        var statusInfos: List<DbInstanceStatusInfo>?
        /**
         * Specifies whether or not the instance is encrypted.
         */
        var storageEncrypted: Boolean
        /**
         * Provides a list of VPC security group elements that the instance belongs to.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>?

        fun build(): DbInstance
        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.DbSubnetGroup] inside the given [block]
         */
        fun dbSubnetGroup(block: DbSubnetGroup.DslBuilder.() -> kotlin.Unit) {
            this.dbSubnetGroup = DbSubnetGroup.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.Endpoint] inside the given [block]
         */
        fun endpoint(block: Endpoint.DslBuilder.() -> kotlin.Unit) {
            this.endpoint = Endpoint.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.docdb.model.PendingModifiedValues] inside the given [block]
         */
        fun pendingModifiedValues(block: PendingModifiedValues.DslBuilder.() -> kotlin.Unit) {
            this.pendingModifiedValues = PendingModifiedValues.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoMinorVersionUpgrade: Boolean = false
        override var availabilityZone: String? = null
        override var backupRetentionPeriod: Int = 0
        override var caCertificateIdentifier: String? = null
        override var dbClusterIdentifier: String? = null
        override var dbInstanceArn: String? = null
        override var dbInstanceClass: String? = null
        override var dbInstanceIdentifier: String? = null
        override var dbInstanceStatus: String? = null
        override var dbSubnetGroup: DbSubnetGroup? = null
        override var dbiResourceId: String? = null
        override var enabledCloudwatchLogsExports: List<String>? = null
        override var endpoint: Endpoint? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var instanceCreateTime: Instant? = null
        override var kmsKeyId: String? = null
        override var latestRestorableTime: Instant? = null
        override var pendingModifiedValues: PendingModifiedValues? = null
        override var preferredBackupWindow: String? = null
        override var preferredMaintenanceWindow: String? = null
        override var promotionTier: Int? = null
        override var publiclyAccessible: Boolean = false
        override var statusInfos: List<DbInstanceStatusInfo>? = null
        override var storageEncrypted: Boolean = false
        override var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        constructor(x: DbInstance) : this() {
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceArn = x.dbInstanceArn
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbInstanceStatus = x.dbInstanceStatus
            this.dbSubnetGroup = x.dbSubnetGroup
            this.dbiResourceId = x.dbiResourceId
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.instanceCreateTime = x.instanceCreateTime
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.statusInfos = x.statusInfos
            this.storageEncrypted = x.storageEncrypted
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        override fun build(): DbInstance = DbInstance(this)
        override fun autoMinorVersionUpgrade(autoMinorVersionUpgrade: Boolean): FluentBuilder = apply { this.autoMinorVersionUpgrade = autoMinorVersionUpgrade }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder = apply { this.backupRetentionPeriod = backupRetentionPeriod }
        override fun caCertificateIdentifier(caCertificateIdentifier: String): FluentBuilder = apply { this.caCertificateIdentifier = caCertificateIdentifier }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbInstanceArn(dbInstanceArn: String): FluentBuilder = apply { this.dbInstanceArn = dbInstanceArn }
        override fun dbInstanceClass(dbInstanceClass: String): FluentBuilder = apply { this.dbInstanceClass = dbInstanceClass }
        override fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder = apply { this.dbInstanceIdentifier = dbInstanceIdentifier }
        override fun dbInstanceStatus(dbInstanceStatus: String): FluentBuilder = apply { this.dbInstanceStatus = dbInstanceStatus }
        override fun dbSubnetGroup(dbSubnetGroup: DbSubnetGroup): FluentBuilder = apply { this.dbSubnetGroup = dbSubnetGroup }
        override fun dbiResourceId(dbiResourceId: String): FluentBuilder = apply { this.dbiResourceId = dbiResourceId }
        override fun enabledCloudwatchLogsExports(enabledCloudwatchLogsExports: List<String>): FluentBuilder = apply { this.enabledCloudwatchLogsExports = enabledCloudwatchLogsExports }
        override fun endpoint(endpoint: Endpoint): FluentBuilder = apply { this.endpoint = endpoint }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun instanceCreateTime(instanceCreateTime: Instant): FluentBuilder = apply { this.instanceCreateTime = instanceCreateTime }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun latestRestorableTime(latestRestorableTime: Instant): FluentBuilder = apply { this.latestRestorableTime = latestRestorableTime }
        override fun pendingModifiedValues(pendingModifiedValues: PendingModifiedValues): FluentBuilder = apply { this.pendingModifiedValues = pendingModifiedValues }
        override fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder = apply { this.preferredBackupWindow = preferredBackupWindow }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun promotionTier(promotionTier: Int): FluentBuilder = apply { this.promotionTier = promotionTier }
        override fun publiclyAccessible(publiclyAccessible: Boolean): FluentBuilder = apply { this.publiclyAccessible = publiclyAccessible }
        override fun statusInfos(statusInfos: List<DbInstanceStatusInfo>): FluentBuilder = apply { this.statusInfos = statusInfos }
        override fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder = apply { this.storageEncrypted = storageEncrypted }
        override fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder = apply { this.vpcSecurityGroups = vpcSecurityGroups }
    }
}
