// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about an engine version.
 */
class DbEngineVersion private constructor(builder: BuilderImpl) {
    /**
     * The description of the database engine.
     */
    val dbEngineDescription: String? = builder.dbEngineDescription
    /**
     * The description of the database engine version.
     */
    val dbEngineVersionDescription: String? = builder.dbEngineVersionDescription
    /**
     * The name of the parameter group family for the database engine.
     */
    val dbParameterGroupFamily: String? = builder.dbParameterGroupFamily
    /**
     * The name of the database engine.
     */
    val engine: String? = builder.engine
    /**
     * The version number of the database engine.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * The types of logs that the database engine has available for export to Amazon
     * CloudWatch Logs.
     */
    val exportableLogTypes: List<String>? = builder.exportableLogTypes
    /**
     * A value that indicates whether the engine version supports exporting the log types
     * specified by ExportableLogTypes to CloudWatch Logs.
     */
    val supportsLogExportsToCloudwatchLogs: Boolean = builder.supportsLogExportsToCloudwatchLogs
    /**
     * A list of engine versions that this database engine version can be upgraded to.
     */
    val validUpgradeTarget: List<UpgradeTarget>? = builder.validUpgradeTarget

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbEngineVersion = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbEngineVersion(")
        append("dbEngineDescription=$dbEngineDescription,")
        append("dbEngineVersionDescription=$dbEngineVersionDescription,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("exportableLogTypes=$exportableLogTypes,")
        append("supportsLogExportsToCloudwatchLogs=$supportsLogExportsToCloudwatchLogs,")
        append("validUpgradeTarget=$validUpgradeTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbEngineDescription?.hashCode() ?: 0
        result = 31 * result + (dbEngineVersionDescription?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (exportableLogTypes?.hashCode() ?: 0)
        result = 31 * result + (supportsLogExportsToCloudwatchLogs.hashCode())
        result = 31 * result + (validUpgradeTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbEngineVersion

        if (dbEngineDescription != other.dbEngineDescription) return false
        if (dbEngineVersionDescription != other.dbEngineVersionDescription) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (exportableLogTypes != other.exportableLogTypes) return false
        if (supportsLogExportsToCloudwatchLogs != other.supportsLogExportsToCloudwatchLogs) return false
        if (validUpgradeTarget != other.validUpgradeTarget) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbEngineVersion = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbEngineVersion
        /**
         * The description of the database engine.
         */
        fun dbEngineDescription(dbEngineDescription: String): FluentBuilder
        /**
         * The description of the database engine version.
         */
        fun dbEngineVersionDescription(dbEngineVersionDescription: String): FluentBuilder
        /**
         * The name of the parameter group family for the database engine.
         */
        fun dbParameterGroupFamily(dbParameterGroupFamily: String): FluentBuilder
        /**
         * The name of the database engine.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The version number of the database engine.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * The types of logs that the database engine has available for export to Amazon
         * CloudWatch Logs.
         */
        fun exportableLogTypes(exportableLogTypes: List<String>): FluentBuilder
        /**
         * A value that indicates whether the engine version supports exporting the log types
         * specified by ExportableLogTypes to CloudWatch Logs.
         */
        fun supportsLogExportsToCloudwatchLogs(supportsLogExportsToCloudwatchLogs: Boolean): FluentBuilder
        /**
         * A list of engine versions that this database engine version can be upgraded to.
         */
        fun validUpgradeTarget(validUpgradeTarget: List<UpgradeTarget>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the database engine.
         */
        var dbEngineDescription: String?
        /**
         * The description of the database engine version.
         */
        var dbEngineVersionDescription: String?
        /**
         * The name of the parameter group family for the database engine.
         */
        var dbParameterGroupFamily: String?
        /**
         * The name of the database engine.
         */
        var engine: String?
        /**
         * The version number of the database engine.
         */
        var engineVersion: String?
        /**
         * The types of logs that the database engine has available for export to Amazon
         * CloudWatch Logs.
         */
        var exportableLogTypes: List<String>?
        /**
         * A value that indicates whether the engine version supports exporting the log types
         * specified by ExportableLogTypes to CloudWatch Logs.
         */
        var supportsLogExportsToCloudwatchLogs: Boolean
        /**
         * A list of engine versions that this database engine version can be upgraded to.
         */
        var validUpgradeTarget: List<UpgradeTarget>?

        fun build(): DbEngineVersion
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbEngineDescription: String? = null
        override var dbEngineVersionDescription: String? = null
        override var dbParameterGroupFamily: String? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var exportableLogTypes: List<String>? = null
        override var supportsLogExportsToCloudwatchLogs: Boolean = false
        override var validUpgradeTarget: List<UpgradeTarget>? = null

        constructor(x: DbEngineVersion) : this() {
            this.dbEngineDescription = x.dbEngineDescription
            this.dbEngineVersionDescription = x.dbEngineVersionDescription
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.exportableLogTypes = x.exportableLogTypes
            this.supportsLogExportsToCloudwatchLogs = x.supportsLogExportsToCloudwatchLogs
            this.validUpgradeTarget = x.validUpgradeTarget
        }

        override fun build(): DbEngineVersion = DbEngineVersion(this)
        override fun dbEngineDescription(dbEngineDescription: String): FluentBuilder = apply { this.dbEngineDescription = dbEngineDescription }
        override fun dbEngineVersionDescription(dbEngineVersionDescription: String): FluentBuilder = apply { this.dbEngineVersionDescription = dbEngineVersionDescription }
        override fun dbParameterGroupFamily(dbParameterGroupFamily: String): FluentBuilder = apply { this.dbParameterGroupFamily = dbParameterGroupFamily }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun exportableLogTypes(exportableLogTypes: List<String>): FluentBuilder = apply { this.exportableLogTypes = exportableLogTypes }
        override fun supportsLogExportsToCloudwatchLogs(supportsLogExportsToCloudwatchLogs: Boolean): FluentBuilder = apply { this.supportsLogExportsToCloudwatchLogs = supportsLogExportsToCloudwatchLogs }
        override fun validUpgradeTarget(validUpgradeTarget: List<UpgradeTarget>): FluentBuilder = apply { this.validUpgradeTarget = validUpgradeTarget }
    }
}
