// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about a cluster snapshot.
 */
class DbClusterSnapshot private constructor(builder: BuilderImpl) {
    /**
     * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
     * snapshot can be restored in.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the time when the cluster was created, in Universal Coordinated Time
     * (UTC).
     */
    val clusterCreateTime: Instant? = builder.clusterCreateTime
    /**
     * Specifies the cluster identifier of the cluster that this cluster snapshot
     * was created from.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the cluster snapshot.
     */
    val dbClusterSnapshotArn: String? = builder.dbClusterSnapshotArn
    /**
     * Specifies the identifier for the cluster snapshot.
     */
    val dbClusterSnapshotIdentifier: String? = builder.dbClusterSnapshotIdentifier
    /**
     * Specifies the name of the database engine.
     */
    val engine: String? = builder.engine
    /**
     * Provides the version of the database engine for this cluster snapshot.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * If StorageEncrypted is true, the KMS key identifier for the encrypted cluster snapshot.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * Provides the master user name for the cluster snapshot.
     */
    val masterUsername: String? = builder.masterUsername
    /**
     * Specifies the percentage of the estimated data that has been transferred.
     */
    val percentProgress: Int = builder.percentProgress
    /**
     * Specifies the port that the cluster was listening on at the time of the
     * snapshot.
     */
    val port: Int = builder.port
    /**
     * Provides the time when the snapshot was taken, in UTC.
     */
    val snapshotCreateTime: Instant? = builder.snapshotCreateTime
    /**
     * Provides the type of the cluster snapshot.
     */
    val snapshotType: String? = builder.snapshotType
    /**
     * If the cluster snapshot was copied from a source cluster snapshot, the ARN for
     * the source cluster snapshot; otherwise, a null value.
     */
    val sourceDbClusterSnapshotArn: String? = builder.sourceDbClusterSnapshotArn
    /**
     * Specifies the status of this cluster snapshot.
     */
    val status: String? = builder.status
    /**
     * Specifies whether the cluster snapshot is encrypted.
     */
    val storageEncrypted: Boolean = builder.storageEncrypted
    /**
     * Provides the virtual private cloud (VPC) ID that is associated with the cluster
     * snapshot.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbClusterSnapshot = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterSnapshot(")
        append("availabilityZones=$availabilityZones,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotArn=$dbClusterSnapshotArn,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUsername=$masterUsername,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotType=$snapshotType,")
        append("sourceDbClusterSnapshotArn=$sourceDbClusterSnapshotArn,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (port)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbClusterSnapshot

        if (availabilityZones != other.availabilityZones) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotArn != other.dbClusterSnapshotArn) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUsername != other.masterUsername) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceDbClusterSnapshotArn != other.sourceDbClusterSnapshotArn) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbClusterSnapshot = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbClusterSnapshot
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
         * snapshot can be restored in.
         */
        fun availabilityZones(availabilityZones: List<String>): FluentBuilder
        /**
         * Specifies the time when the cluster was created, in Universal Coordinated Time
         * (UTC).
         */
        fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder
        /**
         * Specifies the cluster identifier of the cluster that this cluster snapshot
         * was created from.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the cluster snapshot.
         */
        fun dbClusterSnapshotArn(dbClusterSnapshotArn: String): FluentBuilder
        /**
         * Specifies the identifier for the cluster snapshot.
         */
        fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder
        /**
         * Specifies the name of the database engine.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * Provides the version of the database engine for this cluster snapshot.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * If StorageEncrypted is true, the KMS key identifier for the encrypted cluster snapshot.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * Provides the master user name for the cluster snapshot.
         */
        fun masterUsername(masterUsername: String): FluentBuilder
        /**
         * Specifies the percentage of the estimated data that has been transferred.
         */
        fun percentProgress(percentProgress: Int): FluentBuilder
        /**
         * Specifies the port that the cluster was listening on at the time of the
         * snapshot.
         */
        fun port(port: Int): FluentBuilder
        /**
         * Provides the time when the snapshot was taken, in UTC.
         */
        fun snapshotCreateTime(snapshotCreateTime: Instant): FluentBuilder
        /**
         * Provides the type of the cluster snapshot.
         */
        fun snapshotType(snapshotType: String): FluentBuilder
        /**
         * If the cluster snapshot was copied from a source cluster snapshot, the ARN for
         * the source cluster snapshot; otherwise, a null value.
         */
        fun sourceDbClusterSnapshotArn(sourceDbClusterSnapshotArn: String): FluentBuilder
        /**
         * Specifies the status of this cluster snapshot.
         */
        fun status(status: String): FluentBuilder
        /**
         * Specifies whether the cluster snapshot is encrypted.
         */
        fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder
        /**
         * Provides the virtual private cloud (VPC) ID that is associated with the cluster
         * snapshot.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
         * snapshot can be restored in.
         */
        var availabilityZones: List<String>?
        /**
         * Specifies the time when the cluster was created, in Universal Coordinated Time
         * (UTC).
         */
        var clusterCreateTime: Instant?
        /**
         * Specifies the cluster identifier of the cluster that this cluster snapshot
         * was created from.
         */
        var dbClusterIdentifier: String?
        /**
         * The Amazon Resource Name (ARN) for the cluster snapshot.
         */
        var dbClusterSnapshotArn: String?
        /**
         * Specifies the identifier for the cluster snapshot.
         */
        var dbClusterSnapshotIdentifier: String?
        /**
         * Specifies the name of the database engine.
         */
        var engine: String?
        /**
         * Provides the version of the database engine for this cluster snapshot.
         */
        var engineVersion: String?
        /**
         * If StorageEncrypted is true, the KMS key identifier for the encrypted cluster snapshot.
         */
        var kmsKeyId: String?
        /**
         * Provides the master user name for the cluster snapshot.
         */
        var masterUsername: String?
        /**
         * Specifies the percentage of the estimated data that has been transferred.
         */
        var percentProgress: Int
        /**
         * Specifies the port that the cluster was listening on at the time of the
         * snapshot.
         */
        var port: Int
        /**
         * Provides the time when the snapshot was taken, in UTC.
         */
        var snapshotCreateTime: Instant?
        /**
         * Provides the type of the cluster snapshot.
         */
        var snapshotType: String?
        /**
         * If the cluster snapshot was copied from a source cluster snapshot, the ARN for
         * the source cluster snapshot; otherwise, a null value.
         */
        var sourceDbClusterSnapshotArn: String?
        /**
         * Specifies the status of this cluster snapshot.
         */
        var status: String?
        /**
         * Specifies whether the cluster snapshot is encrypted.
         */
        var storageEncrypted: Boolean
        /**
         * Provides the virtual private cloud (VPC) ID that is associated with the cluster
         * snapshot.
         */
        var vpcId: String?

        fun build(): DbClusterSnapshot
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZones: List<String>? = null
        override var clusterCreateTime: Instant? = null
        override var dbClusterIdentifier: String? = null
        override var dbClusterSnapshotArn: String? = null
        override var dbClusterSnapshotIdentifier: String? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var kmsKeyId: String? = null
        override var masterUsername: String? = null
        override var percentProgress: Int = 0
        override var port: Int = 0
        override var snapshotCreateTime: Instant? = null
        override var snapshotType: String? = null
        override var sourceDbClusterSnapshotArn: String? = null
        override var status: String? = null
        override var storageEncrypted: Boolean = false
        override var vpcId: String? = null

        constructor(x: DbClusterSnapshot) : this() {
            this.availabilityZones = x.availabilityZones
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotArn = x.dbClusterSnapshotArn
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.masterUsername = x.masterUsername
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotType = x.snapshotType
            this.sourceDbClusterSnapshotArn = x.sourceDbClusterSnapshotArn
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.vpcId = x.vpcId
        }

        override fun build(): DbClusterSnapshot = DbClusterSnapshot(this)
        override fun availabilityZones(availabilityZones: List<String>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder = apply { this.clusterCreateTime = clusterCreateTime }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbClusterSnapshotArn(dbClusterSnapshotArn: String): FluentBuilder = apply { this.dbClusterSnapshotArn = dbClusterSnapshotArn }
        override fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder = apply { this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun masterUsername(masterUsername: String): FluentBuilder = apply { this.masterUsername = masterUsername }
        override fun percentProgress(percentProgress: Int): FluentBuilder = apply { this.percentProgress = percentProgress }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun snapshotCreateTime(snapshotCreateTime: Instant): FluentBuilder = apply { this.snapshotCreateTime = snapshotCreateTime }
        override fun snapshotType(snapshotType: String): FluentBuilder = apply { this.snapshotType = snapshotType }
        override fun sourceDbClusterSnapshotArn(sourceDbClusterSnapshotArn: String): FluentBuilder = apply { this.sourceDbClusterSnapshotArn = sourceDbClusterSnapshotArn }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder = apply { this.storageEncrypted = storageEncrypted }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
