// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Describes an Identity and Access Management (IAM) role that is associated with a
 * cluster.
 */
class DbClusterRole private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
     * cluster.
     */
    val roleArn: String? = builder.roleArn
    /**
     * Describes the state of association between the IAMrole and the cluster. The Status property returns one of the following values:
     * ACTIVE - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.
     * PENDING - The IAMrole ARN is being associated with the cluster.
     * INVALID - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.
     */
    val status: String? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbClusterRole = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterRole(")
        append("roleArn=$roleArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbClusterRole

        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbClusterRole = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbClusterRole
        /**
         * The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
         * cluster.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * Describes the state of association between the IAMrole and the cluster. The Status property returns one of the following values:
         * ACTIVE - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.
         * PENDING - The IAMrole ARN is being associated with the cluster.
         * INVALID - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.
         */
        fun status(status: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the IAMrole that is associated with the DB
         * cluster.
         */
        var roleArn: String?
        /**
         * Describes the state of association between the IAMrole and the cluster. The Status property returns one of the following values:
         * ACTIVE - The IAMrole ARN is associated with the cluster and can be used to access other Amazon Web Services services on your behalf.
         * PENDING - The IAMrole ARN is being associated with the cluster.
         * INVALID - The IAMrole ARN is associated with the cluster, but the cluster cannot assume the IAMrole to access other Amazon Web Services services on your behalf.
         */
        var status: String?

        fun build(): DbClusterRole
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var roleArn: String? = null
        override var status: String? = null

        constructor(x: DbClusterRole) : this() {
            this.roleArn = x.roleArn
            this.status = x.status
        }

        override fun build(): DbClusterRole = DbClusterRole(this)
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
    }
}
