// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Detailed information about a cluster parameter group.
 */
class DbClusterParameterGroup private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) for the cluster parameter group.
     */
    val dbClusterParameterGroupArn: String? = builder.dbClusterParameterGroupArn
    /**
     * Provides the name of the cluster parameter group.
     */
    val dbClusterParameterGroupName: String? = builder.dbClusterParameterGroupName
    /**
     * Provides the name of the parameter group family that this cluster parameter
     * group is compatible with.
     */
    val dbParameterGroupFamily: String? = builder.dbParameterGroupFamily
    /**
     * Provides the customer-specified description for this cluster parameter
     * group.
     */
    val description: String? = builder.description

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbClusterParameterGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterParameterGroup(")
        append("dbClusterParameterGroupArn=$dbClusterParameterGroupArn,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("description=$description)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupArn?.hashCode() ?: 0
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupFamily?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbClusterParameterGroup

        if (dbClusterParameterGroupArn != other.dbClusterParameterGroupArn) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (description != other.description) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbClusterParameterGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbClusterParameterGroup
        /**
         * The Amazon Resource Name (ARN) for the cluster parameter group.
         */
        fun dbClusterParameterGroupArn(dbClusterParameterGroupArn: String): FluentBuilder
        /**
         * Provides the name of the cluster parameter group.
         */
        fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder
        /**
         * Provides the name of the parameter group family that this cluster parameter
         * group is compatible with.
         */
        fun dbParameterGroupFamily(dbParameterGroupFamily: String): FluentBuilder
        /**
         * Provides the customer-specified description for this cluster parameter
         * group.
         */
        fun description(description: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) for the cluster parameter group.
         */
        var dbClusterParameterGroupArn: String?
        /**
         * Provides the name of the cluster parameter group.
         */
        var dbClusterParameterGroupName: String?
        /**
         * Provides the name of the parameter group family that this cluster parameter
         * group is compatible with.
         */
        var dbParameterGroupFamily: String?
        /**
         * Provides the customer-specified description for this cluster parameter
         * group.
         */
        var description: String?

        fun build(): DbClusterParameterGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterParameterGroupArn: String? = null
        override var dbClusterParameterGroupName: String? = null
        override var dbParameterGroupFamily: String? = null
        override var description: String? = null

        constructor(x: DbClusterParameterGroup) : this() {
            this.dbClusterParameterGroupArn = x.dbClusterParameterGroupArn
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.description = x.description
        }

        override fun build(): DbClusterParameterGroup = DbClusterParameterGroup(this)
        override fun dbClusterParameterGroupArn(dbClusterParameterGroupArn: String): FluentBuilder = apply { this.dbClusterParameterGroupArn = dbClusterParameterGroupArn }
        override fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder = apply { this.dbClusterParameterGroupName = dbClusterParameterGroupName }
        override fun dbParameterGroupFamily(dbParameterGroupFamily: String): FluentBuilder = apply { this.dbParameterGroupFamily = dbParameterGroupFamily }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
    }
}
