// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Contains information about an instance that is part of a cluster.
 */
class DbClusterMember private constructor(builder: BuilderImpl) {
    /**
     * Specifies the status of the cluster parameter group for this member of the DB
     * cluster.
     */
    val dbClusterParameterGroupStatus: String? = builder.dbClusterParameterGroupStatus
    /**
     * Specifies the instance identifier for this member of the cluster.
     */
    val dbInstanceIdentifier: String? = builder.dbInstanceIdentifier
    /**
     * A value that is true if the cluster member is the primary instance for
     * the cluster and false otherwise.
     */
    val isClusterWriter: Boolean = builder.isClusterWriter
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
     * primary instance after a failure of the existing primary instance.
     */
    val promotionTier: Int? = builder.promotionTier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbClusterMember = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterMember(")
        append("dbClusterParameterGroupStatus=$dbClusterParameterGroupStatus,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("isClusterWriter=$isClusterWriter,")
        append("promotionTier=$promotionTier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterParameterGroupStatus?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (isClusterWriter.hashCode())
        result = 31 * result + (promotionTier ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbClusterMember

        if (dbClusterParameterGroupStatus != other.dbClusterParameterGroupStatus) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (isClusterWriter != other.isClusterWriter) return false
        if (promotionTier != other.promotionTier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbClusterMember = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbClusterMember
        /**
         * Specifies the status of the cluster parameter group for this member of the DB
         * cluster.
         */
        fun dbClusterParameterGroupStatus(dbClusterParameterGroupStatus: String): FluentBuilder
        /**
         * Specifies the instance identifier for this member of the cluster.
         */
        fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder
        /**
         * A value that is true if the cluster member is the primary instance for
         * the cluster and false otherwise.
         */
        fun isClusterWriter(isClusterWriter: Boolean): FluentBuilder
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
         * primary instance after a failure of the existing primary instance.
         */
        fun promotionTier(promotionTier: Int): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the status of the cluster parameter group for this member of the DB
         * cluster.
         */
        var dbClusterParameterGroupStatus: String?
        /**
         * Specifies the instance identifier for this member of the cluster.
         */
        var dbInstanceIdentifier: String?
        /**
         * A value that is true if the cluster member is the primary instance for
         * the cluster and false otherwise.
         */
        var isClusterWriter: Boolean
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
         * primary instance after a failure of the existing primary instance.
         */
        var promotionTier: Int?

        fun build(): DbClusterMember
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterParameterGroupStatus: String? = null
        override var dbInstanceIdentifier: String? = null
        override var isClusterWriter: Boolean = false
        override var promotionTier: Int? = null

        constructor(x: DbClusterMember) : this() {
            this.dbClusterParameterGroupStatus = x.dbClusterParameterGroupStatus
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.isClusterWriter = x.isClusterWriter
            this.promotionTier = x.promotionTier
        }

        override fun build(): DbClusterMember = DbClusterMember(this)
        override fun dbClusterParameterGroupStatus(dbClusterParameterGroupStatus: String): FluentBuilder = apply { this.dbClusterParameterGroupStatus = dbClusterParameterGroupStatus }
        override fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder = apply { this.dbInstanceIdentifier = dbInstanceIdentifier }
        override fun isClusterWriter(isClusterWriter: Boolean): FluentBuilder = apply { this.isClusterWriter = isClusterWriter }
        override fun promotionTier(promotionTier: Int): FluentBuilder = apply { this.promotionTier = promotionTier }
    }
}
