// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about a cluster.
 */
class DbCluster private constructor(builder: BuilderImpl) {
    /**
     * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.
     */
    val associatedRoles: List<DbClusterRole>? = builder.associatedRoles
    /**
     * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
     * can be created in.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the number of days for which automatic snapshots are retained.
     */
    val backupRetentionPeriod: Int? = builder.backupRetentionPeriod
    /**
     * Specifies the time when the cluster was created, in Universal Coordinated Time
     * (UTC).
     */
    val clusterCreateTime: Instant? = builder.clusterCreateTime
    /**
     * The Amazon Resource Name (ARN) for the cluster.
     */
    val dbClusterArn: String? = builder.dbClusterArn
    /**
     * Contains a user-supplied cluster identifier. This identifier is the unique key that
     * identifies a cluster.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * Provides the list of instances that make up the cluster.
     */
    val dbClusterMembers: List<DbClusterMember>? = builder.dbClusterMembers
    /**
     * Specifies the name of the cluster parameter group for the cluster.
     */
    val dbClusterParameterGroup: String? = builder.dbClusterParameterGroup
    /**
     * The Region-unique, immutable identifier for the cluster. This identifier is
     * found in CloudTrail log entries whenever the KMS key for the cluster is accessed.
     */
    val dbClusterResourceId: String? = builder.dbClusterResourceId
    /**
     * Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.
     */
    val dbSubnetGroup: String? = builder.dbSubnetGroup
    /**
     * Specifies whether this cluster can be deleted. If DeletionProtection is
     * enabled, the cluster cannot be deleted unless it is modified and
     * DeletionProtection is disabled. DeletionProtection
     * protects clusters from being accidentally deleted.
     */
    val deletionProtection: Boolean = builder.deletionProtection
    /**
     * The earliest time to which a database can be restored with point-in-time
     * restore.
     */
    val earliestRestorableTime: Instant? = builder.earliestRestorableTime
    /**
     * A list of log types that this cluster is configured to export to Amazon CloudWatch
     * Logs.
     */
    val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * Specifies the connection endpoint for the primary instance of the cluster.
     */
    val endpoint: String? = builder.endpoint
    /**
     * Provides the name of the database engine to be used for this cluster.
     */
    val engine: String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    val hostedZoneId: String? = builder.hostedZoneId
    /**
     * If StorageEncrypted is true, the KMS key identifier for
     * the encrypted cluster.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time
     * restore.
     */
    val latestRestorableTime: Instant? = builder.latestRestorableTime
    /**
     * Contains the master user name for the cluster.
     */
    val masterUsername: String? = builder.masterUsername
    /**
     * Specifies whether the cluster has instances in multiple Availability Zones.
     */
    val multiAz: Boolean = builder.multiAz
    /**
     * Specifies the progress of the operation as a percentage.
     */
    val percentProgress: String? = builder.percentProgress
    /**
     * Specifies the port that the database engine is listening on.
     */
    val port: Int? = builder.port
    /**
     * Specifies the daily time range during which automated backups are created if automated
     * backups are enabled, as determined by the BackupRetentionPeriod.
     */
    val preferredBackupWindow: String? = builder.preferredBackupWindow
    /**
     * Specifies the weekly time range during which system maintenance can occur, in
     * Universal Coordinated Time (UTC).
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
     */
    val readReplicaIdentifiers: List<String>? = builder.readReplicaIdentifiers
    /**
     * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster.
     * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
     */
    val readerEndpoint: String? = builder.readerEndpoint
    /**
     * Contains the identifier of the source cluster if this cluster is a secondary cluster.
     */
    val replicationSourceIdentifier: String? = builder.replicationSourceIdentifier
    /**
     * Specifies the current state of this cluster.
     */
    val status: String? = builder.status
    /**
     * Specifies whether the cluster is encrypted.
     */
    val storageEncrypted: Boolean = builder.storageEncrypted
    /**
     * Provides a list of virtual private cloud (VPC) security groups that the cluster
     * belongs to.
     */
    val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DbCluster = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DbCluster(")
        append("associatedRoles=$associatedRoles,")
        append("availabilityZones=$availabilityZones,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterArn=$dbClusterArn,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterMembers=$dbClusterMembers,")
        append("dbClusterParameterGroup=$dbClusterParameterGroup,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("deletionProtection=$deletionProtection,")
        append("earliestRestorableTime=$earliestRestorableTime,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("hostedZoneId=$hostedZoneId,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("masterUsername=$masterUsername,")
        append("multiAz=$multiAz,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("readReplicaIdentifiers=$readReplicaIdentifiers,")
        append("readerEndpoint=$readerEndpoint,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("vpcSecurityGroups=$vpcSecurityGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedRoles?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection.hashCode())
        result = 31 * result + (earliestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (multiAz.hashCode())
        result = 31 * result + (percentProgress?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (readReplicaIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DbCluster

        if (associatedRoles != other.associatedRoles) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterArn != other.dbClusterArn) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterMembers != other.dbClusterMembers) return false
        if (dbClusterParameterGroup != other.dbClusterParameterGroup) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (deletionProtection != other.deletionProtection) return false
        if (earliestRestorableTime != other.earliestRestorableTime) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (masterUsername != other.masterUsername) return false
        if (multiAz != other.multiAz) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (readReplicaIdentifiers != other.readReplicaIdentifiers) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DbCluster = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DbCluster
        /**
         * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.
         */
        fun associatedRoles(associatedRoles: List<DbClusterRole>): FluentBuilder
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
         * can be created in.
         */
        fun availabilityZones(availabilityZones: List<String>): FluentBuilder
        /**
         * Specifies the number of days for which automatic snapshots are retained.
         */
        fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder
        /**
         * Specifies the time when the cluster was created, in Universal Coordinated Time
         * (UTC).
         */
        fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the cluster.
         */
        fun dbClusterArn(dbClusterArn: String): FluentBuilder
        /**
         * Contains a user-supplied cluster identifier. This identifier is the unique key that
         * identifies a cluster.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * Provides the list of instances that make up the cluster.
         */
        fun dbClusterMembers(dbClusterMembers: List<DbClusterMember>): FluentBuilder
        /**
         * Specifies the name of the cluster parameter group for the cluster.
         */
        fun dbClusterParameterGroup(dbClusterParameterGroup: String): FluentBuilder
        /**
         * The Region-unique, immutable identifier for the cluster. This identifier is
         * found in CloudTrail log entries whenever the KMS key for the cluster is accessed.
         */
        fun dbClusterResourceId(dbClusterResourceId: String): FluentBuilder
        /**
         * Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.
         */
        fun dbSubnetGroup(dbSubnetGroup: String): FluentBuilder
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * DeletionProtection is disabled. DeletionProtection
         * protects clusters from being accidentally deleted.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The earliest time to which a database can be restored with point-in-time
         * restore.
         */
        fun earliestRestorableTime(earliestRestorableTime: Instant): FluentBuilder
        /**
         * A list of log types that this cluster is configured to export to Amazon CloudWatch
         * Logs.
         */
        fun enabledCloudwatchLogsExports(enabledCloudwatchLogsExports: List<String>): FluentBuilder
        /**
         * Specifies the connection endpoint for the primary instance of the cluster.
         */
        fun endpoint(endpoint: String): FluentBuilder
        /**
         * Provides the name of the database engine to be used for this cluster.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * Indicates the database engine version.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        fun hostedZoneId(hostedZoneId: String): FluentBuilder
        /**
         * If StorageEncrypted is true, the KMS key identifier for
         * the encrypted cluster.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * Specifies the latest time to which a database can be restored with point-in-time
         * restore.
         */
        fun latestRestorableTime(latestRestorableTime: Instant): FluentBuilder
        /**
         * Contains the master user name for the cluster.
         */
        fun masterUsername(masterUsername: String): FluentBuilder
        /**
         * Specifies whether the cluster has instances in multiple Availability Zones.
         */
        fun multiAz(multiAz: Boolean): FluentBuilder
        /**
         * Specifies the progress of the operation as a percentage.
         */
        fun percentProgress(percentProgress: String): FluentBuilder
        /**
         * Specifies the port that the database engine is listening on.
         */
        fun port(port: Int): FluentBuilder
        /**
         * Specifies the daily time range during which automated backups are created if automated
         * backups are enabled, as determined by the BackupRetentionPeriod.
         */
        fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder
        /**
         * Specifies the weekly time range during which system maintenance can occur, in
         * Universal Coordinated Time (UTC).
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         */
        fun readReplicaIdentifiers(readReplicaIdentifiers: List<String>): FluentBuilder
        /**
         * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster.
         * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
         */
        fun readerEndpoint(readerEndpoint: String): FluentBuilder
        /**
         * Contains the identifier of the source cluster if this cluster is a secondary cluster.
         */
        fun replicationSourceIdentifier(replicationSourceIdentifier: String): FluentBuilder
        /**
         * Specifies the current state of this cluster.
         */
        fun status(status: String): FluentBuilder
        /**
         * Specifies whether the cluster is encrypted.
         */
        fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder
        /**
         * Provides a list of virtual private cloud (VPC) security groups that the cluster
         * belongs to.
         */
        fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Provides a list of the Identity and Access Management (IAM) roles that are associated with the cluster. (IAM) roles that are associated with a cluster grant permission for the cluster to access other Amazon Web Services services on your behalf.
         */
        var associatedRoles: List<DbClusterRole>?
        /**
         * Provides the list of Amazon EC2 Availability Zones that instances in the cluster
         * can be created in.
         */
        var availabilityZones: List<String>?
        /**
         * Specifies the number of days for which automatic snapshots are retained.
         */
        var backupRetentionPeriod: Int?
        /**
         * Specifies the time when the cluster was created, in Universal Coordinated Time
         * (UTC).
         */
        var clusterCreateTime: Instant?
        /**
         * The Amazon Resource Name (ARN) for the cluster.
         */
        var dbClusterArn: String?
        /**
         * Contains a user-supplied cluster identifier. This identifier is the unique key that
         * identifies a cluster.
         */
        var dbClusterIdentifier: String?
        /**
         * Provides the list of instances that make up the cluster.
         */
        var dbClusterMembers: List<DbClusterMember>?
        /**
         * Specifies the name of the cluster parameter group for the cluster.
         */
        var dbClusterParameterGroup: String?
        /**
         * The Region-unique, immutable identifier for the cluster. This identifier is
         * found in CloudTrail log entries whenever the KMS key for the cluster is accessed.
         */
        var dbClusterResourceId: String?
        /**
         * Specifies information on the subnet group that is associated with the cluster, including the name, description, and subnets in the subnet group.
         */
        var dbSubnetGroup: String?
        /**
         * Specifies whether this cluster can be deleted. If DeletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * DeletionProtection is disabled. DeletionProtection
         * protects clusters from being accidentally deleted.
         */
        var deletionProtection: Boolean
        /**
         * The earliest time to which a database can be restored with point-in-time
         * restore.
         */
        var earliestRestorableTime: Instant?
        /**
         * A list of log types that this cluster is configured to export to Amazon CloudWatch
         * Logs.
         */
        var enabledCloudwatchLogsExports: List<String>?
        /**
         * Specifies the connection endpoint for the primary instance of the cluster.
         */
        var endpoint: String?
        /**
         * Provides the name of the database engine to be used for this cluster.
         */
        var engine: String?
        /**
         * Indicates the database engine version.
         */
        var engineVersion: String?
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        var hostedZoneId: String?
        /**
         * If StorageEncrypted is true, the KMS key identifier for
         * the encrypted cluster.
         */
        var kmsKeyId: String?
        /**
         * Specifies the latest time to which a database can be restored with point-in-time
         * restore.
         */
        var latestRestorableTime: Instant?
        /**
         * Contains the master user name for the cluster.
         */
        var masterUsername: String?
        /**
         * Specifies whether the cluster has instances in multiple Availability Zones.
         */
        var multiAz: Boolean
        /**
         * Specifies the progress of the operation as a percentage.
         */
        var percentProgress: String?
        /**
         * Specifies the port that the database engine is listening on.
         */
        var port: Int?
        /**
         * Specifies the daily time range during which automated backups are created if automated
         * backups are enabled, as determined by the BackupRetentionPeriod.
         */
        var preferredBackupWindow: String?
        /**
         * Specifies the weekly time range during which system maintenance can occur, in
         * Universal Coordinated Time (UTC).
         */
        var preferredMaintenanceWindow: String?
        /**
         * Contains one or more identifiers of the secondary clusters that are associated with this cluster.
         */
        var readReplicaIdentifiers: List<String>?
        /**
         * The reader endpoint for the cluster. The reader endpoint for a cluster load balances connections across the Amazon DocumentDB replicas that are available in a cluster. As clients request new connections to the reader endpoint, Amazon DocumentDB distributes the connection requests among the Amazon DocumentDB replicas in the cluster. This functionality can help balance your read workload across multiple Amazon DocumentDB replicas in your cluster.
         * If a failover occurs, and the Amazon DocumentDB replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Amazon DocumentDB replicas in the cluster, you can then reconnect to the reader endpoint.
         */
        var readerEndpoint: String?
        /**
         * Contains the identifier of the source cluster if this cluster is a secondary cluster.
         */
        var replicationSourceIdentifier: String?
        /**
         * Specifies the current state of this cluster.
         */
        var status: String?
        /**
         * Specifies whether the cluster is encrypted.
         */
        var storageEncrypted: Boolean
        /**
         * Provides a list of virtual private cloud (VPC) security groups that the cluster
         * belongs to.
         */
        var vpcSecurityGroups: List<VpcSecurityGroupMembership>?

        fun build(): DbCluster
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedRoles: List<DbClusterRole>? = null
        override var availabilityZones: List<String>? = null
        override var backupRetentionPeriod: Int? = null
        override var clusterCreateTime: Instant? = null
        override var dbClusterArn: String? = null
        override var dbClusterIdentifier: String? = null
        override var dbClusterMembers: List<DbClusterMember>? = null
        override var dbClusterParameterGroup: String? = null
        override var dbClusterResourceId: String? = null
        override var dbSubnetGroup: String? = null
        override var deletionProtection: Boolean = false
        override var earliestRestorableTime: Instant? = null
        override var enabledCloudwatchLogsExports: List<String>? = null
        override var endpoint: String? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var hostedZoneId: String? = null
        override var kmsKeyId: String? = null
        override var latestRestorableTime: Instant? = null
        override var masterUsername: String? = null
        override var multiAz: Boolean = false
        override var percentProgress: String? = null
        override var port: Int? = null
        override var preferredBackupWindow: String? = null
        override var preferredMaintenanceWindow: String? = null
        override var readReplicaIdentifiers: List<String>? = null
        override var readerEndpoint: String? = null
        override var replicationSourceIdentifier: String? = null
        override var status: String? = null
        override var storageEncrypted: Boolean = false
        override var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        constructor(x: DbCluster) : this() {
            this.associatedRoles = x.associatedRoles
            this.availabilityZones = x.availabilityZones
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterArn = x.dbClusterArn
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterMembers = x.dbClusterMembers
            this.dbClusterParameterGroup = x.dbClusterParameterGroup
            this.dbClusterResourceId = x.dbClusterResourceId
            this.dbSubnetGroup = x.dbSubnetGroup
            this.deletionProtection = x.deletionProtection
            this.earliestRestorableTime = x.earliestRestorableTime
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.hostedZoneId = x.hostedZoneId
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.masterUsername = x.masterUsername
            this.multiAz = x.multiAz
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.readReplicaIdentifiers = x.readReplicaIdentifiers
            this.readerEndpoint = x.readerEndpoint
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        override fun build(): DbCluster = DbCluster(this)
        override fun associatedRoles(associatedRoles: List<DbClusterRole>): FluentBuilder = apply { this.associatedRoles = associatedRoles }
        override fun availabilityZones(availabilityZones: List<String>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder = apply { this.backupRetentionPeriod = backupRetentionPeriod }
        override fun clusterCreateTime(clusterCreateTime: Instant): FluentBuilder = apply { this.clusterCreateTime = clusterCreateTime }
        override fun dbClusterArn(dbClusterArn: String): FluentBuilder = apply { this.dbClusterArn = dbClusterArn }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbClusterMembers(dbClusterMembers: List<DbClusterMember>): FluentBuilder = apply { this.dbClusterMembers = dbClusterMembers }
        override fun dbClusterParameterGroup(dbClusterParameterGroup: String): FluentBuilder = apply { this.dbClusterParameterGroup = dbClusterParameterGroup }
        override fun dbClusterResourceId(dbClusterResourceId: String): FluentBuilder = apply { this.dbClusterResourceId = dbClusterResourceId }
        override fun dbSubnetGroup(dbSubnetGroup: String): FluentBuilder = apply { this.dbSubnetGroup = dbSubnetGroup }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun earliestRestorableTime(earliestRestorableTime: Instant): FluentBuilder = apply { this.earliestRestorableTime = earliestRestorableTime }
        override fun enabledCloudwatchLogsExports(enabledCloudwatchLogsExports: List<String>): FluentBuilder = apply { this.enabledCloudwatchLogsExports = enabledCloudwatchLogsExports }
        override fun endpoint(endpoint: String): FluentBuilder = apply { this.endpoint = endpoint }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun hostedZoneId(hostedZoneId: String): FluentBuilder = apply { this.hostedZoneId = hostedZoneId }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun latestRestorableTime(latestRestorableTime: Instant): FluentBuilder = apply { this.latestRestorableTime = latestRestorableTime }
        override fun masterUsername(masterUsername: String): FluentBuilder = apply { this.masterUsername = masterUsername }
        override fun multiAz(multiAz: Boolean): FluentBuilder = apply { this.multiAz = multiAz }
        override fun percentProgress(percentProgress: String): FluentBuilder = apply { this.percentProgress = percentProgress }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder = apply { this.preferredBackupWindow = preferredBackupWindow }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun readReplicaIdentifiers(readReplicaIdentifiers: List<String>): FluentBuilder = apply { this.readReplicaIdentifiers = readReplicaIdentifiers }
        override fun readerEndpoint(readerEndpoint: String): FluentBuilder = apply { this.readerEndpoint = readerEndpoint }
        override fun replicationSourceIdentifier(replicationSourceIdentifier: String): FluentBuilder = apply { this.replicationSourceIdentifier = replicationSourceIdentifier }
        override fun status(status: String): FluentBuilder = apply { this.status = status }
        override fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder = apply { this.storageEncrypted = storageEncrypted }
        override fun vpcSecurityGroups(vpcSecurityGroups: List<VpcSecurityGroupMembership>): FluentBuilder = apply { this.vpcSecurityGroups = vpcSecurityGroups }
    }
}
