// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CreateGlobalCluster.
 */
class CreateGlobalClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.
     */
    val databaseName: String? = builder.databaseName
    /**
     * The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * The name of the database engine to be used for this cluster.
     */
    val engine: String? = builder.engine
    /**
     * The engine version of the global cluster.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * The cluster identifier of the new global cluster.
     */
    val globalClusterIdentifier: String? = builder.globalClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.
     */
    val sourceDbClusterIdentifier: String? = builder.sourceDbClusterIdentifier
    /**
     * The storage encryption setting for the new global cluster.
     */
    val storageEncrypted: Boolean? = builder.storageEncrypted

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateGlobalClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGlobalClusterRequest(")
        append("databaseName=$databaseName,")
        append("deletionProtection=$deletionProtection,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("storageEncrypted=$storageEncrypted)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateGlobalClusterRequest

        if (databaseName != other.databaseName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (storageEncrypted != other.storageEncrypted) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateGlobalClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateGlobalClusterRequest
        /**
         * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.
         */
        fun databaseName(databaseName: String): FluentBuilder
        /**
         * The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The name of the database engine to be used for this cluster.
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The engine version of the global cluster.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * The cluster identifier of the new global cluster.
         */
        fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.
         */
        fun sourceDbClusterIdentifier(sourceDbClusterIdentifier: String): FluentBuilder
        /**
         * The storage encryption setting for the new global cluster.
         */
        fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon DocumentDB will not create a database in the global cluster you are creating.
         */
        var databaseName: String?
        /**
         * The deletion protection setting for the new global cluster. The global cluster can't be deleted when deletion protection is enabled.
         */
        var deletionProtection: Boolean?
        /**
         * The name of the database engine to be used for this cluster.
         */
        var engine: String?
        /**
         * The engine version of the global cluster.
         */
        var engineVersion: String?
        /**
         * The cluster identifier of the new global cluster.
         */
        var globalClusterIdentifier: String?
        /**
         * The Amazon Resource Name (ARN) to use as the primary cluster of the global cluster. This parameter is optional.
         */
        var sourceDbClusterIdentifier: String?
        /**
         * The storage encryption setting for the new global cluster.
         */
        var storageEncrypted: Boolean?

        fun build(): CreateGlobalClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var databaseName: String? = null
        override var deletionProtection: Boolean? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var globalClusterIdentifier: String? = null
        override var sourceDbClusterIdentifier: String? = null
        override var storageEncrypted: Boolean? = null

        constructor(x: CreateGlobalClusterRequest) : this() {
            this.databaseName = x.databaseName
            this.deletionProtection = x.deletionProtection
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.storageEncrypted = x.storageEncrypted
        }

        override fun build(): CreateGlobalClusterRequest = CreateGlobalClusterRequest(this)
        override fun databaseName(databaseName: String): FluentBuilder = apply { this.databaseName = databaseName }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder = apply { this.globalClusterIdentifier = globalClusterIdentifier }
        override fun sourceDbClusterIdentifier(sourceDbClusterIdentifier: String): FluentBuilder = apply { this.sourceDbClusterIdentifier = sourceDbClusterIdentifier }
        override fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder = apply { this.storageEncrypted = storageEncrypted }
    }
}
