// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CreateEventSubscription.
 */
class CreateEventSubscriptionRequest private constructor(builder: BuilderImpl) {
    /**
     * A Boolean value; set to true to activate the subscription, set to false to create the subscription but not active it.
     */
    val enabled: Boolean? = builder.enabled
    /**
     * A list of event categories for a SourceType that you want to subscribe to.
     */
    val eventCategories: List<String>? = builder.eventCategories
    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.
     */
    val snsTopicArn: String? = builder.snsTopicArn
    /**
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
     * hyphen or contain two consecutive hyphens.
     * Constraints:
     * If SourceIds are provided, SourceType must also be
     * provided.
     * If the source type is an instance, a DBInstanceIdentifier must
     * be provided.
     * If the source type is a security group, a DBSecurityGroupName
     * must be provided.
     * If the source type is a parameter group, a
     * DBParameterGroupName must be provided.
     * If the source type is a snapshot, a DBSnapshotIdentifier must
     * be provided.
     */
    val sourceIds: List<String>? = builder.sourceIds
    /**
     * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to db-instance. If this value is not specified, all events are returned.
     * Valid values: db-instance, db-cluster,
     * db-parameter-group, db-security-group,
     * db-cluster-snapshot
     */
    val sourceType: String? = builder.sourceType
    /**
     * The name of the subscription.
     * Constraints: The name must be fewer than 255 characters.
     */
    val subscriptionName: String? = builder.subscriptionName
    /**
     * The tags to be assigned to the event subscription.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateEventSubscriptionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIds=$sourceIds,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIds?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIds != other.sourceIds) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateEventSubscriptionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateEventSubscriptionRequest
        /**
         * A Boolean value; set to true to activate the subscription, set to false to create the subscription but not active it.
         */
        fun enabled(enabled: Boolean): FluentBuilder
        /**
         * A list of event categories for a SourceType that you want to subscribe to.
         */
        fun eventCategories(eventCategories: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.
         */
        fun snsTopicArn(snsTopicArn: String): FluentBuilder
        /**
         * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
         * hyphen or contain two consecutive hyphens.
         * Constraints:
         * If SourceIds are provided, SourceType must also be
         * provided.
         * If the source type is an instance, a DBInstanceIdentifier must
         * be provided.
         * If the source type is a security group, a DBSecurityGroupName
         * must be provided.
         * If the source type is a parameter group, a
         * DBParameterGroupName must be provided.
         * If the source type is a snapshot, a DBSnapshotIdentifier must
         * be provided.
         */
        fun sourceIds(sourceIds: List<String>): FluentBuilder
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to db-instance. If this value is not specified, all events are returned.
         * Valid values: db-instance, db-cluster,
         * db-parameter-group, db-security-group,
         * db-cluster-snapshot
         */
        fun sourceType(sourceType: String): FluentBuilder
        /**
         * The name of the subscription.
         * Constraints: The name must be fewer than 255 characters.
         */
        fun subscriptionName(subscriptionName: String): FluentBuilder
        /**
         * The tags to be assigned to the event subscription.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean value; set to true to activate the subscription, set to false to create the subscription but not active it.
         */
        var enabled: Boolean?
        /**
         * A list of event categories for a SourceType that you want to subscribe to.
         */
        var eventCategories: List<String>?
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. Amazon SNS creates the ARN when you create a topic and subscribe to it.
         */
        var snsTopicArn: String?
        /**
         * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a
         * hyphen or contain two consecutive hyphens.
         * Constraints:
         * If SourceIds are provided, SourceType must also be
         * provided.
         * If the source type is an instance, a DBInstanceIdentifier must
         * be provided.
         * If the source type is a security group, a DBSecurityGroupName
         * must be provided.
         * If the source type is a parameter group, a
         * DBParameterGroupName must be provided.
         * If the source type is a snapshot, a DBSnapshotIdentifier must
         * be provided.
         */
        var sourceIds: List<String>?
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by an instance, you would set this parameter to db-instance. If this value is not specified, all events are returned.
         * Valid values: db-instance, db-cluster,
         * db-parameter-group, db-security-group,
         * db-cluster-snapshot
         */
        var sourceType: String?
        /**
         * The name of the subscription.
         * Constraints: The name must be fewer than 255 characters.
         */
        var subscriptionName: String?
        /**
         * The tags to be assigned to the event subscription.
         */
        var tags: List<Tag>?

        fun build(): CreateEventSubscriptionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enabled: Boolean? = null
        override var eventCategories: List<String>? = null
        override var snsTopicArn: String? = null
        override var sourceIds: List<String>? = null
        override var sourceType: String? = null
        override var subscriptionName: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.snsTopicArn = x.snsTopicArn
            this.sourceIds = x.sourceIds
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
            this.tags = x.tags
        }

        override fun build(): CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(this)
        override fun enabled(enabled: Boolean): FluentBuilder = apply { this.enabled = enabled }
        override fun eventCategories(eventCategories: List<String>): FluentBuilder = apply { this.eventCategories = eventCategories }
        override fun snsTopicArn(snsTopicArn: String): FluentBuilder = apply { this.snsTopicArn = snsTopicArn }
        override fun sourceIds(sourceIds: List<String>): FluentBuilder = apply { this.sourceIds = sourceIds }
        override fun sourceType(sourceType: String): FluentBuilder = apply { this.sourceType = sourceType }
        override fun subscriptionName(subscriptionName: String): FluentBuilder = apply { this.subscriptionName = subscriptionName }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
