// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CreateDBInstance.
 */
class CreateDbInstanceRequest private constructor(builder: BuilderImpl) {
    /**
     * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
     * Default: false
     */
    val autoMinorVersionUpgrade: Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Amazon EC2 Availability Zone that the instance is created in.
     * Default: A random, system-chosen Availability Zone in the endpoint's Region.
     * Example: us-east-1d
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The identifier of the cluster that the instance will belong to.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of the instance; for example,
     * db.r5.large.
     */
    val dbInstanceClass: String? = builder.dbInstanceClass
    /**
     * The instance identifier. This parameter is stored as a lowercase string.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: mydbinstance
     */
    val dbInstanceIdentifier: String? = builder.dbInstanceIdentifier
    /**
     * The name of the database engine to be used for this instance.
     * Valid value: docdb
     */
    val engine: String? = builder.engine
    /**
     * The time range each week during which system maintenance can occur, in Universal
     * Coordinated Time (UTC).
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * The default is a 30-minute window selected at random from an 8-hour block of time for
     * each Region, occurring on a random day of the week.
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
     * primary instance after a failure of the existing primary instance.
     * Default: 1
     * Valid values: 0-15
     */
    val promotionTier: Int? = builder.promotionTier
    /**
     * The tags to be assigned to the instance. You can assign up to
     * 10 tags to an instance.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDbInstanceRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbInstanceRequest(")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("engine=$engine,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("promotionTier=$promotionTier,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoMinorVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDbInstanceRequest

        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (engine != other.engine) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (promotionTier != other.promotionTier) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDbInstanceRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDbInstanceRequest
        /**
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         * Default: false
         */
        fun autoMinorVersionUpgrade(autoMinorVersionUpgrade: Boolean): FluentBuilder
        /**
         * The Amazon EC2 Availability Zone that the instance is created in.
         * Default: A random, system-chosen Availability Zone in the endpoint's Region.
         * Example: us-east-1d
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The identifier of the cluster that the instance will belong to.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The compute and memory capacity of the instance; for example,
         * db.r5.large.
         */
        fun dbInstanceClass(dbInstanceClass: String): FluentBuilder
        /**
         * The instance identifier. This parameter is stored as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: mydbinstance
         */
        fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder
        /**
         * The name of the database engine to be used for this instance.
         * Valid value: docdb
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The time range each week during which system maintenance can occur, in Universal
         * Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
         * primary instance after a failure of the existing primary instance.
         * Default: 1
         * Valid values: 0-15
         */
        fun promotionTier(promotionTier: Int): FluentBuilder
        /**
         * The tags to be assigned to the instance. You can assign up to
         * 10 tags to an instance.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * This parameter does not apply to Amazon DocumentDB. Amazon DocumentDB does not perform minor version upgrades regardless of the value set.
         * Default: false
         */
        var autoMinorVersionUpgrade: Boolean?
        /**
         * The Amazon EC2 Availability Zone that the instance is created in.
         * Default: A random, system-chosen Availability Zone in the endpoint's Region.
         * Example: us-east-1d
         */
        var availabilityZone: String?
        /**
         * The identifier of the cluster that the instance will belong to.
         */
        var dbClusterIdentifier: String?
        /**
         * The compute and memory capacity of the instance; for example,
         * db.r5.large.
         */
        var dbInstanceClass: String?
        /**
         * The instance identifier. This parameter is stored as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: mydbinstance
         */
        var dbInstanceIdentifier: String?
        /**
         * The name of the database engine to be used for this instance.
         * Valid value: docdb
         */
        var engine: String?
        /**
         * The time range each week during which system maintenance can occur, in Universal
         * Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * The default is a 30-minute window selected at random from an 8-hour block of time for
         * each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: String?
        /**
         * A value that specifies the order in which an Amazon DocumentDB replica is promoted to the
         * primary instance after a failure of the existing primary instance.
         * Default: 1
         * Valid values: 0-15
         */
        var promotionTier: Int?
        /**
         * The tags to be assigned to the instance. You can assign up to
         * 10 tags to an instance.
         */
        var tags: List<Tag>?

        fun build(): CreateDbInstanceRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var autoMinorVersionUpgrade: Boolean? = null
        override var availabilityZone: String? = null
        override var dbClusterIdentifier: String? = null
        override var dbInstanceClass: String? = null
        override var dbInstanceIdentifier: String? = null
        override var engine: String? = null
        override var preferredMaintenanceWindow: String? = null
        override var promotionTier: Int? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateDbInstanceRequest) : this() {
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.engine = x.engine
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.promotionTier = x.promotionTier
            this.tags = x.tags
        }

        override fun build(): CreateDbInstanceRequest = CreateDbInstanceRequest(this)
        override fun autoMinorVersionUpgrade(autoMinorVersionUpgrade: Boolean): FluentBuilder = apply { this.autoMinorVersionUpgrade = autoMinorVersionUpgrade }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbInstanceClass(dbInstanceClass: String): FluentBuilder = apply { this.dbInstanceClass = dbInstanceClass }
        override fun dbInstanceIdentifier(dbInstanceIdentifier: String): FluentBuilder = apply { this.dbInstanceIdentifier = dbInstanceIdentifier }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun promotionTier(promotionTier: Int): FluentBuilder = apply { this.promotionTier = promotionTier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
