// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input of CreateDBClusterSnapshot.
 */
class CreateDbClusterSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier of the cluster to create a snapshot for. This
     * parameter is not case sensitive.
     * Constraints:
     * Must match the identifier of an existing
     * DBCluster.
     * Example: my-cluster
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The identifier of the cluster snapshot. This parameter is stored
     * as a lowercase string.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: my-cluster-snapshot1
     */
    val dbClusterSnapshotIdentifier: String? = builder.dbClusterSnapshotIdentifier
    /**
     * The tags to be assigned to the cluster snapshot.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDbClusterSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterSnapshotRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDbClusterSnapshotRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDbClusterSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDbClusterSnapshotRequest
        /**
         * The identifier of the cluster to create a snapshot for. This
         * parameter is not case sensitive.
         * Constraints:
         * Must match the identifier of an existing
         * DBCluster.
         * Example: my-cluster
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The identifier of the cluster snapshot. This parameter is stored
         * as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster-snapshot1
         */
        fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder
        /**
         * The tags to be assigned to the cluster snapshot.
         */
        fun tags(tags: List<Tag>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier of the cluster to create a snapshot for. This
         * parameter is not case sensitive.
         * Constraints:
         * Must match the identifier of an existing
         * DBCluster.
         * Example: my-cluster
         */
        var dbClusterIdentifier: String?
        /**
         * The identifier of the cluster snapshot. This parameter is stored
         * as a lowercase string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster-snapshot1
         */
        var dbClusterSnapshotIdentifier: String?
        /**
         * The tags to be assigned to the cluster snapshot.
         */
        var tags: List<Tag>?

        fun build(): CreateDbClusterSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dbClusterIdentifier: String? = null
        override var dbClusterSnapshotIdentifier: String? = null
        override var tags: List<Tag>? = null

        constructor(x: CreateDbClusterSnapshotRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.tags = x.tags
        }

        override fun build(): CreateDbClusterSnapshotRequest = CreateDbClusterSnapshotRequest(this)
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: String): FluentBuilder = apply { this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
    }
}
