// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CreateDBCluster.
 */
class CreateDbClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * A list of Amazon EC2 Availability Zones that instances in the
     * cluster can be created in.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The number of days for which automated backups are retained. You
     * must specify a minimum value of 1.
     * Default: 1
     * Constraints:
     * Must be a value from 1 to 35.
     */
    val backupRetentionPeriod: Int? = builder.backupRetentionPeriod
    /**
     * The cluster identifier. This parameter is stored as a lowercase
     * string.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: my-cluster
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * The name of the cluster parameter group to associate with this
     * cluster.
     */
    val dbClusterParameterGroupName: String? = builder.dbClusterParameterGroupName
    /**
     * A subnet group to associate with this cluster.
     * Constraints: Must match the name of an existing
     * DBSubnetGroup. Must not be default.
     * Example: mySubnetgroup
     */
    val dbSubnetGroupName: String? = builder.dbSubnetGroupName
    /**
     * Specifies whether this cluster can be deleted. If
     * DeletionProtection is enabled, the cluster cannot be
     * deleted unless it is modified and DeletionProtection is
     * disabled. DeletionProtection protects clusters from
     * being accidentally deleted.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * A list of log types that need to be enabled for exporting to Amazon
     * CloudWatch Logs. You can enable audit logs or profiler logs. For more
     * information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
     * Auditing Amazon DocumentDB Events
     * and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
     * Profiling Amazon DocumentDB Operations.
     */
    val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * The name of the database engine to be used for this cluster.
     * Valid values: docdb
     */
    val engine: String? = builder.engine
    /**
     * The version number of the database engine to use. The --engine-version will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.
     */
    val engineVersion: String? = builder.engineVersion
    /**
     * The cluster identifier of the new global cluster.
     */
    val globalClusterIdentifier: String? = builder.globalClusterIdentifier
    /**
     * The KMS key identifier for an encrypted cluster.
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.
     * If an encryption key is not specified in KmsKeyId:
     * If the StorageEncrypted parameter is
     * true, Amazon DocumentDB uses your default encryption key.
     * KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The password for the master database user. This password can
     * contain any printable ASCII character except forward slash (/),
     * double quote ("), or the "at" symbol (@).
     * Constraints: Must contain from 8 to 100 characters.
     */
    val masterUserPassword: String? = builder.masterUserPassword
    /**
     * The name of the master user for the cluster.
     * Constraints:
     * Must be from 1 to 63 letters or numbers.
     * The first character must be a letter.
     * Cannot be a reserved word for the chosen database engine.
     */
    val masterUsername: String? = builder.masterUsername
    /**
     * The port number on which the instances in the cluster accept
     * connections.
     */
    val port: Int? = builder.port
    /**
     * Not currently supported.
     */
    val preSignedUrl: String? = builder.preSignedUrl
    /**
     * The daily time range during which automated backups are created if
     * automated backups are enabled using the BackupRetentionPeriod parameter.
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Region.
     * Constraints:
     * Must be in the format hh24:mi-hh24:mi.
     * Must be in Universal Coordinated Time (UTC).
     * Must not conflict with the preferred maintenance window.
     * Must be at least 30 minutes.
     */
    val preferredBackupWindow: String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur,
     * in Universal Coordinated Time (UTC).
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
     * Constraints: Minimum 30-minute window.
     */
    val preferredMaintenanceWindow: String? = builder.preferredMaintenanceWindow
    /**
     * Specifies whether the cluster is encrypted.
     */
    val storageEncrypted: Boolean? = builder.storageEncrypted
    /**
     * The tags to be assigned to the cluster.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with this cluster.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateDbClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterRequest(")
        append("availabilityZones=$availabilityZones,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("port=$port,")
        append("preSignedUrl=$preSignedUrl,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("storageEncrypted=$storageEncrypted,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateDbClusterRequest

        if (availabilityZones != other.availabilityZones) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (port != other.port) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateDbClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateDbClusterRequest
        /**
         * A list of Amazon EC2 Availability Zones that instances in the
         * cluster can be created in.
         */
        fun availabilityZones(availabilityZones: List<String>): FluentBuilder
        /**
         * The number of days for which automated backups are retained. You
         * must specify a minimum value of 1.
         * Default: 1
         * Constraints:
         * Must be a value from 1 to 35.
         */
        fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder
        /**
         * The cluster identifier. This parameter is stored as a lowercase
         * string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * The name of the cluster parameter group to associate with this
         * cluster.
         */
        fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder
        /**
         * A subnet group to associate with this cluster.
         * Constraints: Must match the name of an existing
         * DBSubnetGroup. Must not be default.
         * Example: mySubnetgroup
         */
        fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder
        /**
         * Specifies whether this cluster can be deleted. If
         * DeletionProtection is enabled, the cluster cannot be
         * deleted unless it is modified and DeletionProtection is
         * disabled. DeletionProtection protects clusters from
         * being accidentally deleted.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * A list of log types that need to be enabled for exporting to Amazon
         * CloudWatch Logs. You can enable audit logs or profiler logs. For more
         * information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
         * Auditing Amazon DocumentDB Events
         * and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
         * Profiling Amazon DocumentDB Operations.
         */
        fun enableCloudwatchLogsExports(enableCloudwatchLogsExports: List<String>): FluentBuilder
        /**
         * The name of the database engine to be used for this cluster.
         * Valid values: docdb
         */
        fun engine(engine: String): FluentBuilder
        /**
         * The version number of the database engine to use. The --engine-version will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.
         */
        fun engineVersion(engineVersion: String): FluentBuilder
        /**
         * The cluster identifier of the new global cluster.
         */
        fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder
        /**
         * The KMS key identifier for an encrypted cluster.
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * If an encryption key is not specified in KmsKeyId:
         * If the StorageEncrypted parameter is
         * true, Amazon DocumentDB uses your default encryption key.
         * KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The password for the master database user. This password can
         * contain any printable ASCII character except forward slash (/),
         * double quote ("), or the "at" symbol (@).
         * Constraints: Must contain from 8 to 100 characters.
         */
        fun masterUserPassword(masterUserPassword: String): FluentBuilder
        /**
         * The name of the master user for the cluster.
         * Constraints:
         * Must be from 1 to 63 letters or numbers.
         * The first character must be a letter.
         * Cannot be a reserved word for the chosen database engine.
         */
        fun masterUsername(masterUsername: String): FluentBuilder
        /**
         * The port number on which the instances in the cluster accept
         * connections.
         */
        fun port(port: Int): FluentBuilder
        /**
         * Not currently supported.
         */
        fun preSignedUrl(preSignedUrl: String): FluentBuilder
        /**
         * The daily time range during which automated backups are created if
         * automated backups are enabled using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Region.
         * Constraints:
         * Must be in the format hh24:mi-hh24:mi.
         * Must be in Universal Coordinated Time (UTC).
         * Must not conflict with the preferred maintenance window.
         * Must be at least 30 minutes.
         */
        fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder
        /**
         * The weekly time range during which system maintenance can occur,
         * in Universal Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder
        /**
         * Specifies whether the cluster is encrypted.
         */
        fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder
        /**
         * The tags to be assigned to the cluster.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A list of EC2 VPC security groups to associate with this cluster.
         */
        fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of Amazon EC2 Availability Zones that instances in the
         * cluster can be created in.
         */
        var availabilityZones: List<String>?
        /**
         * The number of days for which automated backups are retained. You
         * must specify a minimum value of 1.
         * Default: 1
         * Constraints:
         * Must be a value from 1 to 35.
         */
        var backupRetentionPeriod: Int?
        /**
         * The cluster identifier. This parameter is stored as a lowercase
         * string.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster
         */
        var dbClusterIdentifier: String?
        /**
         * The name of the cluster parameter group to associate with this
         * cluster.
         */
        var dbClusterParameterGroupName: String?
        /**
         * A subnet group to associate with this cluster.
         * Constraints: Must match the name of an existing
         * DBSubnetGroup. Must not be default.
         * Example: mySubnetgroup
         */
        var dbSubnetGroupName: String?
        /**
         * Specifies whether this cluster can be deleted. If
         * DeletionProtection is enabled, the cluster cannot be
         * deleted unless it is modified and DeletionProtection is
         * disabled. DeletionProtection protects clusters from
         * being accidentally deleted.
         */
        var deletionProtection: Boolean?
        /**
         * A list of log types that need to be enabled for exporting to Amazon
         * CloudWatch Logs. You can enable audit logs or profiler logs. For more
         * information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html">
         * Auditing Amazon DocumentDB Events
         * and <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html">
         * Profiling Amazon DocumentDB Operations.
         */
        var enableCloudwatchLogsExports: List<String>?
        /**
         * The name of the database engine to be used for this cluster.
         * Valid values: docdb
         */
        var engine: String?
        /**
         * The version number of the database engine to use. The --engine-version will default to the latest major engine version. For production workloads, we recommend explicitly declaring this parameter with the intended major engine version.
         */
        var engineVersion: String?
        /**
         * The cluster identifier of the new global cluster.
         */
        var globalClusterIdentifier: String?
        /**
         * The KMS key identifier for an encrypted cluster.
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are creating a cluster using the same account that owns the KMS encryption key that is used to encrypt the new cluster, you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * If an encryption key is not specified in KmsKeyId:
         * If the StorageEncrypted parameter is
         * true, Amazon DocumentDB uses your default encryption key.
         * KMS creates the default encryption key for your account. Your account has a different default encryption key for each Regions.
         */
        var kmsKeyId: String?
        /**
         * The password for the master database user. This password can
         * contain any printable ASCII character except forward slash (/),
         * double quote ("), or the "at" symbol (@).
         * Constraints: Must contain from 8 to 100 characters.
         */
        var masterUserPassword: String?
        /**
         * The name of the master user for the cluster.
         * Constraints:
         * Must be from 1 to 63 letters or numbers.
         * The first character must be a letter.
         * Cannot be a reserved word for the chosen database engine.
         */
        var masterUsername: String?
        /**
         * The port number on which the instances in the cluster accept
         * connections.
         */
        var port: Int?
        /**
         * Not currently supported.
         */
        var preSignedUrl: String?
        /**
         * The daily time range during which automated backups are created if
         * automated backups are enabled using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Region.
         * Constraints:
         * Must be in the format hh24:mi-hh24:mi.
         * Must be in Universal Coordinated Time (UTC).
         * Must not conflict with the preferred maintenance window.
         * Must be at least 30 minutes.
         */
        var preferredBackupWindow: String?
        /**
         * The weekly time range during which system maintenance can occur,
         * in Universal Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Region, occurring on a random day of the week.
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
         * Constraints: Minimum 30-minute window.
         */
        var preferredMaintenanceWindow: String?
        /**
         * Specifies whether the cluster is encrypted.
         */
        var storageEncrypted: Boolean?
        /**
         * The tags to be assigned to the cluster.
         */
        var tags: List<Tag>?
        /**
         * A list of EC2 VPC security groups to associate with this cluster.
         */
        var vpcSecurityGroupIds: List<String>?

        fun build(): CreateDbClusterRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var availabilityZones: List<String>? = null
        override var backupRetentionPeriod: Int? = null
        override var dbClusterIdentifier: String? = null
        override var dbClusterParameterGroupName: String? = null
        override var dbSubnetGroupName: String? = null
        override var deletionProtection: Boolean? = null
        override var enableCloudwatchLogsExports: List<String>? = null
        override var engine: String? = null
        override var engineVersion: String? = null
        override var globalClusterIdentifier: String? = null
        override var kmsKeyId: String? = null
        override var masterUserPassword: String? = null
        override var masterUsername: String? = null
        override var port: Int? = null
        override var preSignedUrl: String? = null
        override var preferredBackupWindow: String? = null
        override var preferredMaintenanceWindow: String? = null
        override var storageEncrypted: Boolean? = null
        override var tags: List<Tag>? = null
        override var vpcSecurityGroupIds: List<String>? = null

        constructor(x: CreateDbClusterRequest) : this() {
            this.availabilityZones = x.availabilityZones
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.kmsKeyId = x.kmsKeyId
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.port = x.port
            this.preSignedUrl = x.preSignedUrl
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.storageEncrypted = x.storageEncrypted
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        override fun build(): CreateDbClusterRequest = CreateDbClusterRequest(this)
        override fun availabilityZones(availabilityZones: List<String>): FluentBuilder = apply { this.availabilityZones = availabilityZones }
        override fun backupRetentionPeriod(backupRetentionPeriod: Int): FluentBuilder = apply { this.backupRetentionPeriod = backupRetentionPeriod }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun dbClusterParameterGroupName(dbClusterParameterGroupName: String): FluentBuilder = apply { this.dbClusterParameterGroupName = dbClusterParameterGroupName }
        override fun dbSubnetGroupName(dbSubnetGroupName: String): FluentBuilder = apply { this.dbSubnetGroupName = dbSubnetGroupName }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun enableCloudwatchLogsExports(enableCloudwatchLogsExports: List<String>): FluentBuilder = apply { this.enableCloudwatchLogsExports = enableCloudwatchLogsExports }
        override fun engine(engine: String): FluentBuilder = apply { this.engine = engine }
        override fun engineVersion(engineVersion: String): FluentBuilder = apply { this.engineVersion = engineVersion }
        override fun globalClusterIdentifier(globalClusterIdentifier: String): FluentBuilder = apply { this.globalClusterIdentifier = globalClusterIdentifier }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun masterUserPassword(masterUserPassword: String): FluentBuilder = apply { this.masterUserPassword = masterUserPassword }
        override fun masterUsername(masterUsername: String): FluentBuilder = apply { this.masterUsername = masterUsername }
        override fun port(port: Int): FluentBuilder = apply { this.port = port }
        override fun preSignedUrl(preSignedUrl: String): FluentBuilder = apply { this.preSignedUrl = preSignedUrl }
        override fun preferredBackupWindow(preferredBackupWindow: String): FluentBuilder = apply { this.preferredBackupWindow = preferredBackupWindow }
        override fun preferredMaintenanceWindow(preferredMaintenanceWindow: String): FluentBuilder = apply { this.preferredMaintenanceWindow = preferredMaintenanceWindow }
        override fun storageEncrypted(storageEncrypted: Boolean): FluentBuilder = apply { this.storageEncrypted = storageEncrypted }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcSecurityGroupIds(vpcSecurityGroupIds: List<String>): FluentBuilder = apply { this.vpcSecurityGroupIds = vpcSecurityGroupIds }
    }
}
