// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CopyDBClusterSnapshot.
 */
class CopyDbClusterSnapshotRequest private constructor(builder: BuilderImpl) {
    /**
     * Set to true to copy all tags from the source cluster
     * snapshot to the target cluster snapshot, and otherwise
     * false. The default is false.
     */
    val copyTags: Boolean? = builder.copyTags
    /**
     * The KMS key ID for an encrypted cluster snapshot. The KMS
     * key ID is the Amazon Resource Name (ARN), KMS key identifier, or
     * the KMS key alias for the KMS encryption key.
     * If you copy an encrypted cluster snapshot from your account, you can specify a value for KmsKeyId to encrypt the copy with a new KMS encryption key. If you don't specify a value for KmsKeyId, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.
     * If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for KmsKeyId.
     * To copy an encrypted cluster snapshot to another Region, set KmsKeyId to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.
     * If you copy an unencrypted cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * The URL that contains a Signature Version 4 signed request for theCopyDBClusterSnapshot API action in the Region that contains the source cluster snapshot to copy. You must use the PreSignedUrl parameter when copying a cluster snapshot from another Region.
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify
     * SourceRegion (or --source-region for the
     * CLI) instead of specifying PreSignedUrl manually.
     * Specifying SourceRegion autogenerates a pre-signed URL
     * that is a valid request for the operation that can be executed in
     * the source Region.
     * The presigned URL must be a valid request for the
     * CopyDBClusterSnapshot API action that can be executed
     * in the source Region that contains the cluster snapshot to be
     * copied. The presigned URL request must contain the following
     * parameter values:
     * SourceRegion - The ID of the region that
     * contains the snapshot to be copied.
     * SourceDBClusterSnapshotIdentifier - The
     * identifier for the the encrypted cluster snapshot to be
     * copied. This identifier must be in the Amazon Resource Name
     * (ARN) format for the source Region. For example, if you
     * are copying an encrypted cluster snapshot from the us-east-1
     * Region, then your
     * SourceDBClusterSnapshotIdentifier looks
     * something like the following:
     * arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot.
     * TargetDBClusterSnapshotIdentifier - The
     * identifier for the new cluster snapshot to be created. This
     * parameter isn't case sensitive.
     */
    val preSignedUrl: String? = builder.preSignedUrl
    /**
     * The identifier of the cluster snapshot to copy. This parameter is
     * not case sensitive.
     * Constraints:
     * Must specify a valid system snapshot in the
     * available state.
     * If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.
     * If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.
     * Example: my-cluster-snapshot1
     */
    val sourceDbClusterSnapshotIdentifier: String? = builder.sourceDbClusterSnapshotIdentifier
    /**
     * The tags to be assigned to the cluster snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the new cluster snapshot to create from the
     * source cluster snapshot. This parameter is not case sensitive.
     * Constraints:
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: my-cluster-snapshot2
     */
    val targetDbClusterSnapshotIdentifier: String? = builder.targetDbClusterSnapshotIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CopyDbClusterSnapshotRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterSnapshotRequest(")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbClusterSnapshotIdentifier=$sourceDbClusterSnapshotIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterSnapshotIdentifier=$targetDbClusterSnapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CopyDbClusterSnapshotRequest

        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbClusterSnapshotIdentifier != other.sourceDbClusterSnapshotIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterSnapshotIdentifier != other.targetDbClusterSnapshotIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CopyDbClusterSnapshotRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CopyDbClusterSnapshotRequest
        /**
         * Set to true to copy all tags from the source cluster
         * snapshot to the target cluster snapshot, and otherwise
         * false. The default is false.
         */
        fun copyTags(copyTags: Boolean): FluentBuilder
        /**
         * The KMS key ID for an encrypted cluster snapshot. The KMS
         * key ID is the Amazon Resource Name (ARN), KMS key identifier, or
         * the KMS key alias for the KMS encryption key.
         * If you copy an encrypted cluster snapshot from your account, you can specify a value for KmsKeyId to encrypt the copy with a new KMS encryption key. If you don't specify a value for KmsKeyId, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.
         * If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for KmsKeyId.
         * To copy an encrypted cluster snapshot to another Region, set KmsKeyId to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.
         * If you copy an unencrypted cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * The URL that contains a Signature Version 4 signed request for theCopyDBClusterSnapshot API action in the Region that contains the source cluster snapshot to copy. You must use the PreSignedUrl parameter when copying a cluster snapshot from another Region.
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify
         * SourceRegion (or --source-region for the
         * CLI) instead of specifying PreSignedUrl manually.
         * Specifying SourceRegion autogenerates a pre-signed URL
         * that is a valid request for the operation that can be executed in
         * the source Region.
         * The presigned URL must be a valid request for the
         * CopyDBClusterSnapshot API action that can be executed
         * in the source Region that contains the cluster snapshot to be
         * copied. The presigned URL request must contain the following
         * parameter values:
         * SourceRegion - The ID of the region that
         * contains the snapshot to be copied.
         * SourceDBClusterSnapshotIdentifier - The
         * identifier for the the encrypted cluster snapshot to be
         * copied. This identifier must be in the Amazon Resource Name
         * (ARN) format for the source Region. For example, if you
         * are copying an encrypted cluster snapshot from the us-east-1
         * Region, then your
         * SourceDBClusterSnapshotIdentifier looks
         * something like the following:
         * arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot.
         * TargetDBClusterSnapshotIdentifier - The
         * identifier for the new cluster snapshot to be created. This
         * parameter isn't case sensitive.
         */
        fun preSignedUrl(preSignedUrl: String): FluentBuilder
        /**
         * The identifier of the cluster snapshot to copy. This parameter is
         * not case sensitive.
         * Constraints:
         * Must specify a valid system snapshot in the
         * available state.
         * If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.
         * If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.
         * Example: my-cluster-snapshot1
         */
        fun sourceDbClusterSnapshotIdentifier(sourceDbClusterSnapshotIdentifier: String): FluentBuilder
        /**
         * The tags to be assigned to the cluster snapshot.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The identifier of the new cluster snapshot to create from the
         * source cluster snapshot. This parameter is not case sensitive.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster-snapshot2
         */
        fun targetDbClusterSnapshotIdentifier(targetDbClusterSnapshotIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Set to true to copy all tags from the source cluster
         * snapshot to the target cluster snapshot, and otherwise
         * false. The default is false.
         */
        var copyTags: Boolean?
        /**
         * The KMS key ID for an encrypted cluster snapshot. The KMS
         * key ID is the Amazon Resource Name (ARN), KMS key identifier, or
         * the KMS key alias for the KMS encryption key.
         * If you copy an encrypted cluster snapshot from your account, you can specify a value for KmsKeyId to encrypt the copy with a new KMS encryption key. If you don't specify a value for KmsKeyId, then the copy of the cluster snapshot is encrypted with the same KMS key as the source cluster snapshot.
         * If you copy an encrypted cluster snapshot that is shared from another account, then you must specify a value for KmsKeyId.
         * To copy an encrypted cluster snapshot to another Region, set KmsKeyId to the KMS key ID that you want to use to encrypt the copy of the cluster snapshot in the destination Region. KMS encryption keys are specific to the Region that they are created in, and you can't use encryption keys from one Region in another Region.
         * If you copy an unencrypted cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
         */
        var kmsKeyId: String?
        /**
         * The URL that contains a Signature Version 4 signed request for theCopyDBClusterSnapshot API action in the Region that contains the source cluster snapshot to copy. You must use the PreSignedUrl parameter when copying a cluster snapshot from another Region.
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify
         * SourceRegion (or --source-region for the
         * CLI) instead of specifying PreSignedUrl manually.
         * Specifying SourceRegion autogenerates a pre-signed URL
         * that is a valid request for the operation that can be executed in
         * the source Region.
         * The presigned URL must be a valid request for the
         * CopyDBClusterSnapshot API action that can be executed
         * in the source Region that contains the cluster snapshot to be
         * copied. The presigned URL request must contain the following
         * parameter values:
         * SourceRegion - The ID of the region that
         * contains the snapshot to be copied.
         * SourceDBClusterSnapshotIdentifier - The
         * identifier for the the encrypted cluster snapshot to be
         * copied. This identifier must be in the Amazon Resource Name
         * (ARN) format for the source Region. For example, if you
         * are copying an encrypted cluster snapshot from the us-east-1
         * Region, then your
         * SourceDBClusterSnapshotIdentifier looks
         * something like the following:
         * arn:aws:rds:us-east-1:12345678012:sample-cluster:sample-cluster-snapshot.
         * TargetDBClusterSnapshotIdentifier - The
         * identifier for the new cluster snapshot to be created. This
         * parameter isn't case sensitive.
         */
        var preSignedUrl: String?
        /**
         * The identifier of the cluster snapshot to copy. This parameter is
         * not case sensitive.
         * Constraints:
         * Must specify a valid system snapshot in the
         * available state.
         * If the source snapshot is in the same Region as the copy, specify a valid snapshot identifier.
         * If the source snapshot is in a different Region than the copy, specify a valid cluster snapshot ARN.
         * Example: my-cluster-snapshot1
         */
        var sourceDbClusterSnapshotIdentifier: String?
        /**
         * The tags to be assigned to the cluster snapshot.
         */
        var tags: List<Tag>?
        /**
         * The identifier of the new cluster snapshot to create from the
         * source cluster snapshot. This parameter is not case sensitive.
         * Constraints:
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster-snapshot2
         */
        var targetDbClusterSnapshotIdentifier: String?

        fun build(): CopyDbClusterSnapshotRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var copyTags: Boolean? = null
        override var kmsKeyId: String? = null
        override var preSignedUrl: String? = null
        override var sourceDbClusterSnapshotIdentifier: String? = null
        override var tags: List<Tag>? = null
        override var targetDbClusterSnapshotIdentifier: String? = null

        constructor(x: CopyDbClusterSnapshotRequest) : this() {
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbClusterSnapshotIdentifier = x.sourceDbClusterSnapshotIdentifier
            this.tags = x.tags
            this.targetDbClusterSnapshotIdentifier = x.targetDbClusterSnapshotIdentifier
        }

        override fun build(): CopyDbClusterSnapshotRequest = CopyDbClusterSnapshotRequest(this)
        override fun copyTags(copyTags: Boolean): FluentBuilder = apply { this.copyTags = copyTags }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun preSignedUrl(preSignedUrl: String): FluentBuilder = apply { this.preSignedUrl = preSignedUrl }
        override fun sourceDbClusterSnapshotIdentifier(sourceDbClusterSnapshotIdentifier: String): FluentBuilder = apply { this.sourceDbClusterSnapshotIdentifier = sourceDbClusterSnapshotIdentifier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun targetDbClusterSnapshotIdentifier(targetDbClusterSnapshotIdentifier: String): FluentBuilder = apply { this.targetDbClusterSnapshotIdentifier = targetDbClusterSnapshotIdentifier }
    }
}
