// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to CopyDBClusterParameterGroup.
 */
class CopyDbClusterParameterGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.
     * Constraints:
     * Must specify a valid cluster parameter group.
     * If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, my-db-cluster-param-group, or a valid ARN.
     * If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group.
     */
    val sourceDbClusterParameterGroupIdentifier: String? = builder.sourceDbClusterParameterGroupIdentifier
    /**
     * The tags that are to be assigned to the parameter group.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A description for the copied cluster parameter group.
     */
    val targetDbClusterParameterGroupDescription: String? = builder.targetDbClusterParameterGroupDescription
    /**
     * The identifier for the copied cluster parameter group.
     * Constraints:
     * Cannot be null, empty, or blank.
     * Must contain from 1 to 255 letters, numbers, or hyphens.
     * The first character must be a letter.
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * Example: my-cluster-param-group1
     */
    val targetDbClusterParameterGroupIdentifier: String? = builder.targetDbClusterParameterGroupIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CopyDbClusterParameterGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterParameterGroupRequest(")
        append("sourceDbClusterParameterGroupIdentifier=$sourceDbClusterParameterGroupIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterParameterGroupDescription=$targetDbClusterParameterGroupDescription,")
        append("targetDbClusterParameterGroupIdentifier=$targetDbClusterParameterGroupIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceDbClusterParameterGroupIdentifier?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CopyDbClusterParameterGroupRequest

        if (sourceDbClusterParameterGroupIdentifier != other.sourceDbClusterParameterGroupIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterParameterGroupDescription != other.targetDbClusterParameterGroupDescription) return false
        if (targetDbClusterParameterGroupIdentifier != other.targetDbClusterParameterGroupIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CopyDbClusterParameterGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CopyDbClusterParameterGroupRequest
        /**
         * The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.
         * Constraints:
         * Must specify a valid cluster parameter group.
         * If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, my-db-cluster-param-group, or a valid ARN.
         * If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group.
         */
        fun sourceDbClusterParameterGroupIdentifier(sourceDbClusterParameterGroupIdentifier: String): FluentBuilder
        /**
         * The tags that are to be assigned to the parameter group.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * A description for the copied cluster parameter group.
         */
        fun targetDbClusterParameterGroupDescription(targetDbClusterParameterGroupDescription: String): FluentBuilder
        /**
         * The identifier for the copied cluster parameter group.
         * Constraints:
         * Cannot be null, empty, or blank.
         * Must contain from 1 to 255 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster-param-group1
         */
        fun targetDbClusterParameterGroupIdentifier(targetDbClusterParameterGroupIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The identifier or Amazon Resource Name (ARN) for the source cluster parameter group.
         * Constraints:
         * Must specify a valid cluster parameter group.
         * If the source cluster parameter group is in the same Region as the copy, specify a valid parameter group identifier; for example, my-db-cluster-param-group, or a valid ARN.
         * If the source parameter group is in a different Region than the copy, specify a valid cluster parameter group ARN; for example, arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group.
         */
        var sourceDbClusterParameterGroupIdentifier: String?
        /**
         * The tags that are to be assigned to the parameter group.
         */
        var tags: List<Tag>?
        /**
         * A description for the copied cluster parameter group.
         */
        var targetDbClusterParameterGroupDescription: String?
        /**
         * The identifier for the copied cluster parameter group.
         * Constraints:
         * Cannot be null, empty, or blank.
         * Must contain from 1 to 255 letters, numbers, or hyphens.
         * The first character must be a letter.
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * Example: my-cluster-param-group1
         */
        var targetDbClusterParameterGroupIdentifier: String?

        fun build(): CopyDbClusterParameterGroupRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var sourceDbClusterParameterGroupIdentifier: String? = null
        override var tags: List<Tag>? = null
        override var targetDbClusterParameterGroupDescription: String? = null
        override var targetDbClusterParameterGroupIdentifier: String? = null

        constructor(x: CopyDbClusterParameterGroupRequest) : this() {
            this.sourceDbClusterParameterGroupIdentifier = x.sourceDbClusterParameterGroupIdentifier
            this.tags = x.tags
            this.targetDbClusterParameterGroupDescription = x.targetDbClusterParameterGroupDescription
            this.targetDbClusterParameterGroupIdentifier = x.targetDbClusterParameterGroupIdentifier
        }

        override fun build(): CopyDbClusterParameterGroupRequest = CopyDbClusterParameterGroupRequest(this)
        override fun sourceDbClusterParameterGroupIdentifier(sourceDbClusterParameterGroupIdentifier: String): FluentBuilder = apply { this.sourceDbClusterParameterGroupIdentifier = sourceDbClusterParameterGroupIdentifier }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun targetDbClusterParameterGroupDescription(targetDbClusterParameterGroupDescription: String): FluentBuilder = apply { this.targetDbClusterParameterGroupDescription = targetDbClusterParameterGroupDescription }
        override fun targetDbClusterParameterGroupIdentifier(targetDbClusterParameterGroupIdentifier: String): FluentBuilder = apply { this.targetDbClusterParameterGroupIdentifier = targetDbClusterParameterGroupIdentifier }
    }
}
