// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A certificate authority (CA) certificate for an account.
 */
class Certificate private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) for the certificate.
     * Example: arn:aws:rds:us-east-1::cert:rds-ca-2019
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The unique key that identifies a certificate.
     * Example: rds-ca-2019
     */
    val certificateIdentifier: String? = builder.certificateIdentifier
    /**
     * The type of the certificate.
     * Example: CA
     */
    val certificateType: String? = builder.certificateType
    /**
     * The thumbprint of the certificate.
     */
    val thumbprint: String? = builder.thumbprint
    /**
     * The starting date-time from which the certificate is valid.
     * Example: 2019-07-31T17:57:09Z
     */
    val validFrom: Instant? = builder.validFrom
    /**
     * The date-time after which the certificate is no longer valid.
     * Example: 2024-07-31T17:57:09Z
     */
    val validTill: Instant? = builder.validTill

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Certificate = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Certificate(")
        append("certificateArn=$certificateArn,")
        append("certificateIdentifier=$certificateIdentifier,")
        append("certificateType=$certificateType,")
        append("thumbprint=$thumbprint,")
        append("validFrom=$validFrom,")
        append("validTill=$validTill)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (certificateType?.hashCode() ?: 0)
        result = 31 * result + (thumbprint?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validTill?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Certificate

        if (certificateArn != other.certificateArn) return false
        if (certificateIdentifier != other.certificateIdentifier) return false
        if (certificateType != other.certificateType) return false
        if (thumbprint != other.thumbprint) return false
        if (validFrom != other.validFrom) return false
        if (validTill != other.validTill) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Certificate = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Certificate
        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * Example: arn:aws:rds:us-east-1::cert:rds-ca-2019
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The unique key that identifies a certificate.
         * Example: rds-ca-2019
         */
        fun certificateIdentifier(certificateIdentifier: String): FluentBuilder
        /**
         * The type of the certificate.
         * Example: CA
         */
        fun certificateType(certificateType: String): FluentBuilder
        /**
         * The thumbprint of the certificate.
         */
        fun thumbprint(thumbprint: String): FluentBuilder
        /**
         * The starting date-time from which the certificate is valid.
         * Example: 2019-07-31T17:57:09Z
         */
        fun validFrom(validFrom: Instant): FluentBuilder
        /**
         * The date-time after which the certificate is no longer valid.
         * Example: 2024-07-31T17:57:09Z
         */
        fun validTill(validTill: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) for the certificate.
         * Example: arn:aws:rds:us-east-1::cert:rds-ca-2019
         */
        var certificateArn: String?
        /**
         * The unique key that identifies a certificate.
         * Example: rds-ca-2019
         */
        var certificateIdentifier: String?
        /**
         * The type of the certificate.
         * Example: CA
         */
        var certificateType: String?
        /**
         * The thumbprint of the certificate.
         */
        var thumbprint: String?
        /**
         * The starting date-time from which the certificate is valid.
         * Example: 2019-07-31T17:57:09Z
         */
        var validFrom: Instant?
        /**
         * The date-time after which the certificate is no longer valid.
         * Example: 2024-07-31T17:57:09Z
         */
        var validTill: Instant?

        fun build(): Certificate
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var certificateArn: String? = null
        override var certificateIdentifier: String? = null
        override var certificateType: String? = null
        override var thumbprint: String? = null
        override var validFrom: Instant? = null
        override var validTill: Instant? = null

        constructor(x: Certificate) : this() {
            this.certificateArn = x.certificateArn
            this.certificateIdentifier = x.certificateIdentifier
            this.certificateType = x.certificateType
            this.thumbprint = x.thumbprint
            this.validFrom = x.validFrom
            this.validTill = x.validTill
        }

        override fun build(): Certificate = Certificate(this)
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun certificateIdentifier(certificateIdentifier: String): FluentBuilder = apply { this.certificateIdentifier = certificateIdentifier }
        override fun certificateType(certificateType: String): FluentBuilder = apply { this.certificateType = certificateType }
        override fun thumbprint(thumbprint: String): FluentBuilder = apply { this.thumbprint = thumbprint }
        override fun validFrom(validFrom: Instant): FluentBuilder = apply { this.validFrom = validFrom }
        override fun validTill(validTill: Instant): FluentBuilder = apply { this.validTill = validTill }
    }
}
