// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb.model



/**
 * Represents the input to ApplyPendingMaintenanceAction.
 */
class ApplyPendingMaintenanceActionRequest private constructor(builder: BuilderImpl) {
    /**
     * The pending maintenance action to apply to this resource.
     * Valid values: system-update, db-upgrade
     */
    val applyAction: String? = builder.applyAction
    /**
     * A value that specifies the type of opt-in request or undoes an
     * opt-in request. An opt-in request of type immediate
     * can't be undone.
     * Valid values:
     * immediate - Apply the maintenance action
     * immediately.
     * next-maintenance - Apply the maintenance
     * action during the next maintenance window for the resource.
     * undo-opt-in - Cancel any existing
     * next-maintenance opt-in requests.
     */
    val optInType: String? = builder.optInType
    /**
     * The Amazon Resource Name (ARN) of the resource that the pending
     * maintenance action applies to.
     */
    val resourceIdentifier: String? = builder.resourceIdentifier

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApplyPendingMaintenanceActionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApplyPendingMaintenanceActionRequest(")
        append("applyAction=$applyAction,")
        append("optInType=$optInType,")
        append("resourceIdentifier=$resourceIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyAction?.hashCode() ?: 0
        result = 31 * result + (optInType?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplyPendingMaintenanceActionRequest

        if (applyAction != other.applyAction) return false
        if (optInType != other.optInType) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApplyPendingMaintenanceActionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApplyPendingMaintenanceActionRequest
        /**
         * The pending maintenance action to apply to this resource.
         * Valid values: system-update, db-upgrade
         */
        fun applyAction(applyAction: String): FluentBuilder
        /**
         * A value that specifies the type of opt-in request or undoes an
         * opt-in request. An opt-in request of type immediate
         * can't be undone.
         * Valid values:
         * immediate - Apply the maintenance action
         * immediately.
         * next-maintenance - Apply the maintenance
         * action during the next maintenance window for the resource.
         * undo-opt-in - Cancel any existing
         * next-maintenance opt-in requests.
         */
        fun optInType(optInType: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the resource that the pending
         * maintenance action applies to.
         */
        fun resourceIdentifier(resourceIdentifier: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The pending maintenance action to apply to this resource.
         * Valid values: system-update, db-upgrade
         */
        var applyAction: String?
        /**
         * A value that specifies the type of opt-in request or undoes an
         * opt-in request. An opt-in request of type immediate
         * can't be undone.
         * Valid values:
         * immediate - Apply the maintenance action
         * immediately.
         * next-maintenance - Apply the maintenance
         * action during the next maintenance window for the resource.
         * undo-opt-in - Cancel any existing
         * next-maintenance opt-in requests.
         */
        var optInType: String?
        /**
         * The Amazon Resource Name (ARN) of the resource that the pending
         * maintenance action applies to.
         */
        var resourceIdentifier: String?

        fun build(): ApplyPendingMaintenanceActionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var applyAction: String? = null
        override var optInType: String? = null
        override var resourceIdentifier: String? = null

        constructor(x: ApplyPendingMaintenanceActionRequest) : this() {
            this.applyAction = x.applyAction
            this.optInType = x.optInType
            this.resourceIdentifier = x.resourceIdentifier
        }

        override fun build(): ApplyPendingMaintenanceActionRequest = ApplyPendingMaintenanceActionRequest(this)
        override fun applyAction(applyAction: String): FluentBuilder = apply { this.applyAction = applyAction }
        override fun optInType(optInType: String): FluentBuilder = apply { this.optInType = optInType }
        override fun resourceIdentifier(resourceIdentifier: String): FluentBuilder = apply { this.resourceIdentifier = resourceIdentifier }
    }
}
