// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.docdb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.docdb.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Amazon DocumentDB API documentation
 */
interface DocDbClient : SdkClient {

    override val serviceName: String
        get() = "DocDB"
    /**
     * DocDbClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): DocDbClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultDocDbClient(config)
        }

        operator fun invoke(config: Config): DocDbClient = DefaultDocDbClient(config)

        /**
         * Construct a [DocDbClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): DocDbClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return DocDbClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Adds a source identifier to an existing event notification
     * subscription.
     */
    suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse

    /**
     * Adds a source identifier to an existing event notification
     * subscription.
     */
    suspend fun addSourceIdentifierToSubscription(block: AddSourceIdentifierToSubscriptionRequest.DslBuilder.() -> Unit) = addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.builder().apply(block).build())

    /**
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags
     * with cost allocation reporting to track costs that are associated
     * with Amazon DocumentDB resources or in a Condition statement in
     * an Identity and Access Management (IAM) policy for Amazon DocumentDB.
     */
    suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags
     * with cost allocation reporting to track costs that are associated
     * with Amazon DocumentDB resources or in a Condition statement in
     * an Identity and Access Management (IAM) policy for Amazon DocumentDB.
     */
    suspend fun addTagsToResource(block: AddTagsToResourceRequest.DslBuilder.() -> Unit) = addTagsToResource(AddTagsToResourceRequest.builder().apply(block).build())

    /**
     * Applies a pending maintenance action to a resource (for example,
     * to an Amazon DocumentDB instance).
     */
    suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Applies a pending maintenance action to a resource (for example,
     * to an Amazon DocumentDB instance).
     */
    suspend fun applyPendingMaintenanceAction(block: ApplyPendingMaintenanceActionRequest.DslBuilder.() -> Unit) = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder().apply(block).build())

    /**
     * Copies the specified cluster parameter group.
     */
    suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse

    /**
     * Copies the specified cluster parameter group.
     */
    suspend fun copyDbClusterParameterGroup(block: CopyDbClusterParameterGroupRequest.DslBuilder.() -> Unit) = copyDbClusterParameterGroup(CopyDbClusterParameterGroupRequest.builder().apply(block).build())

    /**
     * Copies a snapshot of a cluster.
     * To copy a cluster snapshot from a shared manual cluster snapshot,
     * SourceDBClusterSnapshotIdentifier must be the Amazon
     * Resource Name (ARN) of the shared cluster snapshot. You can only
     * copy a shared DB cluster snapshot, whether encrypted or not, in the
     * same Region.
     * To cancel the copy operation after it is in progress, delete the
     * target cluster snapshot identified by
     * TargetDBClusterSnapshotIdentifier while that cluster
     * snapshot is in the copying status.
     */
    suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse

    /**
     * Copies a snapshot of a cluster.
     * To copy a cluster snapshot from a shared manual cluster snapshot,
     * SourceDBClusterSnapshotIdentifier must be the Amazon
     * Resource Name (ARN) of the shared cluster snapshot. You can only
     * copy a shared DB cluster snapshot, whether encrypted or not, in the
     * same Region.
     * To cancel the copy operation after it is in progress, delete the
     * target cluster snapshot identified by
     * TargetDBClusterSnapshotIdentifier while that cluster
     * snapshot is in the copying status.
     */
    suspend fun copyDbClusterSnapshot(block: CopyDbClusterSnapshotRequest.DslBuilder.() -> Unit) = copyDbClusterSnapshot(CopyDbClusterSnapshotRequest.builder().apply(block).build())

    /**
     * Creates a new Amazon DocumentDB cluster.
     */
    suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse

    /**
     * Creates a new Amazon DocumentDB cluster.
     */
    suspend fun createDbCluster(block: CreateDbClusterRequest.DslBuilder.() -> Unit) = createDbCluster(CreateDbClusterRequest.builder().apply(block).build())

    /**
     * Creates a new cluster parameter group.
     * Parameters in a cluster parameter group apply to all of the
     * instances in a cluster.
     * A cluster parameter group is initially created with the default
     * parameters for the database engine used by instances in the cluster.
     * In Amazon DocumentDB, you cannot make modifications directly to the
     * default.docdb3.6 cluster parameter group. If your
     * Amazon DocumentDB cluster is using the default cluster parameter group and you
     * want to modify a value in it, you must first <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html">
     * create a new parameter group
     * or <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html">
     * copy an existing parameter group,
     * modify it, and then apply the modified parameter group to your
     * cluster. For the new cluster parameter group and associated settings
     * to take effect, you must then reboot the instances in the cluster
     * without failover. For more information,
     * see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html">
     * Modifying Amazon DocumentDB Cluster Parameter Groups.
     */
    suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse

    /**
     * Creates a new cluster parameter group.
     * Parameters in a cluster parameter group apply to all of the
     * instances in a cluster.
     * A cluster parameter group is initially created with the default
     * parameters for the database engine used by instances in the cluster.
     * In Amazon DocumentDB, you cannot make modifications directly to the
     * default.docdb3.6 cluster parameter group. If your
     * Amazon DocumentDB cluster is using the default cluster parameter group and you
     * want to modify a value in it, you must first <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html">
     * create a new parameter group
     * or <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html">
     * copy an existing parameter group,
     * modify it, and then apply the modified parameter group to your
     * cluster. For the new cluster parameter group and associated settings
     * to take effect, you must then reboot the instances in the cluster
     * without failover. For more information,
     * see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html">
     * Modifying Amazon DocumentDB Cluster Parameter Groups.
     */
    suspend fun createDbClusterParameterGroup(block: CreateDbClusterParameterGroupRequest.DslBuilder.() -> Unit) = createDbClusterParameterGroup(CreateDbClusterParameterGroupRequest.builder().apply(block).build())

    /**
     * Creates a snapshot of a cluster.
     */
    suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse

    /**
     * Creates a snapshot of a cluster.
     */
    suspend fun createDbClusterSnapshot(block: CreateDbClusterSnapshotRequest.DslBuilder.() -> Unit) = createDbClusterSnapshot(CreateDbClusterSnapshotRequest.builder().apply(block).build())

    /**
     * Creates a new instance.
     */
    suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse

    /**
     * Creates a new instance.
     */
    suspend fun createDbInstance(block: CreateDbInstanceRequest.DslBuilder.() -> Unit) = createDbInstance(CreateDbInstanceRequest.builder().apply(block).build())

    /**
     * Creates a new subnet group. subnet groups must contain at least one subnet in at
     * least two Availability Zones in the Region.
     */
    suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse

    /**
     * Creates a new subnet group. subnet groups must contain at least one subnet in at
     * least two Availability Zones in the Region.
     */
    suspend fun createDbSubnetGroup(block: CreateDbSubnetGroupRequest.DslBuilder.() -> Unit) = createDbSubnetGroup(CreateDbSubnetGroupRequest.builder().apply(block).build())

    /**
     * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
     * You can specify the type of source (SourceType) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (SourceIds) that trigger the events, and you can provide a list of event categories (EventCategories) for events that you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.
     * If you specify both the SourceType and SourceIds (such as SourceType = db-instance and SourceIdentifier = myDBInstance1), you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the SourceType or the SourceIdentifier, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
     */
    suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
     * You can specify the type of source (SourceType) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (SourceIds) that trigger the events, and you can provide a list of event categories (EventCategories) for events that you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.
     * If you specify both the SourceType and SourceIds (such as SourceType = db-instance and SourceIdentifier = myDBInstance1), you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the SourceType or the SourceIdentifier, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
     */
    suspend fun createEventSubscription(block: CreateEventSubscriptionRequest.DslBuilder.() -> Unit) = createEventSubscription(CreateEventSubscriptionRequest.builder().apply(block).build())

    /**
     * Creates an Amazon DocumentDB global cluster that can span multiple multiple Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
     * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse

    /**
     * Creates an Amazon DocumentDB global cluster that can span multiple multiple Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
     * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun createGlobalCluster(block: CreateGlobalClusterRequest.DslBuilder.() -> Unit) = createGlobalCluster(CreateGlobalClusterRequest.builder().apply(block).build())

    /**
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     */
    suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse

    /**
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     */
    suspend fun deleteDbCluster(block: DeleteDbClusterRequest.DslBuilder.() -> Unit) = deleteDbCluster(DeleteDbClusterRequest.builder().apply(block).build())

    /**
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
     */
    suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse

    /**
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
     */
    suspend fun deleteDbClusterParameterGroup(block: DeleteDbClusterParameterGroupRequest.DslBuilder.() -> Unit) = deleteDbClusterParameterGroup(DeleteDbClusterParameterGroupRequest.builder().apply(block).build())

    /**
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * The cluster snapshot must be in the available state to be deleted.
     */
    suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse

    /**
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * The cluster snapshot must be in the available state to be deleted.
     */
    suspend fun deleteDbClusterSnapshot(block: DeleteDbClusterSnapshotRequest.DslBuilder.() -> Unit) = deleteDbClusterSnapshot(DeleteDbClusterSnapshotRequest.builder().apply(block).build())

    /**
     * Deletes a previously provisioned instance.
     */
    suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse

    /**
     * Deletes a previously provisioned instance.
     */
    suspend fun deleteDbInstance(block: DeleteDbInstanceRequest.DslBuilder.() -> Unit) = deleteDbInstance(DeleteDbInstanceRequest.builder().apply(block).build())

    /**
     * Deletes a subnet group.
     * The specified database subnet group must not be associated with any DB
     * instances.
     */
    suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse

    /**
     * Deletes a subnet group.
     * The specified database subnet group must not be associated with any DB
     * instances.
     */
    suspend fun deleteDbSubnetGroup(block: DeleteDbSubnetGroupRequest.DslBuilder.() -> Unit) = deleteDbSubnetGroup(DeleteDbSubnetGroupRequest.builder().apply(block).build())

    /**
     * Deletes an Amazon DocumentDB event notification subscription.
     */
    suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes an Amazon DocumentDB event notification subscription.
     */
    suspend fun deleteEventSubscription(block: DeleteEventSubscriptionRequest.DslBuilder.() -> Unit) = deleteEventSubscription(DeleteEventSubscriptionRequest.builder().apply(block).build())

    /**
     * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse

    /**
     * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun deleteGlobalCluster(block: DeleteGlobalClusterRequest.DslBuilder.() -> Unit) = deleteGlobalCluster(DeleteGlobalClusterRequest.builder().apply(block).build())

    /**
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this account.
     */
    suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse

    /**
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this account.
     */
    suspend fun describeCertificates(block: DescribeCertificatesRequest.DslBuilder.() -> Unit) = describeCertificates(DescribeCertificatesRequest.builder().apply(block).build())

    /**
     * Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName parameter is specified, the list contains only the description of the specified cluster parameter group.
     */
    suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest): DescribeDbClusterParameterGroupsResponse

    /**
     * Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName parameter is specified, the list contains only the description of the specified cluster parameter group.
     */
    suspend fun describeDbClusterParameterGroups(block: DescribeDbClusterParameterGroupsRequest.DslBuilder.() -> Unit) = describeDbClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular cluster parameter
     * group.
     */
    suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse

    /**
     * Returns the detailed parameter list for a particular cluster parameter
     * group.
     */
    suspend fun describeDbClusterParameters(block: DescribeDbClusterParametersRequest.DslBuilder.() -> Unit) = describeDbClusterParameters(DescribeDbClusterParametersRequest.builder().apply(block).build())

    /**
     * Returns a list of cluster snapshot attribute names and values for a manual DB
     * cluster snapshot.
     * When you share snapshots with other accounts,
     * DescribeDBClusterSnapshotAttributes returns the restore attribute and a list of IDs for the accounts that are authorized to copy or restore the manual cluster snapshot. If all is included in the list of values for the restore attribute, then the manual cluster snapshot is public and can be copied or restored by all accounts.
     */
    suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse

    /**
     * Returns a list of cluster snapshot attribute names and values for a manual DB
     * cluster snapshot.
     * When you share snapshots with other accounts,
     * DescribeDBClusterSnapshotAttributes returns the restore attribute and a list of IDs for the accounts that are authorized to copy or restore the manual cluster snapshot. If all is included in the list of values for the restore attribute, then the manual cluster snapshot is public and can be copied or restored by all accounts.
     */
    suspend fun describeDbClusterSnapshotAttributes(block: DescribeDbClusterSnapshotAttributesRequest.DslBuilder.() -> Unit) = describeDbClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.builder().apply(block).build())

    /**
     * Returns information about cluster snapshots. This API operation supports pagination.
     */
    suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest): DescribeDbClusterSnapshotsResponse

    /**
     * Returns information about cluster snapshots. This API operation supports pagination.
     */
    suspend fun describeDbClusterSnapshots(block: DescribeDbClusterSnapshotsRequest.DslBuilder.() -> Unit) = describeDbClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder().apply(block).build())

    /**
     * Returns information about provisioned Amazon DocumentDB clusters. This API
     * operation supports pagination. For certain management features
     * such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon
     * Neptune. Use the filterName=engine,Values=docdb filter
     * parameter to return only Amazon DocumentDB clusters.
     */
    suspend fun describeDbClusters(input: DescribeDbClustersRequest): DescribeDbClustersResponse

    /**
     * Returns information about provisioned Amazon DocumentDB clusters. This API
     * operation supports pagination. For certain management features
     * such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon
     * Neptune. Use the filterName=engine,Values=docdb filter
     * parameter to return only Amazon DocumentDB clusters.
     */
    suspend fun describeDbClusters(block: DescribeDbClustersRequest.DslBuilder.() -> Unit) = describeDbClusters(DescribeDbClustersRequest.builder().apply(block).build())

    /**
     * Returns a list of the available engines.
     */
    suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest): DescribeDbEngineVersionsResponse

    /**
     * Returns a list of the available engines.
     */
    suspend fun describeDbEngineVersions(block: DescribeDbEngineVersionsRequest.DslBuilder.() -> Unit) = describeDbEngineVersions(DescribeDbEngineVersionsRequest.builder().apply(block).build())

    /**
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     */
    suspend fun describeDbInstances(input: DescribeDbInstancesRequest): DescribeDbInstancesResponse

    /**
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     */
    suspend fun describeDbInstances(block: DescribeDbInstancesRequest.DslBuilder.() -> Unit) = describeDbInstances(DescribeDbInstancesRequest.builder().apply(block).build())

    /**
     * Returns a list of DBSubnetGroup descriptions. If a
     * DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     */
    suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest): DescribeDbSubnetGroupsResponse

    /**
     * Returns a list of DBSubnetGroup descriptions. If a
     * DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     */
    suspend fun describeDbSubnetGroups(block: DescribeDbSubnetGroupsRequest.DslBuilder.() -> Unit) = describeDbSubnetGroups(DescribeDbSubnetGroupsRequest.builder().apply(block).build())

    /**
     * Returns the default engine and system parameter information for the cluster database
     * engine.
     */
    suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse

    /**
     * Returns the default engine and system parameter information for the cluster database
     * engine.
     */
    suspend fun describeEngineDefaultClusterParameters(block: DescribeEngineDefaultClusterParametersRequest.DslBuilder.() -> Unit) = describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.builder().apply(block).build())

    /**
     * Displays a list of categories for all event source types, or, if specified, for a
     * specified source type.
     */
    suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse

    /**
     * Displays a list of categories for all event source types, or, if specified, for a
     * specified source type.
     */
    suspend fun describeEventCategories(block: DescribeEventCategoriesRequest.DslBuilder.() -> Unit) = describeEventCategories(DescribeEventCategoriesRequest.builder().apply(block).build())

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * If you specify a SubscriptionName, lists the description for that subscription.
     */
    suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * If you specify a SubscriptionName, lists the description for that subscription.
     */
    suspend fun describeEventSubscriptions(block: DescribeEventSubscriptionsRequest.DslBuilder.() -> Unit) = describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().apply(block).build())

    /**
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
     */
    suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse

    /**
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.DslBuilder.() -> Unit) = describeEvents(DescribeEventsRequest.builder().apply(block).build())

    /**
     * Returns information about Amazon DocumentDB global  clusters. This API supports pagination.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest): DescribeGlobalClustersResponse

    /**
     * Returns information about Amazon DocumentDB global  clusters. This API supports pagination.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun describeGlobalClusters(block: DescribeGlobalClustersRequest.DslBuilder.() -> Unit) = describeGlobalClusters(DescribeGlobalClustersRequest.builder().apply(block).build())

    /**
     * Returns a list of orderable instance options for the specified engine.
     */
    suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse

    /**
     * Returns a list of orderable instance options for the specified engine.
     */
    suspend fun describeOrderableDbInstanceOptions(block: DescribeOrderableDbInstanceOptionsRequest.DslBuilder.() -> Unit) = describeOrderableDbInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.builder().apply(block).build())

    /**
     * Returns a list of resources (for example, instances) that have at least one pending
     * maintenance action.
     */
    suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse

    /**
     * Returns a list of resources (for example, instances) that have at least one pending
     * maintenance action.
     */
    suspend fun describePendingMaintenanceActions(block: DescribePendingMaintenanceActionsRequest.DslBuilder.() -> Unit) = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder().apply(block).build())

    /**
     * Forces a failover for a cluster.
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     */
    suspend fun failoverDbCluster(input: FailoverDbClusterRequest): FailoverDbClusterResponse

    /**
     * Forces a failover for a cluster.
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     */
    suspend fun failoverDbCluster(block: FailoverDbClusterRequest.DslBuilder.() -> Unit) = failoverDbCluster(FailoverDbClusterRequest.builder().apply(block).build())

    /**
     * Lists all tags on an Amazon DocumentDB resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all tags on an Amazon DocumentDB resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database
     * configuration parameters by specifying these parameters and the new values in the
     * request.
     */
    suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse

    /**
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database
     * configuration parameters by specifying these parameters and the new values in the
     * request.
     */
    suspend fun modifyDbCluster(block: ModifyDbClusterRequest.DslBuilder.() -> Unit) = modifyDbCluster(ModifyDbClusterRequest.builder().apply(block).build())

    /**
     * Modifies the parameters of a cluster parameter group. To modify more than one
     * parameter, submit a list of the following: ParameterName,
     * ParameterValue, and ApplyMethod. A maximum of 20
     * parameters can be modified in a single request.
     * Changes to dynamic parameters are applied immediately. Changes to static
     * parameters require a reboot or maintenance window
     * before the change can take effect.
     * After you create a cluster parameter group, you should wait at least 5 minutes
     * before creating your first cluster that uses that cluster parameter group as
     * the default parameter group. This allows Amazon DocumentDB to fully complete the create action
     * before the parameter group is used as the default for a new cluster. This step is
     * especially important for parameters that are critical when creating the default
     * database for a cluster, such as the character set for the default database
     * defined by the character_set_database parameter.
     */
    suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a cluster parameter group. To modify more than one
     * parameter, submit a list of the following: ParameterName,
     * ParameterValue, and ApplyMethod. A maximum of 20
     * parameters can be modified in a single request.
     * Changes to dynamic parameters are applied immediately. Changes to static
     * parameters require a reboot or maintenance window
     * before the change can take effect.
     * After you create a cluster parameter group, you should wait at least 5 minutes
     * before creating your first cluster that uses that cluster parameter group as
     * the default parameter group. This allows Amazon DocumentDB to fully complete the create action
     * before the parameter group is used as the default for a new cluster. This step is
     * especially important for parameters that are critical when creating the default
     * database for a cluster, such as the character set for the default database
     * defined by the character_set_database parameter.
     */
    suspend fun modifyDbClusterParameterGroup(block: ModifyDbClusterParameterGroupRequest.DslBuilder.() -> Unit) = modifyDbClusterParameterGroup(ModifyDbClusterParameterGroupRequest.builder().apply(block).build())

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
     * To share a manual cluster snapshot with other accounts, specify restore as the AttributeName, and use the ValuesToAdd parameter to add a list of IDs of the accounts that are authorized to restore the manual cluster snapshot. Use the value all to make the manual cluster snapshot public, which means that it can be copied or restored by all accounts. Do not add the all value for any manual cluster snapshots that contain private information that you don't want available to all accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized account IDs for the ValuesToAdd parameter. You can't use all as a value for that parameter in this case.
     */
    suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
     * To share a manual cluster snapshot with other accounts, specify restore as the AttributeName, and use the ValuesToAdd parameter to add a list of IDs of the accounts that are authorized to restore the manual cluster snapshot. Use the value all to make the manual cluster snapshot public, which means that it can be copied or restored by all accounts. Do not add the all value for any manual cluster snapshots that contain private information that you don't want available to all accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized account IDs for the ValuesToAdd parameter. You can't use all as a value for that parameter in this case.
     */
    suspend fun modifyDbClusterSnapshotAttribute(block: ModifyDbClusterSnapshotAttributeRequest.DslBuilder.() -> Unit) = modifyDbClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.builder().apply(block).build())

    /**
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse

    /**
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    suspend fun modifyDbInstance(block: ModifyDbInstanceRequest.DslBuilder.() -> Unit) = modifyDbInstance(ModifyDbInstanceRequest.builder().apply(block).build())

    /**
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Region.
     */
    suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse

    /**
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Region.
     */
    suspend fun modifyDbSubnetGroup(block: ModifyDbSubnetGroupRequest.DslBuilder.() -> Unit) = modifyDbSubnetGroup(ModifyDbSubnetGroupRequest.builder().apply(block).build())

    /**
     * Modifies an existing Amazon DocumentDB event notification subscription.
     */
    suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modifies an existing Amazon DocumentDB event notification subscription.
     */
    suspend fun modifyEventSubscription(block: ModifyEventSubscriptionRequest.DslBuilder.() -> Unit) = modifyEventSubscription(ModifyEventSubscriptionRequest.builder().apply(block).build())

    /**
     * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse

    /**
     * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun modifyGlobalCluster(block: ModifyGlobalClusterRequest.DslBuilder.() -> Unit) = modifyGlobalCluster(ModifyGlobalClusterRequest.builder().apply(block).build())

    /**
     * You might need to reboot your instance, usually for maintenance reasons. For
     * example, if you make certain changes, or if you change the cluster parameter group
     * that is associated with the instance, you must reboot the instance for the changes to
     * take effect.
     * Rebooting an instance restarts the database engine service. Rebooting an instance
     * results in a momentary outage, during which the instance status is set to
     * rebooting.
     */
    suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse

    /**
     * You might need to reboot your instance, usually for maintenance reasons. For
     * example, if you make certain changes, or if you change the cluster parameter group
     * that is associated with the instance, you must reboot the instance for the changes to
     * take effect.
     * Rebooting an instance restarts the database engine service. Rebooting an instance
     * results in a momentary outage, during which the instance status is set to
     * rebooting.
     */
    suspend fun rebootDbInstance(block: RebootDbInstanceRequest.DslBuilder.() -> Unit) = rebootDbInstance(RebootDbInstanceRequest.builder().apply(block).build())

    /**
     * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse

    /**
     * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
     * This action only applies to Amazon DocumentDB clusters.
     */
    suspend fun removeFromGlobalCluster(block: RemoveFromGlobalClusterRequest.DslBuilder.() -> Unit) = removeFromGlobalCluster(RemoveFromGlobalClusterRequest.builder().apply(block).build())

    /**
     * Removes a source identifier from an existing Amazon DocumentDB event notification
     * subscription.
     */
    suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse

    /**
     * Removes a source identifier from an existing Amazon DocumentDB event notification
     * subscription.
     */
    suspend fun removeSourceIdentifierFromSubscription(block: RemoveSourceIdentifierFromSubscriptionRequest.DslBuilder.() -> Unit) = removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.builder().apply(block).build())

    /**
     * Removes metadata tags from an Amazon DocumentDB resource.
     */
    suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Removes metadata tags from an Amazon DocumentDB resource.
     */
    suspend fun removeTagsFromResource(block: RemoveTagsFromResourceRequest.DslBuilder.() -> Unit) = removeTagsFromResource(RemoveTagsFromResourceRequest.builder().apply(block).build())

    /**
     * Modifies the parameters of a cluster parameter group to the default value. To
     * reset specific parameters, submit a list of the following: ParameterName
     * and ApplyMethod. To reset the entire cluster parameter group, specify
     * the DBClusterParameterGroupName and ResetAllParameters
     * parameters.
     * When you reset the entire group, dynamic parameters are updated immediately and
     * static parameters are set to pending-reboot to take effect on the next DB
     * instance reboot.
     */
    suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a cluster parameter group to the default value. To
     * reset specific parameters, submit a list of the following: ParameterName
     * and ApplyMethod. To reset the entire cluster parameter group, specify
     * the DBClusterParameterGroupName and ResetAllParameters
     * parameters.
     * When you reset the entire group, dynamic parameters are updated immediately and
     * static parameters are set to pending-reboot to take effect on the next DB
     * instance reboot.
     */
    suspend fun resetDbClusterParameterGroup(block: ResetDbClusterParameterGroupRequest.DslBuilder.() -> Unit) = resetDbClusterParameterGroup(ResetDbClusterParameterGroupRequest.builder().apply(block).build())

    /**
     * Creates a new cluster from a snapshot or cluster snapshot.
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse

    /**
     * Creates a new cluster from a snapshot or cluster snapshot.
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterFromSnapshot(block: RestoreDbClusterFromSnapshotRequest.DslBuilder.() -> Unit) = restoreDbClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.builder().apply(block).build())

    /**
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in
     * time before LatestRestorableTime for up to
     * BackupRetentionPeriod days. The target cluster is created from the
     * source cluster with the same configuration as the original cluster, except that
     * the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse

    /**
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in
     * time before LatestRestorableTime for up to
     * BackupRetentionPeriod days. The target cluster is created from the
     * source cluster with the same configuration as the original cluster, except that
     * the new cluster is created with the default security group.
     */
    suspend fun restoreDbClusterToPointInTime(block: RestoreDbClusterToPointInTimeRequest.DslBuilder.() -> Unit) = restoreDbClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.builder().apply(block).build())

    /**
     * Restarts the stopped cluster that is specified by DBClusterIdentifier.
     * For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster.
     */
    suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse

    /**
     * Restarts the stopped cluster that is specified by DBClusterIdentifier.
     * For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster.
     */
    suspend fun startDbCluster(block: StartDbClusterRequest.DslBuilder.() -> Unit) = startDbCluster(StartDbClusterRequest.builder().apply(block).build())

    /**
     * Stops the running cluster that is specified by DBClusterIdentifier. The
     * cluster must be in the available state. For more information, see
     * <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster.
     */
    suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse

    /**
     * Stops the running cluster that is specified by DBClusterIdentifier. The
     * cluster must be in the available state. For more information, see
     * <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster.
     */
    suspend fun stopDbCluster(block: StopDbClusterRequest.DslBuilder.() -> Unit) = stopDbCluster(StopDbClusterRequest.builder().apply(block).build())
}
