// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.docdb

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.docdb.model.*
import aws.sdk.kotlin.services.docdb.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "DocDB"
const val ServiceApiVersion: String = "2014-10-31"
const val SdkVersion: String = "0.9.2-alpha"

internal class DefaultDocDbClient(override val config: DocDbClient.Config) : DocDbClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Adds a source identifier to an existing event notification
     * subscription.
     */
    override suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse {
        val op = SdkHttpOperation.build<AddSourceIdentifierToSubscriptionRequest, AddSourceIdentifierToSubscriptionResponse> {
            serializer = AddSourceIdentifierToSubscriptionOperationSerializer()
            deserializer = AddSourceIdentifierToSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddSourceIdentifierToSubscription"
            }
        }
        registerAddSourceIdentifierToSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds metadata tags to an Amazon DocumentDB resource. You can use these tags
     * with cost allocation reporting to track costs that are associated
     * with Amazon DocumentDB resources or in a Condition statement in
     * an Identity and Access Management (IAM) policy for Amazon DocumentDB.
     */
    override suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse {
        val op = SdkHttpOperation.build<AddTagsToResourceRequest, AddTagsToResourceResponse> {
            serializer = AddTagsToResourceOperationSerializer()
            deserializer = AddTagsToResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTagsToResource"
            }
        }
        registerAddTagsToResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Applies a pending maintenance action to a resource (for example,
     * to an Amazon DocumentDB instance).
     */
    override suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse {
        val op = SdkHttpOperation.build<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse> {
            serializer = ApplyPendingMaintenanceActionOperationSerializer()
            deserializer = ApplyPendingMaintenanceActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplyPendingMaintenanceAction"
            }
        }
        registerApplyPendingMaintenanceActionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified cluster parameter group.
     */
    override suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<CopyDbClusterParameterGroupRequest, CopyDbClusterParameterGroupResponse> {
            serializer = CopyDBClusterParameterGroupOperationSerializer()
            deserializer = CopyDBClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyDBClusterParameterGroup"
            }
        }
        registerCopyDbClusterParameterGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Copies a snapshot of a cluster.
     * To copy a cluster snapshot from a shared manual cluster snapshot,
     * SourceDBClusterSnapshotIdentifier must be the Amazon
     * Resource Name (ARN) of the shared cluster snapshot. You can only
     * copy a shared DB cluster snapshot, whether encrypted or not, in the
     * same Region.
     * To cancel the copy operation after it is in progress, delete the
     * target cluster snapshot identified by
     * TargetDBClusterSnapshotIdentifier while that cluster
     * snapshot is in the copying status.
     */
    override suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse {
        val op = SdkHttpOperation.build<CopyDbClusterSnapshotRequest, CopyDbClusterSnapshotResponse> {
            serializer = CopyDBClusterSnapshotOperationSerializer()
            deserializer = CopyDBClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CopyDBClusterSnapshot"
            }
        }
        registerCopyDbClusterSnapshotMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Amazon DocumentDB cluster.
     */
    override suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse {
        val op = SdkHttpOperation.build<CreateDbClusterRequest, CreateDbClusterResponse> {
            serializer = CreateDBClusterOperationSerializer()
            deserializer = CreateDBClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDBCluster"
            }
        }
        registerCreateDbClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cluster parameter group.
     * Parameters in a cluster parameter group apply to all of the
     * instances in a cluster.
     * A cluster parameter group is initially created with the default
     * parameters for the database engine used by instances in the cluster.
     * In Amazon DocumentDB, you cannot make modifications directly to the
     * default.docdb3.6 cluster parameter group. If your
     * Amazon DocumentDB cluster is using the default cluster parameter group and you
     * want to modify a value in it, you must first <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-create.html">
     * create a new parameter group
     * or <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-copy.html">
     * copy an existing parameter group,
     * modify it, and then apply the modified parameter group to your
     * cluster. For the new cluster parameter group and associated settings
     * to take effect, you must then reboot the instances in the cluster
     * without failover. For more information,
     * see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/cluster_parameter_group-modify.html">
     * Modifying Amazon DocumentDB Cluster Parameter Groups.
     */
    override suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<CreateDbClusterParameterGroupRequest, CreateDbClusterParameterGroupResponse> {
            serializer = CreateDBClusterParameterGroupOperationSerializer()
            deserializer = CreateDBClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDBClusterParameterGroup"
            }
        }
        registerCreateDbClusterParameterGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a snapshot of a cluster.
     */
    override suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse {
        val op = SdkHttpOperation.build<CreateDbClusterSnapshotRequest, CreateDbClusterSnapshotResponse> {
            serializer = CreateDBClusterSnapshotOperationSerializer()
            deserializer = CreateDBClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDBClusterSnapshot"
            }
        }
        registerCreateDbClusterSnapshotMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new instance.
     */
    override suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse {
        val op = SdkHttpOperation.build<CreateDbInstanceRequest, CreateDbInstanceResponse> {
            serializer = CreateDBInstanceOperationSerializer()
            deserializer = CreateDBInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDBInstance"
            }
        }
        registerCreateDbInstanceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new subnet group. subnet groups must contain at least one subnet in at
     * least two Availability Zones in the Region.
     */
    override suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse {
        val op = SdkHttpOperation.build<CreateDbSubnetGroupRequest, CreateDbSubnetGroupResponse> {
            serializer = CreateDBSubnetGroupOperationSerializer()
            deserializer = CreateDBSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDBSubnetGroup"
            }
        }
        registerCreateDbSubnetGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DocumentDB event notification subscription. This action requires a topic Amazon Resource Name (ARN) created by using the Amazon DocumentDB console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the Amazon SNS console.
     * You can specify the type of source (SourceType) that you want to be notified of. You can also provide a list of Amazon DocumentDB sources (SourceIds) that trigger the events, and you can provide a list of event categories (EventCategories) for events that you want to be notified of. For example, you can specify SourceType = db-instance, SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup.
     * If you specify both the SourceType and SourceIds (such as SourceType = db-instance and SourceIdentifier = myDBInstance1), you are notified of all the db-instance events for the specified source. If you specify a SourceType but do not specify a SourceIdentifier, you receive notice of the events for that source type for all your Amazon DocumentDB sources. If you do not specify either the SourceType or the SourceIdentifier, you are notified of events generated from all Amazon DocumentDB sources belonging to your customer account.
     */
    override suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse> {
            serializer = CreateEventSubscriptionOperationSerializer()
            deserializer = CreateEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEventSubscription"
            }
        }
        registerCreateEventSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon DocumentDB global cluster that can span multiple multiple Regions. The global cluster contains one primary cluster with read-write capability, and up-to give read-only secondary clusters. Global clusters uses storage-based fast replication across regions with latencies less than one second, using dedicated infrastructure with no impact to your workload’s performance.
     * You can create a global cluster that is initially empty, and then add a primary and a secondary to it. Or you can specify an existing cluster during the create operation, and this cluster becomes the primary of the global cluster.
     * This action only applies to Amazon DocumentDB clusters.
     */
    override suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse {
        val op = SdkHttpOperation.build<CreateGlobalClusterRequest, CreateGlobalClusterResponse> {
            serializer = CreateGlobalClusterOperationSerializer()
            deserializer = CreateGlobalClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGlobalCluster"
            }
        }
        registerCreateGlobalClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a previously provisioned cluster. When you delete a cluster, all automated backups for that cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified cluster are not deleted.
     */
    override suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterRequest, DeleteDbClusterResponse> {
            serializer = DeleteDBClusterOperationSerializer()
            deserializer = DeleteDBClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDBCluster"
            }
        }
        registerDeleteDbClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified cluster parameter group. The cluster parameter group to be deleted can't be associated with any clusters.
     */
    override suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterParameterGroupRequest, DeleteDbClusterParameterGroupResponse> {
            serializer = DeleteDBClusterParameterGroupOperationSerializer()
            deserializer = DeleteDBClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDBClusterParameterGroup"
            }
        }
        registerDeleteDbClusterParameterGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * The cluster snapshot must be in the available state to be deleted.
     */
    override suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse {
        val op = SdkHttpOperation.build<DeleteDbClusterSnapshotRequest, DeleteDbClusterSnapshotResponse> {
            serializer = DeleteDBClusterSnapshotOperationSerializer()
            deserializer = DeleteDBClusterSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDBClusterSnapshot"
            }
        }
        registerDeleteDbClusterSnapshotMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a previously provisioned instance.
     */
    override suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse {
        val op = SdkHttpOperation.build<DeleteDbInstanceRequest, DeleteDbInstanceResponse> {
            serializer = DeleteDBInstanceOperationSerializer()
            deserializer = DeleteDBInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDBInstance"
            }
        }
        registerDeleteDbInstanceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a subnet group.
     * The specified database subnet group must not be associated with any DB
     * instances.
     */
    override suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse {
        val op = SdkHttpOperation.build<DeleteDbSubnetGroupRequest, DeleteDbSubnetGroupResponse> {
            serializer = DeleteDBSubnetGroupOperationSerializer()
            deserializer = DeleteDBSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDBSubnetGroup"
            }
        }
        registerDeleteDbSubnetGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Amazon DocumentDB event notification subscription.
     */
    override suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse {
        val op = SdkHttpOperation.build<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse> {
            serializer = DeleteEventSubscriptionOperationSerializer()
            deserializer = DeleteEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEventSubscription"
            }
        }
        registerDeleteEventSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a global cluster. The primary and secondary clusters must already be detached or deleted before attempting to delete a global cluster.
     * This action only applies to Amazon DocumentDB clusters.
     */
    override suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse {
        val op = SdkHttpOperation.build<DeleteGlobalClusterRequest, DeleteGlobalClusterResponse> {
            serializer = DeleteGlobalClusterOperationSerializer()
            deserializer = DeleteGlobalClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGlobalCluster"
            }
        }
        registerDeleteGlobalClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this account.
     */
    override suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse {
        val op = SdkHttpOperation.build<DescribeCertificatesRequest, DescribeCertificatesResponse> {
            serializer = DescribeCertificatesOperationSerializer()
            deserializer = DescribeCertificatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCertificates"
            }
        }
        registerDescribeCertificatesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName parameter is specified, the list contains only the description of the specified cluster parameter group.
     */
    override suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest): DescribeDbClusterParameterGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterParameterGroupsRequest, DescribeDbClusterParameterGroupsResponse> {
            serializer = DescribeDBClusterParameterGroupsOperationSerializer()
            deserializer = DescribeDBClusterParameterGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBClusterParameterGroups"
            }
        }
        registerDescribeDbClusterParameterGroupsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the detailed parameter list for a particular cluster parameter
     * group.
     */
    override suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterParametersRequest, DescribeDbClusterParametersResponse> {
            serializer = DescribeDBClusterParametersOperationSerializer()
            deserializer = DescribeDBClusterParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBClusterParameters"
            }
        }
        registerDescribeDbClusterParametersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of cluster snapshot attribute names and values for a manual DB
     * cluster snapshot.
     * When you share snapshots with other accounts,
     * DescribeDBClusterSnapshotAttributes returns the restore attribute and a list of IDs for the accounts that are authorized to copy or restore the manual cluster snapshot. If all is included in the list of values for the restore attribute, then the manual cluster snapshot is public and can be copied or restored by all accounts.
     */
    override suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterSnapshotAttributesRequest, DescribeDbClusterSnapshotAttributesResponse> {
            serializer = DescribeDBClusterSnapshotAttributesOperationSerializer()
            deserializer = DescribeDBClusterSnapshotAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBClusterSnapshotAttributes"
            }
        }
        registerDescribeDbClusterSnapshotAttributesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about cluster snapshots. This API operation supports pagination.
     */
    override suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest): DescribeDbClusterSnapshotsResponse {
        val op = SdkHttpOperation.build<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse> {
            serializer = DescribeDBClusterSnapshotsOperationSerializer()
            deserializer = DescribeDBClusterSnapshotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBClusterSnapshots"
            }
        }
        registerDescribeDbClusterSnapshotsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about provisioned Amazon DocumentDB clusters. This API
     * operation supports pagination. For certain management features
     * such as cluster and instance lifecycle management, Amazon DocumentDB leverages
     * operational technology that is shared with Amazon RDS and Amazon
     * Neptune. Use the filterName=engine,Values=docdb filter
     * parameter to return only Amazon DocumentDB clusters.
     */
    override suspend fun describeDbClusters(input: DescribeDbClustersRequest): DescribeDbClustersResponse {
        val op = SdkHttpOperation.build<DescribeDbClustersRequest, DescribeDbClustersResponse> {
            serializer = DescribeDBClustersOperationSerializer()
            deserializer = DescribeDBClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBClusters"
            }
        }
        registerDescribeDbClustersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the available engines.
     */
    override suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest): DescribeDbEngineVersionsResponse {
        val op = SdkHttpOperation.build<DescribeDbEngineVersionsRequest, DescribeDbEngineVersionsResponse> {
            serializer = DescribeDBEngineVersionsOperationSerializer()
            deserializer = DescribeDBEngineVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBEngineVersions"
            }
        }
        registerDescribeDbEngineVersionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about provisioned Amazon DocumentDB instances. This API supports pagination.
     */
    override suspend fun describeDbInstances(input: DescribeDbInstancesRequest): DescribeDbInstancesResponse {
        val op = SdkHttpOperation.build<DescribeDbInstancesRequest, DescribeDbInstancesResponse> {
            serializer = DescribeDBInstancesOperationSerializer()
            deserializer = DescribeDBInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBInstances"
            }
        }
        registerDescribeDbInstancesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of DBSubnetGroup descriptions. If a
     * DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     */
    override suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest): DescribeDbSubnetGroupsResponse {
        val op = SdkHttpOperation.build<DescribeDbSubnetGroupsRequest, DescribeDbSubnetGroupsResponse> {
            serializer = DescribeDBSubnetGroupsOperationSerializer()
            deserializer = DescribeDBSubnetGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDBSubnetGroups"
            }
        }
        registerDescribeDbSubnetGroupsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the default engine and system parameter information for the cluster database
     * engine.
     */
    override suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse {
        val op = SdkHttpOperation.build<DescribeEngineDefaultClusterParametersRequest, DescribeEngineDefaultClusterParametersResponse> {
            serializer = DescribeEngineDefaultClusterParametersOperationSerializer()
            deserializer = DescribeEngineDefaultClusterParametersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEngineDefaultClusterParameters"
            }
        }
        registerDescribeEngineDefaultClusterParametersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Displays a list of categories for all event source types, or, if specified, for a
     * specified source type.
     */
    override suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse {
        val op = SdkHttpOperation.build<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse> {
            serializer = DescribeEventCategoriesOperationSerializer()
            deserializer = DescribeEventCategoriesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventCategories"
            }
        }
        registerDescribeEventCategoriesMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * If you specify a SubscriptionName, lists the description for that subscription.
     */
    override suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse> {
            serializer = DescribeEventSubscriptionsOperationSerializer()
            deserializer = DescribeEventSubscriptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventSubscriptions"
            }
        }
        registerDescribeEventSubscriptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days. You can obtain events specific to a particular DB instance, security group, snapshot, or parameter group by providing the name as a parameter. By default, the events of the past hour are returned.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        registerDescribeEventsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about Amazon DocumentDB global  clusters. This API supports pagination.
     * This action only applies to Amazon DocumentDB clusters.
     */
    override suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest): DescribeGlobalClustersResponse {
        val op = SdkHttpOperation.build<DescribeGlobalClustersRequest, DescribeGlobalClustersResponse> {
            serializer = DescribeGlobalClustersOperationSerializer()
            deserializer = DescribeGlobalClustersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGlobalClusters"
            }
        }
        registerDescribeGlobalClustersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of orderable instance options for the specified engine.
     */
    override suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse {
        val op = SdkHttpOperation.build<DescribeOrderableDbInstanceOptionsRequest, DescribeOrderableDbInstanceOptionsResponse> {
            serializer = DescribeOrderableDBInstanceOptionsOperationSerializer()
            deserializer = DescribeOrderableDBInstanceOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrderableDBInstanceOptions"
            }
        }
        registerDescribeOrderableDbInstanceOptionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of resources (for example, instances) that have at least one pending
     * maintenance action.
     */
    override suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse {
        val op = SdkHttpOperation.build<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse> {
            serializer = DescribePendingMaintenanceActionsOperationSerializer()
            deserializer = DescribePendingMaintenanceActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePendingMaintenanceActions"
            }
        }
        registerDescribePendingMaintenanceActionsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Forces a failover for a cluster.
     * A failover for a cluster promotes one of the Amazon DocumentDB replicas (read-only instances) in the cluster to be the primary instance (the cluster writer).
     * If the primary instance fails, Amazon DocumentDB automatically fails over to an Amazon DocumentDB replica, if one exists. You can force a failover when you want to simulate a failure of a primary instance for testing.
     */
    override suspend fun failoverDbCluster(input: FailoverDbClusterRequest): FailoverDbClusterResponse {
        val op = SdkHttpOperation.build<FailoverDbClusterRequest, FailoverDbClusterResponse> {
            serializer = FailoverDBClusterOperationSerializer()
            deserializer = FailoverDBClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "FailoverDBCluster"
            }
        }
        registerFailoverDbClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags on an Amazon DocumentDB resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies a setting for an Amazon DocumentDB cluster. You can change one or more database
     * configuration parameters by specifying these parameters and the new values in the
     * request.
     */
    override suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterRequest, ModifyDbClusterResponse> {
            serializer = ModifyDBClusterOperationSerializer()
            deserializer = ModifyDBClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyDBCluster"
            }
        }
        registerModifyDbClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a cluster parameter group. To modify more than one
     * parameter, submit a list of the following: ParameterName,
     * ParameterValue, and ApplyMethod. A maximum of 20
     * parameters can be modified in a single request.
     * Changes to dynamic parameters are applied immediately. Changes to static
     * parameters require a reboot or maintenance window
     * before the change can take effect.
     * After you create a cluster parameter group, you should wait at least 5 minutes
     * before creating your first cluster that uses that cluster parameter group as
     * the default parameter group. This allows Amazon DocumentDB to fully complete the create action
     * before the parameter group is used as the default for a new cluster. This step is
     * especially important for parameters that are critical when creating the default
     * database for a cluster, such as the character set for the default database
     * defined by the character_set_database parameter.
     */
    override suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterParameterGroupRequest, ModifyDbClusterParameterGroupResponse> {
            serializer = ModifyDBClusterParameterGroupOperationSerializer()
            deserializer = ModifyDBClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyDBClusterParameterGroup"
            }
        }
        registerModifyDbClusterParameterGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual cluster snapshot.
     * To share a manual cluster snapshot with other accounts, specify restore as the AttributeName, and use the ValuesToAdd parameter to add a list of IDs of the accounts that are authorized to restore the manual cluster snapshot. Use the value all to make the manual cluster snapshot public, which means that it can be copied or restored by all accounts. Do not add the all value for any manual cluster snapshots that contain private information that you don't want available to all accounts. If a manual cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized account IDs for the ValuesToAdd parameter. You can't use all as a value for that parameter in this case.
     */
    override suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse {
        val op = SdkHttpOperation.build<ModifyDbClusterSnapshotAttributeRequest, ModifyDbClusterSnapshotAttributeResponse> {
            serializer = ModifyDBClusterSnapshotAttributeOperationSerializer()
            deserializer = ModifyDBClusterSnapshotAttributeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyDBClusterSnapshotAttribute"
            }
        }
        registerModifyDbClusterSnapshotAttributeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies settings for an instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     */
    override suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse {
        val op = SdkHttpOperation.build<ModifyDbInstanceRequest, ModifyDbInstanceResponse> {
            serializer = ModifyDBInstanceOperationSerializer()
            deserializer = ModifyDBInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyDBInstance"
            }
        }
        registerModifyDbInstanceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing subnet group. subnet groups must contain at least one subnet in at least two Availability Zones in the Region.
     */
    override suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse {
        val op = SdkHttpOperation.build<ModifyDbSubnetGroupRequest, ModifyDbSubnetGroupResponse> {
            serializer = ModifyDBSubnetGroupOperationSerializer()
            deserializer = ModifyDBSubnetGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyDBSubnetGroup"
            }
        }
        registerModifyDbSubnetGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies an existing Amazon DocumentDB event notification subscription.
     */
    override suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse {
        val op = SdkHttpOperation.build<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse> {
            serializer = ModifyEventSubscriptionOperationSerializer()
            deserializer = ModifyEventSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyEventSubscription"
            }
        }
        registerModifyEventSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modify a setting for an Amazon DocumentDB global cluster. You can change one or more configuration parameters (for example: deletion protection), or the global cluster identifier by specifying these parameters and the new values in the request.
     * This action only applies to Amazon DocumentDB clusters.
     */
    override suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse {
        val op = SdkHttpOperation.build<ModifyGlobalClusterRequest, ModifyGlobalClusterResponse> {
            serializer = ModifyGlobalClusterOperationSerializer()
            deserializer = ModifyGlobalClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyGlobalCluster"
            }
        }
        registerModifyGlobalClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * You might need to reboot your instance, usually for maintenance reasons. For
     * example, if you make certain changes, or if you change the cluster parameter group
     * that is associated with the instance, you must reboot the instance for the changes to
     * take effect.
     * Rebooting an instance restarts the database engine service. Rebooting an instance
     * results in a momentary outage, during which the instance status is set to
     * rebooting.
     */
    override suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse {
        val op = SdkHttpOperation.build<RebootDbInstanceRequest, RebootDbInstanceResponse> {
            serializer = RebootDBInstanceOperationSerializer()
            deserializer = RebootDBInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebootDBInstance"
            }
        }
        registerRebootDbInstanceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches an Amazon DocumentDB secondary cluster from a global cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary in a different region.
     * This action only applies to Amazon DocumentDB clusters.
     */
    override suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse {
        val op = SdkHttpOperation.build<RemoveFromGlobalClusterRequest, RemoveFromGlobalClusterResponse> {
            serializer = RemoveFromGlobalClusterOperationSerializer()
            deserializer = RemoveFromGlobalClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveFromGlobalCluster"
            }
        }
        registerRemoveFromGlobalClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a source identifier from an existing Amazon DocumentDB event notification
     * subscription.
     */
    override suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse {
        val op = SdkHttpOperation.build<RemoveSourceIdentifierFromSubscriptionRequest, RemoveSourceIdentifierFromSubscriptionResponse> {
            serializer = RemoveSourceIdentifierFromSubscriptionOperationSerializer()
            deserializer = RemoveSourceIdentifierFromSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveSourceIdentifierFromSubscription"
            }
        }
        registerRemoveSourceIdentifierFromSubscriptionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from an Amazon DocumentDB resource.
     */
    override suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse {
        val op = SdkHttpOperation.build<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse> {
            serializer = RemoveTagsFromResourceOperationSerializer()
            deserializer = RemoveTagsFromResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTagsFromResource"
            }
        }
        registerRemoveTagsFromResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the parameters of a cluster parameter group to the default value. To
     * reset specific parameters, submit a list of the following: ParameterName
     * and ApplyMethod. To reset the entire cluster parameter group, specify
     * the DBClusterParameterGroupName and ResetAllParameters
     * parameters.
     * When you reset the entire group, dynamic parameters are updated immediately and
     * static parameters are set to pending-reboot to take effect on the next DB
     * instance reboot.
     */
    override suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse {
        val op = SdkHttpOperation.build<ResetDbClusterParameterGroupRequest, ResetDbClusterParameterGroupResponse> {
            serializer = ResetDBClusterParameterGroupOperationSerializer()
            deserializer = ResetDBClusterParameterGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResetDBClusterParameterGroup"
            }
        }
        registerResetDbClusterParameterGroupMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new cluster from a snapshot or cluster snapshot.
     * If a snapshot is specified, the target cluster is created from the source DB snapshot with a default configuration and default security group.
     * If a cluster snapshot is specified, the target cluster is created from the source cluster restore point with the same configuration as the original source DB cluster, except that the new cluster is created with the default security group.
     */
    override suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse {
        val op = SdkHttpOperation.build<RestoreDbClusterFromSnapshotRequest, RestoreDbClusterFromSnapshotResponse> {
            serializer = RestoreDBClusterFromSnapshotOperationSerializer()
            deserializer = RestoreDBClusterFromSnapshotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreDBClusterFromSnapshot"
            }
        }
        registerRestoreDbClusterFromSnapshotMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Restores a cluster to an arbitrary point in time. Users can restore to any point in
     * time before LatestRestorableTime for up to
     * BackupRetentionPeriod days. The target cluster is created from the
     * source cluster with the same configuration as the original cluster, except that
     * the new cluster is created with the default security group.
     */
    override suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse {
        val op = SdkHttpOperation.build<RestoreDbClusterToPointInTimeRequest, RestoreDbClusterToPointInTimeResponse> {
            serializer = RestoreDBClusterToPointInTimeOperationSerializer()
            deserializer = RestoreDBClusterToPointInTimeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreDBClusterToPointInTime"
            }
        }
        registerRestoreDbClusterToPointInTimeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Restarts the stopped cluster that is specified by DBClusterIdentifier.
     * For more information, see <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster.
     */
    override suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse {
        val op = SdkHttpOperation.build<StartDbClusterRequest, StartDbClusterResponse> {
            serializer = StartDBClusterOperationSerializer()
            deserializer = StartDBClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDBCluster"
            }
        }
        registerStartDbClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Stops the running cluster that is specified by DBClusterIdentifier. The
     * cluster must be in the available state. For more information, see
     * <a href="https://docs.aws.amazon.com/documentdb/latest/developerguide/db-cluster-stop-start.html">Stopping and
     * Starting an Amazon DocumentDB Cluster.
     */
    override suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse {
        val op = SdkHttpOperation.build<StopDbClusterRequest, StopDbClusterResponse> {
            serializer = StopDBClusterOperationSerializer()
            deserializer = StopDBClusterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopDBCluster"
            }
        }
        registerStopDbClusterMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
