// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateLifecyclePolicyRequest private constructor(builder: Builder) {
    /**
     * **&#91;Default policies only&#93;** Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * **&#91;Default policies only&#93;** Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days.
     */
    public val createInterval: kotlin.Int? = builder.createInterval
    /**
     * **&#91;Default policies only&#93;** Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
     */
    public val crossRegionCopyTargets: List<CrossRegionCopyTarget>? = builder.crossRegionCopyTargets
    /**
     * A description of the lifecycle policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * **&#91;Default policies only&#93;** Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
     */
    public val exclusions: aws.sdk.kotlin.services.dlm.model.Exclusions? = builder.exclusions
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * **&#91;Default policies only&#93;** Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     *
     * By default (**ExtendDeletion=false**):
     * + If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify `true`.
     * + If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify `true`.
     *
     * If you enable extended deletion (**ExtendDeletion=true**), you override both default behaviors simultaneously.
     *
     * Default: false
     */
    public val extendDeletion: kotlin.Boolean? = builder.extendDeletion
    /**
     * The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
     */
    public val policyDetails: aws.sdk.kotlin.services.dlm.model.PolicyDetails? = builder.policyDetails
    /**
     * The identifier of the lifecycle policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * **&#91;Default policies only&#93;** Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time.
     */
    public val retainInterval: kotlin.Int? = builder.retainInterval
    /**
     * The desired activation state of the lifecycle policy after creation.
     */
    public val state: aws.sdk.kotlin.services.dlm.model.SettablePolicyStateValues? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.UpdateLifecyclePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLifecyclePolicyRequest(")
        append("copyTags=$copyTags,")
        append("createInterval=$createInterval,")
        append("crossRegionCopyTargets=$crossRegionCopyTargets,")
        append("description=$description,")
        append("exclusions=$exclusions,")
        append("executionRoleArn=$executionRoleArn,")
        append("extendDeletion=$extendDeletion,")
        append("policyDetails=$policyDetails,")
        append("policyId=$policyId,")
        append("retainInterval=$retainInterval,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (createInterval ?: 0)
        result = 31 * result + (crossRegionCopyTargets?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (exclusions?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (extendDeletion?.hashCode() ?: 0)
        result = 31 * result + (policyDetails?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (retainInterval ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLifecyclePolicyRequest

        if (copyTags != other.copyTags) return false
        if (createInterval != other.createInterval) return false
        if (crossRegionCopyTargets != other.crossRegionCopyTargets) return false
        if (description != other.description) return false
        if (exclusions != other.exclusions) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (extendDeletion != other.extendDeletion) return false
        if (policyDetails != other.policyDetails) return false
        if (policyId != other.policyId) return false
        if (retainInterval != other.retainInterval) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.UpdateLifecyclePolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * **&#91;Default policies only&#93;** Indicates whether the policy should copy tags from the source resource to the snapshot or AMI.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * **&#91;Default policies only&#93;** Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days.
         */
        public var createInterval: kotlin.Int? = null
        /**
         * **&#91;Default policies only&#93;** Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         */
        public var crossRegionCopyTargets: List<CrossRegionCopyTarget>? = null
        /**
         * A description of the lifecycle policy.
         */
        public var description: kotlin.String? = null
        /**
         * **&#91;Default policies only&#93;** Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         */
        public var exclusions: aws.sdk.kotlin.services.dlm.model.Exclusions? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * **&#91;Default policies only&#93;** Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         *
         * By default (**ExtendDeletion=false**):
         * + If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify `true`.
         * + If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify `true`.
         *
         * If you enable extended deletion (**ExtendDeletion=true**), you override both default behaviors simultaneously.
         *
         * Default: false
         */
        public var extendDeletion: kotlin.Boolean? = null
        /**
         * The configuration of the lifecycle policy. You cannot update the policy type or the resource type.
         */
        public var policyDetails: aws.sdk.kotlin.services.dlm.model.PolicyDetails? = null
        /**
         * The identifier of the lifecycle policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * **&#91;Default policies only&#93;** Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time.
         */
        public var retainInterval: kotlin.Int? = null
        /**
         * The desired activation state of the lifecycle policy after creation.
         */
        public var state: aws.sdk.kotlin.services.dlm.model.SettablePolicyStateValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.UpdateLifecyclePolicyRequest) : this() {
            this.copyTags = x.copyTags
            this.createInterval = x.createInterval
            this.crossRegionCopyTargets = x.crossRegionCopyTargets
            this.description = x.description
            this.exclusions = x.exclusions
            this.executionRoleArn = x.executionRoleArn
            this.extendDeletion = x.extendDeletion
            this.policyDetails = x.policyDetails
            this.policyId = x.policyId
            this.retainInterval = x.retainInterval
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.UpdateLifecyclePolicyRequest = UpdateLifecyclePolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.Exclusions] inside the given [block]
         */
        public fun exclusions(block: aws.sdk.kotlin.services.dlm.model.Exclusions.Builder.() -> kotlin.Unit) {
            this.exclusions = aws.sdk.kotlin.services.dlm.model.Exclusions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.PolicyDetails] inside the given [block]
         */
        public fun policyDetails(block: aws.sdk.kotlin.services.dlm.model.PolicyDetails.Builder.() -> kotlin.Unit) {
            this.policyDetails = aws.sdk.kotlin.services.dlm.model.PolicyDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
