// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **&#91;Custom snapshot and AMI policies only&#93;** Specifies a schedule for a snapshot or AMI lifecycle policy.
 */
public class Schedule private constructor(builder: Builder) {
    /**
     * **&#91;Custom snapshot policies that target volumes only&#93;** The snapshot archiving rule for the schedule. When you specify an archiving rule, snapshots are automatically moved from the standard tier to the archive tier once the schedule's retention threshold is met. Snapshots are then retained in the archive tier for the archive retention period that you specify.
     *
     * For more information about using snapshot archiving, see [Considerations for snapshot lifecycle policies](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive).
     */
    public val archiveRule: aws.sdk.kotlin.services.dlm.model.ArchiveRule? = builder.archiveRule
    /**
     * Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The creation rule.
     */
    public val createRule: aws.sdk.kotlin.services.dlm.model.CreateRule? = builder.createRule
    /**
     * Specifies a rule for copying snapshots or AMIs across regions.
     *
     * You can't specify cross-Region copy rules for policies that create snapshots on an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
     */
    public val crossRegionCopyRules: List<CrossRegionCopyRule>? = builder.crossRegionCopyRules
    /**
     * **&#91;Custom AMI policies only&#93;** The AMI deprecation rule for the schedule.
     */
    public val deprecateRule: aws.sdk.kotlin.services.dlm.model.DeprecateRule? = builder.deprecateRule
    /**
     * **&#91;Custom snapshot policies only&#93;** The rule for enabling fast snapshot restore.
     */
    public val fastRestoreRule: aws.sdk.kotlin.services.dlm.model.FastRestoreRule? = builder.fastRestoreRule
    /**
     * The name of the schedule.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The retention rule for snapshots or AMIs created by the policy.
     */
    public val retainRule: aws.sdk.kotlin.services.dlm.model.RetainRule? = builder.retainRule
    /**
     * **&#91;Custom snapshot policies only&#93;** The rule for sharing snapshots with other Amazon Web Services accounts.
     */
    public val shareRules: List<ShareRule>? = builder.shareRules
    /**
     * The tags to apply to policy-created resources. These user-defined tags are in addition to the Amazon Web Services-added lifecycle tags.
     */
    public val tagsToAdd: List<Tag>? = builder.tagsToAdd
    /**
     * **&#91;AMI policies and snapshot policies that target instances only&#93;** A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: `$(instance-id)` or `$(timestamp)`. Variable tags are only valid for EBS Snapshot Management – Instance policies.
     */
    public val variableTags: List<Tag>? = builder.variableTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.Schedule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Schedule(")
        append("archiveRule=$archiveRule,")
        append("copyTags=$copyTags,")
        append("createRule=$createRule,")
        append("crossRegionCopyRules=$crossRegionCopyRules,")
        append("deprecateRule=$deprecateRule,")
        append("fastRestoreRule=$fastRestoreRule,")
        append("name=$name,")
        append("retainRule=$retainRule,")
        append("shareRules=$shareRules,")
        append("tagsToAdd=$tagsToAdd,")
        append("variableTags=$variableTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archiveRule?.hashCode() ?: 0
        result = 31 * result + (copyTags?.hashCode() ?: 0)
        result = 31 * result + (createRule?.hashCode() ?: 0)
        result = 31 * result + (crossRegionCopyRules?.hashCode() ?: 0)
        result = 31 * result + (deprecateRule?.hashCode() ?: 0)
        result = 31 * result + (fastRestoreRule?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retainRule?.hashCode() ?: 0)
        result = 31 * result + (shareRules?.hashCode() ?: 0)
        result = 31 * result + (tagsToAdd?.hashCode() ?: 0)
        result = 31 * result + (variableTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Schedule

        if (archiveRule != other.archiveRule) return false
        if (copyTags != other.copyTags) return false
        if (createRule != other.createRule) return false
        if (crossRegionCopyRules != other.crossRegionCopyRules) return false
        if (deprecateRule != other.deprecateRule) return false
        if (fastRestoreRule != other.fastRestoreRule) return false
        if (name != other.name) return false
        if (retainRule != other.retainRule) return false
        if (shareRules != other.shareRules) return false
        if (tagsToAdd != other.tagsToAdd) return false
        if (variableTags != other.variableTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.Schedule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * **&#91;Custom snapshot policies that target volumes only&#93;** The snapshot archiving rule for the schedule. When you specify an archiving rule, snapshots are automatically moved from the standard tier to the archive tier once the schedule's retention threshold is met. Snapshots are then retained in the archive tier for the archive retention period that you specify.
         *
         * For more information about using snapshot archiving, see [Considerations for snapshot lifecycle policies](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive).
         */
        public var archiveRule: aws.sdk.kotlin.services.dlm.model.ArchiveRule? = null
        /**
         * Copy all user-defined tags on a source volume to snapshots of the volume created by this policy.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * The creation rule.
         */
        public var createRule: aws.sdk.kotlin.services.dlm.model.CreateRule? = null
        /**
         * Specifies a rule for copying snapshots or AMIs across regions.
         *
         * You can't specify cross-Region copy rules for policies that create snapshots on an Outpost. If the policy creates snapshots in a Region, then snapshots can be copied to up to three Regions or Outposts.
         */
        public var crossRegionCopyRules: List<CrossRegionCopyRule>? = null
        /**
         * **&#91;Custom AMI policies only&#93;** The AMI deprecation rule for the schedule.
         */
        public var deprecateRule: aws.sdk.kotlin.services.dlm.model.DeprecateRule? = null
        /**
         * **&#91;Custom snapshot policies only&#93;** The rule for enabling fast snapshot restore.
         */
        public var fastRestoreRule: aws.sdk.kotlin.services.dlm.model.FastRestoreRule? = null
        /**
         * The name of the schedule.
         */
        public var name: kotlin.String? = null
        /**
         * The retention rule for snapshots or AMIs created by the policy.
         */
        public var retainRule: aws.sdk.kotlin.services.dlm.model.RetainRule? = null
        /**
         * **&#91;Custom snapshot policies only&#93;** The rule for sharing snapshots with other Amazon Web Services accounts.
         */
        public var shareRules: List<ShareRule>? = null
        /**
         * The tags to apply to policy-created resources. These user-defined tags are in addition to the Amazon Web Services-added lifecycle tags.
         */
        public var tagsToAdd: List<Tag>? = null
        /**
         * **&#91;AMI policies and snapshot policies that target instances only&#93;** A collection of key/value pairs with values determined dynamically when the policy is executed. Keys may be any valid Amazon EC2 tag key. Values must be in one of the two following formats: `$(instance-id)` or `$(timestamp)`. Variable tags are only valid for EBS Snapshot Management – Instance policies.
         */
        public var variableTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.Schedule) : this() {
            this.archiveRule = x.archiveRule
            this.copyTags = x.copyTags
            this.createRule = x.createRule
            this.crossRegionCopyRules = x.crossRegionCopyRules
            this.deprecateRule = x.deprecateRule
            this.fastRestoreRule = x.fastRestoreRule
            this.name = x.name
            this.retainRule = x.retainRule
            this.shareRules = x.shareRules
            this.tagsToAdd = x.tagsToAdd
            this.variableTags = x.variableTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.Schedule = Schedule(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.ArchiveRule] inside the given [block]
         */
        public fun archiveRule(block: aws.sdk.kotlin.services.dlm.model.ArchiveRule.Builder.() -> kotlin.Unit) {
            this.archiveRule = aws.sdk.kotlin.services.dlm.model.ArchiveRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.CreateRule] inside the given [block]
         */
        public fun createRule(block: aws.sdk.kotlin.services.dlm.model.CreateRule.Builder.() -> kotlin.Unit) {
            this.createRule = aws.sdk.kotlin.services.dlm.model.CreateRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.DeprecateRule] inside the given [block]
         */
        public fun deprecateRule(block: aws.sdk.kotlin.services.dlm.model.DeprecateRule.Builder.() -> kotlin.Unit) {
            this.deprecateRule = aws.sdk.kotlin.services.dlm.model.DeprecateRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.FastRestoreRule] inside the given [block]
         */
        public fun fastRestoreRule(block: aws.sdk.kotlin.services.dlm.model.FastRestoreRule.Builder.() -> kotlin.Unit) {
            this.fastRestoreRule = aws.sdk.kotlin.services.dlm.model.FastRestoreRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.RetainRule] inside the given [block]
         */
        public fun retainRule(block: aws.sdk.kotlin.services.dlm.model.RetainRule.Builder.() -> kotlin.Unit) {
            this.retainRule = aws.sdk.kotlin.services.dlm.model.RetainRule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
