// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **&#91;Custom snapshot policies only&#93;** Describes the retention rule for archived snapshots. Once the archive retention threshold is met, the snapshots are permanently deleted from the archive tier.
 *
 * The archive retention rule must retain snapshots in the archive tier for a minimum of 90 days.
 *
 * For **count-based schedules**, you must specify **Count**. For **age-based schedules**, you must specify **Interval** and ** IntervalUnit**.
 *
 * For more information about using snapshot archiving, see [Considerations for snapshot lifecycle policies](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-ami-policy.html#dlm-archive).
 */
public class RetentionArchiveTier private constructor(builder: Builder) {
    /**
     * The maximum number of snapshots to retain in the archive storage tier for each volume. The count must ensure that each snapshot remains in the archive tier for at least 90 days. For example, if the schedule creates snapshots every 30 days, you must specify a count of 3 or more to ensure that each snapshot is archived for at least 90 days.
     */
    public val count: kotlin.Int? = builder.count
    /**
     * Specifies the period of time to retain snapshots in the archive tier. After this period expires, the snapshot is permanently deleted.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The unit of time in which to measure the **Interval**. For example, to retain a snapshots in the archive tier for 6 months, specify `Interval=6` and `IntervalUnit=MONTHS`.
     */
    public val intervalUnit: aws.sdk.kotlin.services.dlm.model.RetentionIntervalUnitValues? = builder.intervalUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.RetentionArchiveTier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetentionArchiveTier(")
        append("count=$count,")
        append("interval=$interval,")
        append("intervalUnit=$intervalUnit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = count ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (intervalUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetentionArchiveTier

        if (count != other.count) return false
        if (interval != other.interval) return false
        if (intervalUnit != other.intervalUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.RetentionArchiveTier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of snapshots to retain in the archive storage tier for each volume. The count must ensure that each snapshot remains in the archive tier for at least 90 days. For example, if the schedule creates snapshots every 30 days, you must specify a count of 3 or more to ensure that each snapshot is archived for at least 90 days.
         */
        public var count: kotlin.Int? = null
        /**
         * Specifies the period of time to retain snapshots in the archive tier. After this period expires, the snapshot is permanently deleted.
         */
        public var interval: kotlin.Int? = null
        /**
         * The unit of time in which to measure the **Interval**. For example, to retain a snapshots in the archive tier for 6 months, specify `Interval=6` and `IntervalUnit=MONTHS`.
         */
        public var intervalUnit: aws.sdk.kotlin.services.dlm.model.RetentionIntervalUnitValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.RetentionArchiveTier) : this() {
            this.count = x.count
            this.interval = x.interval
            this.intervalUnit = x.intervalUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.RetentionArchiveTier = RetentionArchiveTier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
