// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **&#91;Custom snapshot and AMI policies only&#93;** Specifies a retention rule for snapshots created by snapshot policies, or for AMIs created by AMI policies.
 *
 * For snapshot policies that have an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html), this retention rule applies to standard tier retention. When the retention threshold is met, snapshots are moved from the standard to the archive tier.
 *
 * For snapshot policies that do not have an **ArchiveRule**, snapshots are permanently deleted when this retention threshold is met.
 *
 * You can retain snapshots based on either a count or a time interval.
 * + **Count-based retention**You must specify **Count**. If you specify an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html) for the schedule, then you can specify a retention count of `0` to archive snapshots immediately after creation. If you specify a [FastRestoreRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_FastRestoreRule.html), [ShareRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ShareRule.html), or a [CrossRegionCopyRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html), then you must specify a retention count of `1` or more.
 * + **Age-based retention**You must specify **Interval** and **IntervalUnit**. If you specify an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html) for the schedule, then you can specify a retention interval of `0` days to archive snapshots immediately after creation. If you specify a [FastRestoreRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_FastRestoreRule.html), [ShareRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ShareRule.html), or a [CrossRegionCopyRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyRule.html), then you must specify a retention interval of `1` day or more.
 */
public class RetainRule private constructor(builder: Builder) {
    /**
     * The number of snapshots to retain for each volume, up to a maximum of 1000. For example if you want to retain a maximum of three snapshots, specify `3`. When the fourth snapshot is created, the oldest retained snapshot is deleted, or it is moved to the archive tier if you have specified an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html).
     */
    public val count: kotlin.Int? = builder.count
    /**
     * The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The unit of time for time-based retention. For example, to retain snapshots for 3 months, specify `Interval=3` and `IntervalUnit=MONTHS`. Once the snapshot has been retained for 3 months, it is deleted, or it is moved to the archive tier if you have specified an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html).
     */
    public val intervalUnit: aws.sdk.kotlin.services.dlm.model.RetentionIntervalUnitValues? = builder.intervalUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.RetainRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetainRule(")
        append("count=$count,")
        append("interval=$interval,")
        append("intervalUnit=$intervalUnit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = count ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (intervalUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetainRule

        if (count != other.count) return false
        if (interval != other.interval) return false
        if (intervalUnit != other.intervalUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.RetainRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of snapshots to retain for each volume, up to a maximum of 1000. For example if you want to retain a maximum of three snapshots, specify `3`. When the fourth snapshot is created, the oldest retained snapshot is deleted, or it is moved to the archive tier if you have specified an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html).
         */
        public var count: kotlin.Int? = null
        /**
         * The amount of time to retain each snapshot. The maximum is 100 years. This is equivalent to 1200 months, 5200 weeks, or 36500 days.
         */
        public var interval: kotlin.Int? = null
        /**
         * The unit of time for time-based retention. For example, to retain snapshots for 3 months, specify `Interval=3` and `IntervalUnit=MONTHS`. Once the snapshot has been retained for 3 months, it is deleted, or it is moved to the archive tier if you have specified an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html).
         */
        public var intervalUnit: aws.sdk.kotlin.services.dlm.model.RetentionIntervalUnitValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.RetainRule) : this() {
            this.count = x.count
            this.interval = x.interval
            this.intervalUnit = x.intervalUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.RetainRule = RetainRule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
