// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the configuration of a lifecycle policy.
 */
public class PolicyDetails private constructor(builder: Builder) {
    /**
     * **&#91;Event-based policies only&#93;** The actions to be performed when the event-based policy is activated. You can specify only one action per policy.
     */
    public val actions: List<Action>? = builder.actions
    /**
     * **&#91;Default policies only&#93;** Indicates whether the policy should copy tags from the source resource to the snapshot or AMI. If you do not specify a value, the default is `false`.
     *
     * Default: false
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * **&#91;Default policies only&#93;** Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
     *
     * Default: 1
     */
    public val createInterval: kotlin.Int? = builder.createInterval
    /**
     * **&#91;Default policies only&#93;** Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
     */
    public val crossRegionCopyTargets: List<CrossRegionCopyTarget>? = builder.crossRegionCopyTargets
    /**
     * **&#91;Event-based policies only&#93;** The event that activates the event-based policy.
     */
    public val eventSource: aws.sdk.kotlin.services.dlm.model.EventSource? = builder.eventSource
    /**
     * **&#91;Default policies only&#93;** Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
     */
    public val exclusions: aws.sdk.kotlin.services.dlm.model.Exclusions? = builder.exclusions
    /**
     * **&#91;Default policies only&#93;** Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
     *
     * By default (**ExtendDeletion=false**):
     * + If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify `true`.
     * + If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify `true`.
     *
     * If you enable extended deletion (**ExtendDeletion=true**), you override both default behaviors simultaneously.
     *
     * If you do not specify a value, the default is `false`.
     *
     * Default: false
     */
    public val extendDeletion: kotlin.Boolean? = builder.extendDeletion
    /**
     * **&#91;Custom snapshot and AMI policies only&#93;** A set of optional parameters for snapshot and AMI lifecycle policies.
     *
     * If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
     */
    public val parameters: aws.sdk.kotlin.services.dlm.model.Parameters? = builder.parameters
    /**
     * The type of policy to create. Specify one of the following:
     * + `SIMPLIFIED` To create a default policy.
     * + `STANDARD` To create a custom policy.
     */
    public val policyLanguage: aws.sdk.kotlin.services.dlm.model.PolicyLanguageValues? = builder.policyLanguage
    /**
     * **&#91;Custom policies only&#93;** The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY ` to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.
     *
     * The default is `EBS_SNAPSHOT_MANAGEMENT`.
     */
    public val policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = builder.policyType
    /**
     * **&#91;Custom snapshot and AMI policies only&#93;** The location of the resources to backup. If the source resources are located in an Amazon Web Services Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`.
     *
     * If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
     */
    public val resourceLocations: List<ResourceLocationValues>? = builder.resourceLocations
    /**
     * **&#91;Default policies only&#93;** Specify the type of default policy to create.
     * + To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify `VOLUME`.
     * + To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify `INSTANCE`.
     */
    public val resourceType: aws.sdk.kotlin.services.dlm.model.ResourceTypeValues? = builder.resourceType
    /**
     * **&#91;Custom snapshot policies only&#93;** The target resource type for snapshot and AMI lifecycle policies. Use `VOLUME `to create snapshots of individual volumes or use `INSTANCE` to create multi-volume snapshots from the volumes for an instance.
     */
    public val resourceTypes: List<ResourceTypeValues>? = builder.resourceTypes
    /**
     * **&#91;Default policies only&#93;** Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
     *
     * Default: 7
     */
    public val retainInterval: kotlin.Int? = builder.retainInterval
    /**
     * **&#91;Custom snapshot and AMI policies only&#93;** The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
     */
    public val schedules: List<Schedule>? = builder.schedules
    /**
     * **&#91;Custom snapshot and AMI policies only&#93;** The single tag that identifies targeted resources for this policy.
     */
    public val targetTags: List<Tag>? = builder.targetTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.PolicyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyDetails(")
        append("actions=$actions,")
        append("copyTags=$copyTags,")
        append("createInterval=$createInterval,")
        append("crossRegionCopyTargets=$crossRegionCopyTargets,")
        append("eventSource=$eventSource,")
        append("exclusions=$exclusions,")
        append("extendDeletion=$extendDeletion,")
        append("parameters=$parameters,")
        append("policyLanguage=$policyLanguage,")
        append("policyType=$policyType,")
        append("resourceLocations=$resourceLocations,")
        append("resourceType=$resourceType,")
        append("resourceTypes=$resourceTypes,")
        append("retainInterval=$retainInterval,")
        append("schedules=$schedules,")
        append("targetTags=$targetTags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (copyTags?.hashCode() ?: 0)
        result = 31 * result + (createInterval ?: 0)
        result = 31 * result + (crossRegionCopyTargets?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (exclusions?.hashCode() ?: 0)
        result = 31 * result + (extendDeletion?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (policyLanguage?.hashCode() ?: 0)
        result = 31 * result + (policyType?.hashCode() ?: 0)
        result = 31 * result + (resourceLocations?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (retainInterval ?: 0)
        result = 31 * result + (schedules?.hashCode() ?: 0)
        result = 31 * result + (targetTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyDetails

        if (actions != other.actions) return false
        if (copyTags != other.copyTags) return false
        if (createInterval != other.createInterval) return false
        if (crossRegionCopyTargets != other.crossRegionCopyTargets) return false
        if (eventSource != other.eventSource) return false
        if (exclusions != other.exclusions) return false
        if (extendDeletion != other.extendDeletion) return false
        if (parameters != other.parameters) return false
        if (policyLanguage != other.policyLanguage) return false
        if (policyType != other.policyType) return false
        if (resourceLocations != other.resourceLocations) return false
        if (resourceType != other.resourceType) return false
        if (resourceTypes != other.resourceTypes) return false
        if (retainInterval != other.retainInterval) return false
        if (schedules != other.schedules) return false
        if (targetTags != other.targetTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.PolicyDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * **&#91;Event-based policies only&#93;** The actions to be performed when the event-based policy is activated. You can specify only one action per policy.
         */
        public var actions: List<Action>? = null
        /**
         * **&#91;Default policies only&#93;** Indicates whether the policy should copy tags from the source resource to the snapshot or AMI. If you do not specify a value, the default is `false`.
         *
         * Default: false
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * **&#91;Default policies only&#93;** Specifies how often the policy should run and create snapshots or AMIs. The creation frequency can range from 1 to 7 days. If you do not specify a value, the default is 1.
         *
         * Default: 1
         */
        public var createInterval: kotlin.Int? = null
        /**
         * **&#91;Default policies only&#93;** Specifies destination Regions for snapshot or AMI copies. You can specify up to 3 destination Regions. If you do not want to create cross-Region copies, omit this parameter.
         */
        public var crossRegionCopyTargets: List<CrossRegionCopyTarget>? = null
        /**
         * **&#91;Event-based policies only&#93;** The event that activates the event-based policy.
         */
        public var eventSource: aws.sdk.kotlin.services.dlm.model.EventSource? = null
        /**
         * **&#91;Default policies only&#93;** Specifies exclusion parameters for volumes or instances for which you do not want to create snapshots or AMIs. The policy will not create snapshots or AMIs for target resources that match any of the specified exclusion parameters.
         */
        public var exclusions: aws.sdk.kotlin.services.dlm.model.Exclusions? = null
        /**
         * **&#91;Default policies only&#93;** Defines the snapshot or AMI retention behavior for the policy if the source volume or instance is deleted, or if the policy enters the error, disabled, or deleted state.
         *
         * By default (**ExtendDeletion=false**):
         * + If a source resource is deleted, Amazon Data Lifecycle Manager will continue to delete previously created snapshots or AMIs, up to but not including the last one, based on the specified retention period. If you want Amazon Data Lifecycle Manager to delete all snapshots or AMIs, including the last one, specify `true`.
         * + If a policy enters the error, disabled, or deleted state, Amazon Data Lifecycle Manager stops deleting snapshots and AMIs. If you want Amazon Data Lifecycle Manager to continue deleting snapshots or AMIs, including the last one, if the policy enters one of these states, specify `true`.
         *
         * If you enable extended deletion (**ExtendDeletion=true**), you override both default behaviors simultaneously.
         *
         * If you do not specify a value, the default is `false`.
         *
         * Default: false
         */
        public var extendDeletion: kotlin.Boolean? = null
        /**
         * **&#91;Custom snapshot and AMI policies only&#93;** A set of optional parameters for snapshot and AMI lifecycle policies.
         *
         * If you are modifying a policy that was created or previously modified using the Amazon Data Lifecycle Manager console, then you must include this parameter and specify either the default values or the new values that you require. You can't omit this parameter or set its values to null.
         */
        public var parameters: aws.sdk.kotlin.services.dlm.model.Parameters? = null
        /**
         * The type of policy to create. Specify one of the following:
         * + `SIMPLIFIED` To create a default policy.
         * + `STANDARD` To create a custom policy.
         */
        public var policyLanguage: aws.sdk.kotlin.services.dlm.model.PolicyLanguageValues? = null
        /**
         * **&#91;Custom policies only&#93;** The valid target resource types and actions a policy can manage. Specify `EBS_SNAPSHOT_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of Amazon EBS snapshots. Specify `IMAGE_MANAGEMENT` to create a lifecycle policy that manages the lifecycle of EBS-backed AMIs. Specify `EVENT_BASED_POLICY ` to create an event-based policy that performs specific actions when a defined event occurs in your Amazon Web Services account.
         *
         * The default is `EBS_SNAPSHOT_MANAGEMENT`.
         */
        public var policyType: aws.sdk.kotlin.services.dlm.model.PolicyTypeValues? = null
        /**
         * **&#91;Custom snapshot and AMI policies only&#93;** The location of the resources to backup. If the source resources are located in an Amazon Web Services Region, specify `CLOUD`. If the source resources are located on an Outpost in your account, specify `OUTPOST`.
         *
         * If you specify `OUTPOST`, Amazon Data Lifecycle Manager backs up all resources of the specified type with matching target tags across all of the Outposts in your account.
         */
        public var resourceLocations: List<ResourceLocationValues>? = null
        /**
         * **&#91;Default policies only&#93;** Specify the type of default policy to create.
         * + To create a default policy for EBS snapshots, that creates snapshots of all volumes in the Region that do not have recent backups, specify `VOLUME`.
         * + To create a default policy for EBS-backed AMIs, that creates EBS-backed AMIs from all instances in the Region that do not have recent backups, specify `INSTANCE`.
         */
        public var resourceType: aws.sdk.kotlin.services.dlm.model.ResourceTypeValues? = null
        /**
         * **&#91;Custom snapshot policies only&#93;** The target resource type for snapshot and AMI lifecycle policies. Use `VOLUME `to create snapshots of individual volumes or use `INSTANCE` to create multi-volume snapshots from the volumes for an instance.
         */
        public var resourceTypes: List<ResourceTypeValues>? = null
        /**
         * **&#91;Default policies only&#93;** Specifies how long the policy should retain snapshots or AMIs before deleting them. The retention period can range from 2 to 14 days, but it must be greater than the creation frequency to ensure that the policy retains at least 1 snapshot or AMI at any given time. If you do not specify a value, the default is 7.
         *
         * Default: 7
         */
        public var retainInterval: kotlin.Int? = null
        /**
         * **&#91;Custom snapshot and AMI policies only&#93;** The schedules of policy-defined actions for snapshot and AMI lifecycle policies. A policy can have up to four schedules—one mandatory schedule and up to three optional schedules.
         */
        public var schedules: List<Schedule>? = null
        /**
         * **&#91;Custom snapshot and AMI policies only&#93;** The single tag that identifies targeted resources for this policy.
         */
        public var targetTags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.PolicyDetails) : this() {
            this.actions = x.actions
            this.copyTags = x.copyTags
            this.createInterval = x.createInterval
            this.crossRegionCopyTargets = x.crossRegionCopyTargets
            this.eventSource = x.eventSource
            this.exclusions = x.exclusions
            this.extendDeletion = x.extendDeletion
            this.parameters = x.parameters
            this.policyLanguage = x.policyLanguage
            this.policyType = x.policyType
            this.resourceLocations = x.resourceLocations
            this.resourceType = x.resourceType
            this.resourceTypes = x.resourceTypes
            this.retainInterval = x.retainInterval
            this.schedules = x.schedules
            this.targetTags = x.targetTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.PolicyDetails = PolicyDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.EventSource] inside the given [block]
         */
        public fun eventSource(block: aws.sdk.kotlin.services.dlm.model.EventSource.Builder.() -> kotlin.Unit) {
            this.eventSource = aws.sdk.kotlin.services.dlm.model.EventSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.Exclusions] inside the given [block]
         */
        public fun exclusions(block: aws.sdk.kotlin.services.dlm.model.Exclusions.Builder.() -> kotlin.Unit) {
            this.exclusions = aws.sdk.kotlin.services.dlm.model.Exclusions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.dlm.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.dlm.model.Parameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
