// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * **&#91;Custom policies only&#93;** Detailed information about a snapshot, AMI, or event-based lifecycle policy.
 */
public class LifecyclePolicy private constructor(builder: Builder) {
    /**
     * The local date and time when the lifecycle policy was created.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The local date and time when the lifecycle policy was last modified.
     */
    public val dateModified: aws.smithy.kotlin.runtime.time.Instant? = builder.dateModified
    /**
     * **&#91;Default policies only&#93;** The type of default policy. Values include:
     * + `VOLUME` - Default policy for EBS snapshots
     * + `INSTANCE` - Default policy for EBS-backed AMIs
     */
    public val defaultPolicy: kotlin.Boolean? = builder.defaultPolicy
    /**
     * The description of the lifecycle policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The Amazon Resource Name (ARN) of the policy.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The configuration of the lifecycle policy
     */
    public val policyDetails: aws.sdk.kotlin.services.dlm.model.PolicyDetails? = builder.policyDetails
    /**
     * The identifier of the lifecycle policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The activation state of the lifecycle policy.
     */
    public val state: aws.sdk.kotlin.services.dlm.model.GettablePolicyStateValues? = builder.state
    /**
     * The description of the status.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The tags.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.LifecyclePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicy(")
        append("dateCreated=$dateCreated,")
        append("dateModified=$dateModified,")
        append("defaultPolicy=$defaultPolicy,")
        append("description=$description,")
        append("executionRoleArn=$executionRoleArn,")
        append("policyArn=$policyArn,")
        append("policyDetails=$policyDetails,")
        append("policyId=$policyId,")
        append("state=$state,")
        append("statusMessage=$statusMessage,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateCreated?.hashCode() ?: 0
        result = 31 * result + (dateModified?.hashCode() ?: 0)
        result = 31 * result + (defaultPolicy?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (policyDetails?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicy

        if (dateCreated != other.dateCreated) return false
        if (dateModified != other.dateModified) return false
        if (defaultPolicy != other.defaultPolicy) return false
        if (description != other.description) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (policyArn != other.policyArn) return false
        if (policyDetails != other.policyDetails) return false
        if (policyId != other.policyId) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.LifecyclePolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The local date and time when the lifecycle policy was created.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The local date and time when the lifecycle policy was last modified.
         */
        public var dateModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * **&#91;Default policies only&#93;** The type of default policy. Values include:
         * + `VOLUME` - Default policy for EBS snapshots
         * + `INSTANCE` - Default policy for EBS-backed AMIs
         */
        public var defaultPolicy: kotlin.Boolean? = null
        /**
         * The description of the lifecycle policy.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the policy.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The configuration of the lifecycle policy
         */
        public var policyDetails: aws.sdk.kotlin.services.dlm.model.PolicyDetails? = null
        /**
         * The identifier of the lifecycle policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The activation state of the lifecycle policy.
         */
        public var state: aws.sdk.kotlin.services.dlm.model.GettablePolicyStateValues? = null
        /**
         * The description of the status.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The tags.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.LifecyclePolicy) : this() {
            this.dateCreated = x.dateCreated
            this.dateModified = x.dateModified
            this.defaultPolicy = x.defaultPolicy
            this.description = x.description
            this.executionRoleArn = x.executionRoleArn
            this.policyArn = x.policyArn
            this.policyDetails = x.policyDetails
            this.policyId = x.policyId
            this.state = x.state
            this.statusMessage = x.statusMessage
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.LifecyclePolicy = LifecyclePolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.PolicyDetails] inside the given [block]
         */
        public fun policyDetails(block: aws.sdk.kotlin.services.dlm.model.PolicyDetails.Builder.() -> kotlin.Unit) {
            this.policyDetails = aws.sdk.kotlin.services.dlm.model.PolicyDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
