// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **&#91;Custom snapshot and AMI policies only&#93;** Specifies a cross-Region copy rule for a snapshot and AMI policies.
 *
 * To specify a cross-Region copy action for event-based polices, use [CrossRegionCopyAction](https://docs.aws.amazon.com/dlm/latest/APIReference/API_CrossRegionCopyAction.html).
 */
public class CrossRegionCopyRule private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.
     */
    public val cmkArn: kotlin.String? = builder.cmkArn
    /**
     * Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * **&#91;Custom AMI policies only&#93;** The AMI deprecation rule for cross-Region AMI copies created by the rule.
     */
    public val deprecateRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule? = builder.deprecateRule
    /**
     * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the destination Region.
     */
    public val retainRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule? = builder.retainRule
    /**
     * Use this parameter for snapshot policies only. For AMI policies, use **TargetRegion** instead.
     *
     * **&#91;Custom snapshot policies only&#93;** The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     */
    public val target: kotlin.String? = builder.target
    /**
     * Use this parameter for AMI policies only. For snapshot policies, use **Target** instead. For snapshot policies created before the **Target** parameter was introduced, this parameter indicates the target Region for snapshot copies.
     *
     * **&#91;Custom AMI policies only&#93;** The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     */
    public val targetRegion: kotlin.String? = builder.targetRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CrossRegionCopyRule(")
        append("cmkArn=$cmkArn,")
        append("copyTags=$copyTags,")
        append("deprecateRule=$deprecateRule,")
        append("encrypted=$encrypted,")
        append("retainRule=$retainRule,")
        append("target=$target,")
        append("targetRegion=$targetRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cmkArn?.hashCode() ?: 0
        result = 31 * result + (copyTags?.hashCode() ?: 0)
        result = 31 * result + (deprecateRule?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (retainRule?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (targetRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CrossRegionCopyRule

        if (cmkArn != other.cmkArn) return false
        if (copyTags != other.copyTags) return false
        if (deprecateRule != other.deprecateRule) return false
        if (encrypted != other.encrypted) return false
        if (retainRule != other.retainRule) return false
        if (target != other.target) return false
        if (targetRegion != other.targetRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified, the default KMS key for the account is used.
         */
        public var cmkArn: kotlin.String? = null
        /**
         * Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * **&#91;Custom AMI policies only&#93;** The AMI deprecation rule for cross-Region AMI copies created by the rule.
         */
        public var deprecateRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule? = null
        /**
         * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the destination Region.
         */
        public var retainRule: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule? = null
        /**
         * Use this parameter for snapshot policies only. For AMI policies, use **TargetRegion** instead.
         *
         * **&#91;Custom snapshot policies only&#93;** The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
         */
        public var target: kotlin.String? = null
        /**
         * Use this parameter for AMI policies only. For snapshot policies, use **Target** instead. For snapshot policies created before the **Target** parameter was introduced, this parameter indicates the target Region for snapshot copies.
         *
         * **&#91;Custom AMI policies only&#93;** The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
         */
        public var targetRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule) : this() {
            this.cmkArn = x.cmkArn
            this.copyTags = x.copyTags
            this.deprecateRule = x.deprecateRule
            this.encrypted = x.encrypted
            this.retainRule = x.retainRule
            this.target = x.target
            this.targetRegion = x.targetRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRule = CrossRegionCopyRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule] inside the given [block]
         */
        public fun deprecateRule(block: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule.Builder.() -> kotlin.Unit) {
            this.deprecateRule = aws.sdk.kotlin.services.dlm.model.CrossRegionCopyDeprecateRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule] inside the given [block]
         */
        public fun retainRule(block: aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule.Builder.() -> kotlin.Unit) {
            this.retainRule = aws.sdk.kotlin.services.dlm.model.CrossRegionCopyRetainRule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
