// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * **&#91;Custom snapshot and AMI policies only&#93;** Specifies when the policy should create snapshots or AMIs.
 *
 * + You must specify either **CronExpression**, or **Interval**, **IntervalUnit**, and **Times**.
 * + If you need to specify an [ArchiveRule](https://docs.aws.amazon.com/dlm/latest/APIReference/API_ArchiveRule.html) for the schedule, then you must specify a creation frequency of at least 28 days.
 */
public class CreateRule private constructor(builder: Builder) {
    /**
     * The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more information, see [Cron expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch User Guide*.
     */
    public val cronExpression: kotlin.String? = builder.cronExpression
    /**
     * The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The interval unit.
     */
    public val intervalUnit: aws.sdk.kotlin.services.dlm.model.IntervalUnitValues? = builder.intervalUnit
    /**
     * **&#91;Custom snapshot policies only&#93;** Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default.
     *
     * If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.
     */
    public val location: aws.sdk.kotlin.services.dlm.model.LocationValues? = builder.location
    /**
     * **&#91;Custom snapshot policies that target instances only&#93;** Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances. This is useful for creating application-consistent snapshots, or for performing specific administrative tasks before or after Amazon Data Lifecycle Manager initiates snapshot creation.
     *
     * For more information, see [Automating application-consistent snapshots with pre and post scripts](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html).
     */
    public val scripts: List<Script>? = builder.scripts
    /**
     * The time, in UTC, to start the operation. The supported format is hh:mm.
     *
     * The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon Data Lifecycle Manager selects a time within the next 24 hours.
     */
    public val times: List<String>? = builder.times

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.CreateRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRule(")
        append("cronExpression=$cronExpression,")
        append("interval=$interval,")
        append("intervalUnit=$intervalUnit,")
        append("location=$location,")
        append("scripts=$scripts,")
        append("times=$times")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cronExpression?.hashCode() ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (intervalUnit?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (scripts?.hashCode() ?: 0)
        result = 31 * result + (times?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRule

        if (cronExpression != other.cronExpression) return false
        if (interval != other.interval) return false
        if (intervalUnit != other.intervalUnit) return false
        if (location != other.location) return false
        if (scripts != other.scripts) return false
        if (times != other.times) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.CreateRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. For more information, see [Cron expressions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions) in the *Amazon CloudWatch User Guide*.
         */
        public var cronExpression: kotlin.String? = null
        /**
         * The interval between snapshots. The supported values are 1, 2, 3, 4, 6, 8, 12, and 24.
         */
        public var interval: kotlin.Int? = null
        /**
         * The interval unit.
         */
        public var intervalUnit: aws.sdk.kotlin.services.dlm.model.IntervalUnitValues? = null
        /**
         * **&#91;Custom snapshot policies only&#93;** Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default.
         *
         * If the policy targets resources in an Amazon Web Services Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost.
         */
        public var location: aws.sdk.kotlin.services.dlm.model.LocationValues? = null
        /**
         * **&#91;Custom snapshot policies that target instances only&#93;** Specifies pre and/or post scripts for a snapshot lifecycle policy that targets instances. This is useful for creating application-consistent snapshots, or for performing specific administrative tasks before or after Amazon Data Lifecycle Manager initiates snapshot creation.
         *
         * For more information, see [Automating application-consistent snapshots with pre and post scripts](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html).
         */
        public var scripts: List<Script>? = null
        /**
         * The time, in UTC, to start the operation. The supported format is hh:mm.
         *
         * The operation occurs within a one-hour window following the specified time. If you do not specify a time, Amazon Data Lifecycle Manager selects a time within the next 24 hours.
         */
        public var times: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.CreateRule) : this() {
            this.cronExpression = x.cronExpression
            this.interval = x.interval
            this.intervalUnit = x.intervalUnit
            this.location = x.location
            this.scripts = x.scripts
            this.times = x.times
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.CreateRule = CreateRule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
