// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * **&#91;Custom snapshot policies that target instances only&#93;** Information about pre and/or post scripts for a snapshot lifecycle policy that targets instances. For more information, see [ Automating application-consistent snapshots with pre and post scripts](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/automate-app-consistent-backups.html).
 */
public class Script private constructor(builder: Builder) {
    /**
     * Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails.
     * + To default to crash consistent snapshot if the pre script fails, specify `true`.
     * + To skip the instance for snapshot creation if the pre script fails, specify `false`.
     *
     * This parameter is supported only if you run a pre script. If you run a post script only, omit this parameter.
     *
     * Default: true
     */
    public val executeOperationOnScriptFailure: kotlin.Boolean? = builder.executeOperationOnScriptFailure
    /**
     * The SSM document that includes the pre and/or post scripts to run.
     * + If you are automating VSS backups, specify `AWS_VSS_BACKUP`. In this case, Amazon Data Lifecycle Manager automatically uses the `AWSEC2-CreateVssSnapshot` SSM document.
     * + If you are automating application-consistent snapshots for SAP HANA workloads, specify `AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA`.
     * + If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document. If you are using a custom SSM document that is shared with you, specify the ARN of the SSM document.
     */
    public val executionHandler: kotlin.String? = builder.executionHandler
    /**
     * Indicates the service used to execute the pre and/or post scripts.
     * + If you are using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify `AWS_SYSTEMS_MANAGER`.
     * + If you are automating VSS Backups, omit this parameter.
     *
     * Default: AWS_SYSTEMS_MANAGER
     */
    public val executionHandlerService: aws.sdk.kotlin.services.dlm.model.ExecutionHandlerServiceValues? = builder.executionHandlerService
    /**
     * Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed. If a script does not complete within its timeout period, Amazon Data Lifecycle Manager fails the attempt. The timeout period applies to the pre and post scripts individually.
     *
     * If you are automating VSS Backups, omit this parameter.
     *
     * Default: 10
     */
    public val executionTimeout: kotlin.Int? = builder.executionTimeout
    /**
     * Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail.
     * + If the pre script fails, Amazon Data Lifecycle Manager retries the entire snapshot creation process, including running the pre and post scripts.
     * + If the post script fails, Amazon Data Lifecycle Manager retries the post script only; in this case, the pre script will have completed and the snapshot might have been created.
     *
     * If you do not want Amazon Data Lifecycle Manager to retry failed scripts, specify `0`.
     *
     * Default: 0
     */
    public val maximumRetryCount: kotlin.Int? = builder.maximumRetryCount
    /**
     * Indicate which scripts Amazon Data Lifecycle Manager should run on target instances. Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation.
     * + To run a pre script only, specify `PRE`. In this case, Amazon Data Lifecycle Manager calls the SSM document with the `pre-script` parameter before initiating snapshot creation.
     * + To run a post script only, specify `POST`. In this case, Amazon Data Lifecycle Manager calls the SSM document with the `post-script` parameter after initiating snapshot creation.
     * + To run both pre and post scripts, specify both `PRE` and `POST`. In this case, Amazon Data Lifecycle Manager calls the SSM document with the `pre-script` parameter before initiating snapshot creation, and then it calls the SSM document again with the `post-script` parameter after initiating snapshot creation.
     *
     * If you are automating VSS Backups, omit this parameter.
     *
     * Default: PRE and POST
     */
    public val stages: List<StageValues>? = builder.stages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.Script = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Script(")
        append("executeOperationOnScriptFailure=$executeOperationOnScriptFailure,")
        append("executionHandler=$executionHandler,")
        append("executionHandlerService=$executionHandlerService,")
        append("executionTimeout=$executionTimeout,")
        append("maximumRetryCount=$maximumRetryCount,")
        append("stages=$stages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = executeOperationOnScriptFailure?.hashCode() ?: 0
        result = 31 * result + (executionHandler?.hashCode() ?: 0)
        result = 31 * result + (executionHandlerService?.hashCode() ?: 0)
        result = 31 * result + (executionTimeout ?: 0)
        result = 31 * result + (maximumRetryCount ?: 0)
        result = 31 * result + (stages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Script

        if (executeOperationOnScriptFailure != other.executeOperationOnScriptFailure) return false
        if (executionHandler != other.executionHandler) return false
        if (executionHandlerService != other.executionHandlerService) return false
        if (executionTimeout != other.executionTimeout) return false
        if (maximumRetryCount != other.maximumRetryCount) return false
        if (stages != other.stages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.Script = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether Amazon Data Lifecycle Manager should default to crash-consistent snapshots if the pre script fails.
         * + To default to crash consistent snapshot if the pre script fails, specify `true`.
         * + To skip the instance for snapshot creation if the pre script fails, specify `false`.
         *
         * This parameter is supported only if you run a pre script. If you run a post script only, omit this parameter.
         *
         * Default: true
         */
        public var executeOperationOnScriptFailure: kotlin.Boolean? = null
        /**
         * The SSM document that includes the pre and/or post scripts to run.
         * + If you are automating VSS backups, specify `AWS_VSS_BACKUP`. In this case, Amazon Data Lifecycle Manager automatically uses the `AWSEC2-CreateVssSnapshot` SSM document.
         * + If you are automating application-consistent snapshots for SAP HANA workloads, specify `AWSSystemsManagerSAP-CreateDLMSnapshotForSAPHANA`.
         * + If you are using a custom SSM document that you own, specify either the name or ARN of the SSM document. If you are using a custom SSM document that is shared with you, specify the ARN of the SSM document.
         */
        public var executionHandler: kotlin.String? = null
        /**
         * Indicates the service used to execute the pre and/or post scripts.
         * + If you are using custom SSM documents or automating application-consistent snapshots of SAP HANA workloads, specify `AWS_SYSTEMS_MANAGER`.
         * + If you are automating VSS Backups, omit this parameter.
         *
         * Default: AWS_SYSTEMS_MANAGER
         */
        public var executionHandlerService: aws.sdk.kotlin.services.dlm.model.ExecutionHandlerServiceValues? = null
        /**
         * Specifies a timeout period, in seconds, after which Amazon Data Lifecycle Manager fails the script run attempt if it has not completed. If a script does not complete within its timeout period, Amazon Data Lifecycle Manager fails the attempt. The timeout period applies to the pre and post scripts individually.
         *
         * If you are automating VSS Backups, omit this parameter.
         *
         * Default: 10
         */
        public var executionTimeout: kotlin.Int? = null
        /**
         * Specifies the number of times Amazon Data Lifecycle Manager should retry scripts that fail.
         * + If the pre script fails, Amazon Data Lifecycle Manager retries the entire snapshot creation process, including running the pre and post scripts.
         * + If the post script fails, Amazon Data Lifecycle Manager retries the post script only; in this case, the pre script will have completed and the snapshot might have been created.
         *
         * If you do not want Amazon Data Lifecycle Manager to retry failed scripts, specify `0`.
         *
         * Default: 0
         */
        public var maximumRetryCount: kotlin.Int? = null
        /**
         * Indicate which scripts Amazon Data Lifecycle Manager should run on target instances. Pre scripts run before Amazon Data Lifecycle Manager initiates snapshot creation. Post scripts run after Amazon Data Lifecycle Manager initiates snapshot creation.
         * + To run a pre script only, specify `PRE`. In this case, Amazon Data Lifecycle Manager calls the SSM document with the `pre-script` parameter before initiating snapshot creation.
         * + To run a post script only, specify `POST`. In this case, Amazon Data Lifecycle Manager calls the SSM document with the `post-script` parameter after initiating snapshot creation.
         * + To run both pre and post scripts, specify both `PRE` and `POST`. In this case, Amazon Data Lifecycle Manager calls the SSM document with the `pre-script` parameter before initiating snapshot creation, and then it calls the SSM document again with the `post-script` parameter after initiating snapshot creation.
         *
         * If you are automating VSS Backups, omit this parameter.
         *
         * Default: PRE and POST
         */
        public var stages: List<StageValues>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.Script) : this() {
            this.executeOperationOnScriptFailure = x.executeOperationOnScriptFailure
            this.executionHandler = x.executionHandler
            this.executionHandlerService = x.executionHandlerService
            this.executionTimeout = x.executionTimeout
            this.maximumRetryCount = x.maximumRetryCount
            this.stages = x.stages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.Script = Script(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
