// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dlm.model



/**
 * **&#91;Event-based policies only&#93;** Specifies an event that activates an event-based policy.
 */
public class EventParameters private constructor(builder: Builder) {
    /**
     * The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
     *
     * For example, specifying `^.*Created for policy: policy-1234567890abcdef0.*$` configures the policy to run only if snapshots created by policy `policy-1234567890abcdef0` are shared with your account.
     */
    public val descriptionRegex: kotlin.String? = builder.descriptionRegex
    /**
     * The type of event. Currently, only snapshot sharing events are supported.
     */
    public val eventType: aws.sdk.kotlin.services.dlm.model.EventTypeValues? = builder.eventType
    /**
     * The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.
     */
    public val snapshotOwner: List<String>? = builder.snapshotOwner

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dlm.model.EventParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventParameters(")
        append("descriptionRegex=$descriptionRegex,")
        append("eventType=$eventType,")
        append("snapshotOwner=$snapshotOwner")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = descriptionRegex?.hashCode() ?: 0
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (snapshotOwner?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventParameters

        if (descriptionRegex != other.descriptionRegex) return false
        if (eventType != other.eventType) return false
        if (snapshotOwner != other.snapshotOwner) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dlm.model.EventParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
         *
         * For example, specifying `^.*Created for policy: policy-1234567890abcdef0.*$` configures the policy to run only if snapshots created by policy `policy-1234567890abcdef0` are shared with your account.
         */
        public var descriptionRegex: kotlin.String? = null
        /**
         * The type of event. Currently, only snapshot sharing events are supported.
         */
        public var eventType: aws.sdk.kotlin.services.dlm.model.EventTypeValues? = null
        /**
         * The IDs of the Amazon Web Services accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified Amazon Web Services accounts shares a snapshot with your account.
         */
        public var snapshotOwner: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dlm.model.EventParameters) : this() {
            this.descriptionRegex = x.descriptionRegex
            this.eventType = x.eventType
            this.snapshotOwner = x.snapshotOwner
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dlm.model.EventParameters = EventParameters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
