// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualGatewaysResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.VirtualGateway
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeVirtualGatewaysOperationDeserializer: HttpDeserialize<DescribeVirtualGatewaysResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeVirtualGatewaysResponse {
        if (!response.status.isSuccess()) {
            throwDescribeVirtualGatewaysError(context, response)
        }
        val builder = DescribeVirtualGatewaysResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeVirtualGatewaysOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeVirtualGatewaysError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeVirtualGatewaysOperationBody(builder: DescribeVirtualGatewaysResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VIRTUALGATEWAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("virtualGateways"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VIRTUALGATEWAYS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VIRTUALGATEWAYS_DESCRIPTOR.index -> builder.virtualGateways =
                    deserializer.deserializeList(VIRTUALGATEWAYS_DESCRIPTOR) {
                        val col0 = mutableListOf<VirtualGateway>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeVirtualGatewayDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
