// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.services.directconnect.model.DeleteInterconnectResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.InterconnectState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteInterconnectOperationDeserializer: HttpDeserialize<DeleteInterconnectResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteInterconnectResponse {
        if (!response.status.isSuccess()) {
            throwDeleteInterconnectError(context, response)
        }
        val builder = DeleteInterconnectResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteInterconnectOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteInterconnectError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteInterconnectOperationBody(builder: DeleteInterconnectResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INTERCONNECTSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("interconnectState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INTERCONNECTSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INTERCONNECTSTATE_DESCRIPTOR.index -> builder.interconnectState = deserializeString().let { InterconnectState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
